(defun pre-encode-file (infile &optional
			       (outfile
				(format nil "~A.pre" infile)))
  (with-open-file (in infile :direction :input)
    (with-open-file (out outfile :direction :output)
      (loop for line = (read-line in nil :eof) until (eq line :eof) do
        (write-line (html-encode-pre-string line)
		    out)))))

;;; Encoding for PRE blocks

(defparameter *html-pre-char-alist*
  '(( #\< . "&lt;"  )
    ( #\> . "&gt;"  )
    ( #\& . "&amp;" )))

(defun html-encode-pre-string (s)
  ;; Converts chars into char sequences as specified by *html-pre-char-alist*.
  (encode-string s *html-pre-char-alist*))

(defun encode-string (s char-map)
  ;; Converts chars into char sequences as specified by the alist char-map.
  ;; Assumes that all transformations make the text longer.
  (let ((outlen 0))
    ;; See how long the output string needs to be.
    (dotimes (i (length s))
      (let ((e (lookup (schar s i) char-map)))
	(incf outlen (if e (length e) 1))))
    ;; If the output would be the same length as the input, no
    ;; encoding is needed.
    (when (= outlen (length s))
      (return-from encode-string s))
    ;; Encode away...
    (let ((output (make-string outlen))
	  (outpos 0))
      (dotimes (i (length s))
	(let* ((c (schar s i))
	       (e (lookup c char-map)))
	  (cond (e (dotimes (ei (length e))
		     (setf (schar output outpos) (schar e ei))
		     (incf outpos)))
		(t (setf (schar output outpos) c)
		   (incf outpos)))))
      (assert (= outpos (length output)))
      output)))

;;; Lookup doesn't signal an error if no entry is found so that we
;;; can use it in conditionals.

(defun lookup (key a-list)
  (cdr (assoc key a-list)))		;assumes (cadr nil) ==> nil
