(in-java-package "xisp")

(define-fields VarRef  ; Lexref?
  (Name name))

(define-fields Literal
  (Object value))

(define-fields Call
  (Expression function)
  (ListOfExpression arguments))

(define-fields If
  (Expression test)
  (Expression ifTrue)
  (Expression ifFalse))

(define-fields Assignment
  (Name to)
  (Expression value))

;;; For a Sequence, just use a ListOfExpression?

(define-fields Sequence
  (ListOfExpression of)) ; expressions

(define-fields And
  (ListOfExpression of)) ; conjuncts

(define-fields Or
  (ListOfExpression of)) ; disjuncts

(define-fields Let
  (ListOfBinding bindings)
  (Expression in))       ; body?

(define-fields Lambda
  (ListOfName parameters)
  (Expression in));      ; body?

(define-fields While
  (Expression test)
  (Expression do))       ; body?

;;; End
