;;; Typical command:
;;;
;;;   gen/gen-classes gen/defs/iscript.lsp iscript

(in-java-package "ix.iscript")

; (define-fields Expression)

(define-fields VarRef (:extends Expression)  ; Lexref?
    (:imports (ix.util.Name))
  (Name name))

(define-fields Literal (:extends Expression)
  (Object value))

(define-fields Call (:extends Expression)
  (Expression function)
  (ListOfExpression arguments))

(define-fields If (:extends Expression)
  (Expression test)
  (Expression ifTrue)
  (Expression ifFalse))

(define-fields Assignment (:extends Expression)
    (:imports (ix.util.Name))
  (Name to)
  (Expression value))

;;; For a Sequence, just use a ListOfExpression?

(define-fields Sequence (:extends Expression)
  (ListOfExpression of)) ; expressions

(define-fields And (:extends Expression)
  (ListOfExpression of)) ; conjuncts

(define-fields Or (:extends Expression)
  (ListOfExpression of)) ; disjuncts

(define-fields Let (:extends Expression)
  (ListOfBinding bindings)
  (Expression in))       ; body?

(define-fields Binding
    (:imports (ix.util.Name))
  (Name name)
  (Expression value))

(define-fields Lambda (:extends Expression)
  (:imports
    (ix.util.Name
     ix.util.ListOfName))
  (ListOfName parameters)
  (Expression in));      ; body?

(define-fields While (:extends Expression)
  (Expression test)
  (Expression repeat))   ; body?

;;; End
