/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 27 14:34:14 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package test;			// not ix.test

import java.awt.event.*;
import java.util.*;

import ix.icore.*;
import ix.ip2.*;
import ix.util.*;
import ix.util.lisp.*;


/**
 * An example of various ways to entend BasicIp2.
 */

public class Ip2Example extends Ip2 {

    public Ip2Example() {
	super();

	// Change some defaults
	displayName = "Ip2 Test Example";
	symbolName = "Example";
	logoLine1 = "Example I-X Process Panel";
	logoLine2 = "Based on I-X Technology";
	logoImage = "ip2-logo.gif";

	domainName = null;

    }

    public static void main(String[] argv) {

	Util.printGreeting("IP2 Test Example");

	new Ip2Example().mainStartup(argv);

    }


    /**
     * Command-line argument processing.
     */
    protected void processCommandLineArguments() {
	super.processCommandLineArguments();
    }


    /**
     * Completes setup and initialization.
     */
    public void startup() {
	super.startup();
    }

    /**
     * Called to add items to the main frame menu bar's "Test" menu.
     */
    protected void addTestMenuItems() {
	super.addTestMenuItems();

	frame.addTestIssue(Priority.HIGH, "consider example");
	frame.addTestIssue(Priority.HIGH, "note example",
			   "Add a note issue");
    }

}
