/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler.test;

import jjtraveler.VisitFailure;
import jjtraveler.Visitable;
import jjtraveler.Visitor;
import jjtraveler.test.Event;
import jjtraveler.test.LogVisitor;
import jjtraveler.test.Logger;

public class TimeLogVisitor
extends LogVisitor {
    long firstInvocationTimeStamp = 0L;
    long lastReturnTimeStamp;
    long consumedTime = 0L;

    public TimeLogVisitor(Visitor v, Logger l) {
        super(v, l);
    }

    public Visitable visit(Visitable visitable) throws VisitFailure {
        long endTime;
        long startTime = System.currentTimeMillis();
        if (this.firstInvocationTimeStamp == 0L) {
            this.firstInvocationTimeStamp = startTime;
        }
        this.logger.log(new Event(this.visitor, visitable));
        Visitable result = this.visitor.visit(visitable);
        this.lastReturnTimeStamp = endTime = System.currentTimeMillis();
        this.consumedTime += endTime - startTime;
        return result;
    }

    public long getElapsedTime() {
        return this.lastReturnTimeStamp - this.firstInvocationTimeStamp;
    }

    public long getConsumedTime() {
        return this.consumedTime;
    }
}

