/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermList;
import aterm.ATermPlaceholder;
import aterm.ParseError;
import aterm.pure.ATermVisitableImpl;
import aterm.pure.ATermWriter;
import aterm.pure.PureFactory;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import jjtraveler.VisitFailure;
import shared.SharedObject;
import shared.SharedObjectWithID;

public abstract class ATermImpl
extends ATermVisitableImpl
implements ATerm,
SharedObjectWithID {
    private ATermList annotations;
    protected static PureFactory factory;
    private int hashCode;
    private int uniqueId;

    public static void initialize(PureFactory f) {
        factory = f;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public abstract SharedObject duplicate();

    protected void setHashCode(int hashcode) {
        this.hashCode = hashcode;
    }

    protected void internSetAnnotations(ATermList annos) {
        this.annotations = annos;
    }

    protected void init(int hashCode, ATermList annos) {
        this.hashCode = hashCode;
        this.annotations = annos;
    }

    public boolean equivalent(SharedObject obj) {
        try {
            return ((ATerm)((Object)obj)).getType() == this.getType() && ((ATerm)((Object)obj)).getAnnotations().equals(this.getAnnotations());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected static PureFactory getStaticFactory() {
        return factory;
    }

    public ATermFactory getFactory() {
        return ATermImpl.getStaticFactory();
    }

    protected PureFactory getPureFactory() {
        return ATermImpl.getStaticFactory();
    }

    public ATerm setAnnotation(ATerm label, ATerm anno) {
        ATermList new_annos = this.annotations.dictPut(label, anno);
        ATerm result = this.setAnnotations(new_annos);
        return result;
    }

    public ATerm removeAnnotation(ATerm label) {
        return this.setAnnotations(this.annotations.dictRemove(label));
    }

    public ATerm getAnnotation(ATerm label) {
        return this.annotations.dictGet(label);
    }

    public ATerm removeAnnotations() {
        return this.setAnnotations(PureFactory.empty);
    }

    public ATermList getAnnotations() {
        return this.annotations;
    }

    public List match(String pattern) throws ParseError {
        return this.match(factory.parsePattern(pattern));
    }

    public List match(ATerm pattern) {
        LinkedList list = new LinkedList();
        if (this.match(pattern, list)) {
            return list;
        }
        return null;
    }

    public boolean isEqual(ATerm term) {
        if (term instanceof ATermImpl) {
            return this == term;
        }
        return factory.isDeepEqual(this, term);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ATermImpl) {
            return this == obj;
        }
        if (obj instanceof ATerm) {
            return factory.isDeepEqual(this, (ATerm)obj);
        }
        return false;
    }

    boolean match(ATerm pattern, List list) {
        ATermAppl appl;
        AFun afun;
        ATerm type;
        if (pattern.getType() == 5 && (type = ((ATermPlaceholder)pattern).getPlaceholder()).getType() == 3 && (afun = (appl = (ATermAppl)type).getAFun()).getName().equals("term") && afun.getArity() == 0 && !afun.isQuoted()) {
            list.add(this);
            return true;
        }
        return false;
    }

    public ATerm make(List list) {
        return this;
    }

    public void writeToTextFile(ATermWriter writer) throws IOException {
        try {
            writer.visitChild(this);
            writer.getStream().flush();
        }
        catch (VisitFailure e) {
            throw new IOException(e.getMessage());
        }
    }

    public void writeToSharedTextFile(OutputStream stream) throws IOException {
        ATermWriter writer = new ATermWriter(new BufferedOutputStream(stream));
        writer.initializeSharing();
        stream.write(33);
        this.writeToTextFile(writer);
    }

    public void writeToTextFile(OutputStream stream) throws IOException {
        ATermWriter writer = new ATermWriter(new BufferedOutputStream(stream));
        this.writeToTextFile(writer);
    }

    public String toString() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ATermWriter writer = new ATermWriter(stream);
            this.writeToTextFile(writer);
            return stream.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e.getMessage());
        }
    }

    public int getNrSubTerms() {
        return 0;
    }

    public ATerm getSubTerm(int index) {
        throw new RuntimeException("no children!");
    }

    public ATerm setSubTerm(int index, ATerm t) {
        throw new RuntimeException("no children!");
    }

    public int getUniqueIdentifier() {
        return this.uniqueId;
    }

    public void setUniqueIdentifier(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    public abstract int getType();

    public abstract ATerm setAnnotations(ATermList var1);
}

