/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.HashSet;
import java.util.Hashtable;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.TuBox;

public class TgBox
extends TBox {
    static int totalsizes = 0;

    public TgBox() {
    }

    public TgBox(ATermList list) {
        super(list);
    }

    public static void printStatistics() {
        System.out.println("\nTg Statistics:\nSize of Tg: " + totalsizes);
    }

    public ATermList internalize() {
        ATermList conjuncts = ATermUtils.makeList();
        ATermList termlist = this.toList();
        while (!termlist.isEmpty()) {
            ATermAppl nota;
            ATermAppl b;
            ATermAppl a;
            ATermAppl def = (ATermAppl)termlist.getFirst();
            Object newdef = null;
            if (def.getName().equals(ATermUtils.SAME)) {
                a = (ATermAppl)def.getArgument(0);
                b = (ATermAppl)def.getArgument(1);
                nota = ATermUtils.makeNot((ATerm)a);
                ATermAppl notb = ATermUtils.makeNot((ATerm)b);
                ATerm ora = ATermUtils.makeOr((ATerm)a, (ATerm)notb);
                ATerm orb = ATermUtils.makeOr((ATerm)nota, (ATerm)b);
                conjuncts = conjuncts.insert(ora);
                conjuncts = conjuncts.insert(orb);
            } else if (def.getName().equals(ATermUtils.SUB)) {
                a = (ATermAppl)def.getArgument(0);
                b = (ATermAppl)def.getArgument(1);
                nota = ATermUtils.makeNot((ATerm)a);
                ATerm or = ATermUtils.makeOr((ATerm)nota, (ATerm)b);
                conjuncts = conjuncts.insert(or);
            } else {
                throw new RuntimeException("Bad TBox - had term of unknown type (" + def.getName() + ")");
            }
            termlist = termlist.getNext();
        }
        return conjuncts;
    }

    public void absorb(TuBox tu) {
        this.Tu = tu;
        ATermList terms = ATermUtils.makeList();
        ATermList list = this.toList();
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (term.getName().equals(ATermUtils.SUB)) {
                terms = terms.insert((ATerm)term);
            } else if (term.getName().equals(ATermUtils.SAME)) {
                ATermAppl sub1 = ATermUtils.makeSub(term.getArgument(0), term.getArgument(1));
                ATermAppl sub2 = ATermUtils.makeSub(term.getArgument(1), term.getArgument(0));
                terms = terms.insert((ATerm)sub1).insert((ATerm)sub2);
            } else {
                throw new RuntimeException("Term list contains something not a SUB or a SAME: " + term);
            }
            list = list.getNext();
        }
        this.termhash = new Hashtable();
        while (!terms.isEmpty()) {
            ATermAppl term = (ATermAppl)terms.getFirst();
            HashSet<ATerm> set = new HashSet<ATerm>();
            set.add(ATermUtils.nnf(term.getArgument(0)));
            set.add(ATermUtils.nnf((ATerm)ATermUtils.makeNot(term.getArgument(1))));
            this.absorbTerm(set);
            terms = terms.getNext();
        }
        totalsizes += this.toList().getLength();
    }

    private boolean absorbTerm(HashSet set) {
        do {
            if (!this.absorbII(set)) continue;
            return true;
        } while (this.absorbIII(set) || this.absorbIV(set) || this.absorbV(set));
        if (this.absorbVI(set)) {
            return true;
        }
        this.absorbVII(set);
        return false;
    }

    private boolean absorbI(HashSet set) {
        ATermList list = ATermUtils.setToList(set);
        while (!list.isEmpty()) {
            ATermAppl name = (ATermAppl)list.getFirst();
            if (name.getArity() <= 0) {
                ATermAppl newdef;
                HashSet newset = new HashSet(set);
                newset.remove(name);
                if (newset.size() > 0) {
                    ATermList newlist = ATermUtils.setToList(newset);
                    newdef = ATermUtils.makeSub((ATerm)name, ATermUtils.nnf((ATerm)ATermUtils.makeNot(ATermUtils.makeAnd(newlist))));
                } else {
                    newdef = ATermUtils.makeSub((ATerm)name, ATermUtils.nnf((ATerm)ATermUtils.makeNot((ATerm)name)));
                }
                if (this.Tu.addIfUnfoldable(newdef)) {
                    return true;
                }
            }
            list = list.getNext();
        }
        return false;
    }

    private boolean absorbII(HashSet set) {
        ATermList list = ATermUtils.setToList(set);
        while (!list.isEmpty()) {
            TermDefinition td;
            ATermAppl def;
            ATermAppl term = (ATermAppl)list.getFirst();
            if (this.Tu.contains((ATerm)term) && (def = (td = this.Tu.getTD((ATerm)term)).getDef(0)).getName().equals(ATermUtils.SUB)) {
                set.remove(term);
                ATermList setlist = ATermUtils.setToList(set);
                ATerm conjunct = ATermUtils.makeAnd(setlist);
                conjunct = ATermUtils.makeAnd(def.getArgument(1), (ATerm)ATermUtils.makeNot(conjunct));
                ATermAppl sub = ATermUtils.makeSub((ATerm)term, ATermUtils.nnf(conjunct));
                td.replaceDef(0, sub);
                return true;
            }
            list = list.getNext();
        }
        return false;
    }

    private boolean absorbIII(HashSet set) {
        ATermList list = ATermUtils.setToList(set);
        while (!list.isEmpty()) {
            TermDefinition td;
            ATermAppl def;
            ATermAppl term = (ATermAppl)list.getFirst();
            if (this.Tu.contains((ATerm)term) && (def = (td = this.Tu.getTD((ATerm)term)).getDef(0)).getName().equals(ATermUtils.SAME)) {
                set.remove(term);
                set.add(def.getArgument(1));
                return true;
            }
            list = list.getNext();
        }
        return false;
    }

    private boolean absorbIV(HashSet set) {
        ATermList list = ATermUtils.setToList(set);
        while (!list.isEmpty()) {
            ATermAppl def;
            ATermAppl term = (ATermAppl)list.getFirst();
            ATermAppl negatedTerm = (ATermAppl)ATermUtils.nnf((ATerm)ATermUtils.makeNot((ATerm)term));
            if (this.Tu.contains((ATerm)negatedTerm) && (def = this.Tu.getTD((ATerm)negatedTerm).getDef(0)).getName().equals(ATermUtils.SAME)) {
                set.remove(term);
                set.add(ATermUtils.nnf((ATerm)ATermUtils.makeNot(def.getArgument(1))));
            }
            list = list.getNext();
        }
        return false;
    }

    private boolean absorbV(HashSet set) {
        ATermList list = ATermUtils.setToList(set);
        list = (ATermList)ATermUtils.nnf((ATerm)list);
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (term.getName().equals(ATermUtils.AND)) {
                set.remove(term);
                ATermList andlist = ATermUtils.andToList(term);
                while (!andlist.isEmpty()) {
                    set.add(andlist.getFirst());
                    andlist = andlist.getNext();
                }
                return true;
            }
            list = list.getNext();
        }
        return false;
    }

    private boolean absorbVI(HashSet set) {
        ATermList list = ATermUtils.setToList(set);
        list = (ATermList)ATermUtils.nnf((ATerm)list);
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (term.getName().equals(ATermUtils.OR)) {
                set.remove(term);
                ATermList orlist = ATermUtils.orToList(term);
                while (!orlist.isEmpty()) {
                    HashSet cloned = (HashSet)set.clone();
                    cloned.add(orlist.getFirst());
                    this.absorbTerm(cloned);
                    orlist = orlist.getNext();
                }
                return true;
            }
            list = list.getNext();
        }
        return false;
    }

    private boolean absorbVII(HashSet set) {
        ATermList list = ATermUtils.setToList(set);
        ATermAppl name = (ATermAppl)ATermUtils.nnf((ATerm)((ATermAppl)list.getFirst()));
        if ((list = list.getNext()).isEmpty()) {
            this.addDef(ATermUtils.makeSub((ATerm)name, ATermUtils.nnf((ATerm)ATermUtils.makeNot((ATerm)name))));
        } else {
            this.addDef(ATermUtils.makeSub((ATerm)name, ATermUtils.nnf((ATerm)ATermUtils.makeNot(ATermUtils.makeAnd(list)))));
        }
        return true;
    }
}

