/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.mindswap.pellet.ATermUtils;

public class TermDefinition {
    ATermAppl sub;
    Vector samelist;
    HashSet seen;
    static ATermFactory factory = ATermUtils.getFactory();

    public TermDefinition() {
        this.sub = null;
        this.samelist = new Vector();
        this.seen = new HashSet();
    }

    public TermDefinition(TermDefinition td) {
        this.sub = td.sub;
        this.samelist = new Vector(td.samelist);
        this.seen = new HashSet(td.seen);
    }

    public ATermAppl getName() {
        ATermAppl name = null;
        if (this.size() > 0) {
            name = (ATermAppl)this.getDef(0).getArgument(0);
        }
        return name;
    }

    public void addDef(ATermAppl appl) {
        if (this.seen.contains(appl)) {
            return;
        }
        this.seen.add(appl);
        String name = appl.getName();
        if (name.equals(ATermUtils.SUB)) {
            if (this.sub != null) {
                ATerm conjunct = ATermUtils.makeAnd(appl.getArgument(1), this.sub.getArgument(1));
                this.sub = this.sub.setArgument(conjunct, 1);
            } else {
                this.sub = appl;
            }
        } else if (name.equals(ATermUtils.SAME)) {
            this.samelist.add(appl);
        } else {
            throw new RuntimeException("Cannot add non-definition!");
        }
    }

    public void removeDef(int i) {
        if (this.sub != null) {
            if (i == 0) {
                this.seen.remove(this.sub);
                this.sub = null;
            }
            --i;
        }
        if (i >= 0) {
            this.seen.remove(this.samelist.get(i));
            this.samelist.remove(i);
        }
    }

    public void replaceDef(int i, ATermAppl appl) {
        this.removeDef(i);
        this.addDef(appl);
    }

    public boolean isUnique() {
        return this.sub != null && this.samelist.size() == 0 || this.sub == null && this.samelist.size() == 1;
    }

    public boolean isGCI() {
        ATermAppl term = this.getDef(0);
        return ((ATermAppl)term.getArgument(0)).getArity() != 0;
    }

    public ATermList toList() {
        ATermList list = factory.makeList();
        Enumeration e = this.samelist.elements();
        while (e.hasMoreElements()) {
            ATermAppl appl = (ATermAppl)e.nextElement();
            list = list.insert((ATerm)appl);
        }
        if (this.sub != null) {
            list = list.insert((ATerm)this.sub);
        }
        return list;
    }

    public ATermAppl getDef(int i) {
        if (this.sub != null) {
            if (i == 0) {
                return this.sub;
            }
            --i;
        }
        return (ATermAppl)this.samelist.get(i);
    }

    public int size() {
        int s = this.samelist.size();
        if (this.sub != null) {
            ++s;
        }
        return s;
    }

    public String toString() {
        return this.toList().toString();
    }
}

