/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermList;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.TgBox;
import org.mindswap.pellet.TuBox;

public class TBox {
    public static final boolean DEBUG = false;
    static ATermFactory factory = ATermUtils.getFactory();
    Hashtable termhash = new Hashtable();
    static boolean hookset = false;
    static long splittime = 0L;
    static long absorbtime = 0L;
    public HashSet classes = new HashSet();
    TuBox Tu;
    TgBox Tg;
    static Exception lastException = null;

    public TBox() {
    }

    public TBox(ATermList alist) {
        ATermAppl newterm = null;
        while (!alist.isEmpty()) {
            newterm = (ATermAppl)alist.getFirst();
            this.addDef(newterm);
            alist = alist.getNext();
        }
    }

    public void addPrintHook() {
        if (hookset) {
            return;
        }
        hookset = true;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                TBox.printStatistics();
                TuBox.printStatistics();
                TgBox.printStatistics();
            }
        });
    }

    public static void printStatistics() {
        System.out.println("\nTBox Statistics:");
        System.out.println("Time spent in createSplitTBox:" + splittime);
        System.out.println("Time spent in absorb:" + absorbtime);
    }

    public static TBox oldSplit(ATermList axioms) {
        long time = System.currentTimeMillis();
        TBox temp = new TBox();
        temp.Tu = new TuBox();
        temp.Tg = new TgBox();
        ATermList alist = axioms;
        while (!alist.isEmpty()) {
            boolean unfoldable = true;
            ATermAppl term = (ATermAppl)alist.getFirst();
            boolean addedTg = false;
            if (!temp.Tu.addIfUnfoldable(term)) {
                if (term.getName().equals(ATermUtils.SAME)) {
                    ATermAppl name = (ATermAppl)term.getArgument(0);
                    ATermAppl desc = (ATermAppl)term.getArgument(1);
                    ATermAppl reversedTerm = ATermUtils.makeSame((ATerm)desc, (ATerm)name);
                    if (!temp.Tu.addIfUnfoldable(reversedTerm)) {
                        temp.Tg.addDef(term);
                        unfoldable = false;
                        addedTg = true;
                    }
                } else {
                    temp.Tg.addDef(term);
                    unfoldable = false;
                    addedTg = true;
                }
            }
            alist = alist.getNext();
        }
        splittime += System.currentTimeMillis() - time;
        return temp;
    }

    public static TBox createSplitTBox(ATermList axioms) {
        long time = System.currentTimeMillis();
        TuBox stage1 = new TuBox(axioms);
        super.split();
        if (!stage1.Tu.isUnfoldable()) {
            throw new RuntimeException("Split failed to produce unfoldable Tu!");
        }
        TBox stage2 = new TBox();
        stage2.Tu = new TuBox();
        stage2.Tg = new TgBox();
        ATermList list = stage1.Tg.toList();
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (!stage2.Tu.addIfUnfoldable(term)) {
                stage2.Tg.addDef(term);
            }
            list = list.getNext();
        }
        stage2.Tu = new TuBox(stage2.Tu.toList().concat(stage1.Tu.toList()));
        splittime += System.currentTimeMillis() - time;
        if (!stage2.Tu.isUnfoldable()) {
            throw new RuntimeException("Tu isn't unfoldable!!");
        }
        return stage2;
    }

    private void split() {
        TuBox temp = new TuBox(this.toList());
        this.Tu = new TuBox();
        this.Tg = new TgBox();
        Enumeration e = temp.termhash.elements();
        while (e.hasMoreElements()) {
            ATermAppl keyTerm;
            TermDefinition td = (TermDefinition)e.nextElement();
            ATermAppl tdterm = (ATermAppl)td.getDef(0).getArgument(1);
            ATermAppl key = keyTerm = (ATermAppl)td.getDef(0).getArgument(0);
            if (td.isUnique() && !td.isGCI()) {
                try {
                    ATermAppl appl = temp.unfoldTerm(tdterm);
                    this.Tu.termhash.put(key, td);
                }
                catch (TuBox.NotUnfoldableException notunfoldable) {
                    this.Tg.termhash.put(key, td);
                }
                continue;
            }
            this.Tg.termhash.put(key, td);
        }
    }

    public void absorb() {
        long time = System.currentTimeMillis();
        this.Tg.absorb(this.Tu);
        absorbtime += System.currentTimeMillis() - time;
    }

    private String getLHS(ATermAppl appl) {
        return ((ATermAppl)appl.getArgument(0)).toString();
    }

    public boolean isEmpty() {
        return this.termhash.size() == 0;
    }

    public int size() {
        return this.toList().getLength();
    }

    public TermDefinition getTD(ATerm name) {
        return (TermDefinition)this.termhash.get(name);
    }

    public boolean contains(ATerm name) {
        return this.termhash.containsKey(name);
    }

    public void addDef(ATermAppl def) {
        ATermAppl name = (ATermAppl)def.getArgument(0);
        if (this.termhash.containsKey(name)) {
            this.getTD((ATerm)name).addDef(def);
        } else {
            TermDefinition td = new TermDefinition();
            td.addDef(def);
            this.termhash.put(name, td);
        }
    }

    public String toString() {
        return this.termhash.toString();
    }

    public ATermList toList() {
        ATermList terms = ATermUtils.makeList();
        Enumeration e = this.termhash.elements();
        while (e.hasMoreElements()) {
            TermDefinition td = (TermDefinition)e.nextElement();
            terms = td.toList().concat(terms);
        }
        return terms;
    }

    public static void main(String[] args) {
        ATermFactory factory = ATermUtils.getFactory();
        TBox tbox = null;
        ATerm t = null;
        try {
            if (args.length > 0) {
                FileInputStream input = new FileInputStream(args[0]);
                t = factory.readFromTextFile((InputStream)input);
            } else {
                t = factory.parse("[same(or(a,or(b,c)),or(x,y))]");
                t = factory.parse("[sub(not(a),and(or(b,or(c,not(y))),or(b,or(c,not(x))))),sub(not(y),and(or(not(b),x),or(x,not(a)))),sub(c,or(x,y))]}");
            }
            System.out.println(t);
            tbox = TBox.oldSplit((ATermList)t);
            tbox.absorb();
            try {
                System.out.println("\nUnfolded TBox:\n" + tbox.Tu);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                System.out.println("\nInternalized TBox:\n" + tbox.Tg.internalize());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (args.length > 1) {
                ATermAppl conceptname = ATermUtils.makeTermAppl(args[1]);
                System.out.println("\nConcept for " + conceptname);
                System.out.println(ATermUtils.simplify((ATerm)tbox.Tu.getTD((ATerm)conceptname).getDef(0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class TBoxException
    extends Exception {
        public TBoxException() {
        }

        public TBoxException(String e) {
            super(e);
        }
    }
}

