/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.OWLReasoner;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.Role;

public class Query {
    public static boolean DEBUG = false;
    private OWLReasoner reasoner = null;
    private Vector variables = new Vector();
    private Vector triples = new Vector();

    public Query() {
    }

    public Query(String s) {
        this(new com.hp.hpl.jena.rdql.Query(s));
    }

    public Query(com.hp.hpl.jena.rdql.Query query) {
        Iterator i = query.getTriplePatterns().iterator();
        while (i.hasNext()) {
            com.hp.hpl.jena.graph.Triple t = (com.hp.hpl.jena.graph.Triple)i.next();
            this.addTriple(t.getSubject().toString(), t.getPredicate().toString(), t.getObject().toString());
        }
    }

    private boolean isVariable(ATermAppl a) {
        return a.getName().charAt(0) == '?';
    }

    private VarSpec getSpec(ATermAppl a) {
        VarSpec spec = null;
        Iterator i = this.variables.iterator();
        while (i.hasNext()) {
            VarSpec s = (VarSpec)i.next();
            if (!s.name.equals((Object)a)) continue;
            spec = s;
            break;
        }
        if (spec == null) {
            spec = new VarSpec();
            spec.name = a;
            spec.isVariable = this.isVariable(a);
            this.variables.add(spec);
        }
        return spec;
    }

    public void addTriple(String s, String p, String o) {
        this.addTriple(ATermUtils.makeTermAppl(s), ATermUtils.makeTermAppl(p), ATermUtils.makeTermAppl(o));
    }

    public void addTriple(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.triples.add(new Triple(s, p, o));
        VarSpec subj = this.getSpec(s);
        VarSpec obj = this.getSpec(o);
        if (p.getName().equals(RDF.type.getURI())) {
            subj.types.add(o);
        } else if (!p.getName().equals(OWL.sameAs.getURI()) && !p.getName().equals(OWL.differentFrom.getURI())) {
            if (p.getName().startsWith(RDF.getURI()) || p.getName().startsWith("http://www.w3.org/2002/07/owl#") || p.getName().startsWith(RDFS.getURI())) {
                throw new RuntimeException("Predicates that belong to [RDF, RDFS, OWL] namespaces cannot be used in ABoxQuery: " + p);
            }
            if (p.getName().charAt(0) == '?') {
                throw new RuntimeException("Variable predicates cannot be used in ABoxQuery");
            }
            subj.outEdges.add(p);
            obj.inEdges.add(p);
        }
    }

    public void setData(ABox abox) {
        this.reasoner = new OWLReasoner();
        this.reasoner.setABox(abox);
    }

    public void setData(OWLReasoner r) {
        this.reasoner = r;
    }

    private boolean init() {
        if (!this.isQuerySatisfied()) {
            return false;
        }
        Iterator vars = this.variables.iterator();
        while (vars.hasNext()) {
            Role role;
            ATerm r;
            VarSpec spec = (VarSpec)vars.next();
            if (!spec.isVariable) continue;
            HashSet<ATerm> types = new HashSet<ATerm>();
            types.addAll(spec.types);
            Iterator i = spec.outEdges.iterator();
            while (i.hasNext()) {
                r = (ATerm)i.next();
                role = this.reasoner.getABox().rbox.getRole(r);
                if (role == null) {
                    throw new RuntimeException("Query is using " + r + " which is not a defined property!");
                }
                ATermList domains = role.getDomain();
                while (!domains.isEmpty()) {
                    types.add(domains.getFirst());
                    domains = domains.getNext();
                }
            }
            i = spec.inEdges.iterator();
            while (i.hasNext()) {
                r = (ATerm)i.next();
                role = this.reasoner.getABox().rbox.getRole(r);
                if (role == null) {
                    throw new RuntimeException("Query is using " + r + " which is not a defined property!");
                }
                ATermList ranges = role.getRange();
                while (!ranges.isEmpty()) {
                    types.add(ranges.getFirst());
                    ranges = ranges.getNext();
                }
            }
            i = types.iterator();
            if (i.hasNext()) {
                while (i.hasNext()) {
                    ATerm c = (ATerm)i.next();
                    Vector instances = this.reasoner.getClassification().getInstances(c);
                    if (spec.possibleBindings == null) {
                        spec.possibleBindings = instances;
                        continue;
                    }
                    spec.possibleBindings.retainAll(instances);
                }
            } else {
                spec.possibleBindings = new Vector();
                spec.possibleBindings.addAll(this.reasoner.getABox().getNodeNames());
            }
            spec.nextBinding = 0;
        }
        return true;
    }

    public Vector exec() {
        Pellet.timers.startTimer("queryExec");
        if (this.reasoner == null) {
            throw new RuntimeException("No input data set is given for query!");
        }
        Pellet.timers.startTimer("queryInit");
        if (!this.init()) {
            return null;
        }
        Pellet.timers.stopTimer("queryInit");
        Vector results = this.exec(0, new Hashtable());
        Pellet.timers.stopTimer("queryExec");
        if (results.size() == 0) {
            return null;
        }
        return results;
    }

    private Vector exec(int index, Hashtable binding) {
        boolean hasVariable;
        Vector results = new Vector();
        if (this.triples.size() <= index) {
            results.add(binding);
            return results;
        }
        Triple triple = (Triple)this.triples.get(index);
        Vector<ATermAppl> sValues = new Vector<ATermAppl>();
        Vector<ATermAppl> oValues = new Vector<ATermAppl>();
        boolean bl = hasVariable = this.isVariable(triple.s) || this.isVariable(triple.o);
        if (hasVariable) {
            if (this.isVariable(triple.s)) {
                if (binding.containsKey(triple.s)) {
                    sValues.add((ATermAppl)binding.get(triple.s));
                } else {
                    sValues.addAll(this.getSpec((ATermAppl)triple.s).possibleBindings);
                }
            } else {
                sValues.add(triple.s);
            }
            if (this.isVariable(triple.o)) {
                if (binding.containsKey(triple.o)) {
                    oValues.add((ATermAppl)binding.get(triple.o));
                } else {
                    oValues.addAll(this.getSpec((ATermAppl)triple.o).possibleBindings);
                }
            } else {
                oValues.add(triple.o);
            }
            Iterator i = sValues.iterator();
            while (i.hasNext()) {
                ATermAppl sValue = (ATermAppl)i.next();
                Iterator j = oValues.iterator();
                while (j.hasNext()) {
                    ATermAppl oValue = (ATermAppl)j.next();
                    if (!this.isTripleSatisfied(sValue, triple.p, oValue)) continue;
                    Hashtable newBinding = (Hashtable)binding.clone();
                    if (this.isVariable(triple.s)) {
                        newBinding.put(triple.s, sValue);
                    }
                    if (this.isVariable(triple.o)) {
                        newBinding.put(triple.o, oValue);
                    }
                    Vector newResults = this.exec(index + 1, newBinding);
                    results.addAll(newResults);
                }
            }
        } else {
            results = this.exec(index + 1, binding);
        }
        return results;
    }

    private boolean isQuerySatisfied() {
        boolean querySatisfied = true;
        Iterator i = this.triples.iterator();
        while (querySatisfied && i.hasNext()) {
            boolean hasVariable;
            Triple triple = (Triple)i.next();
            boolean bl = hasVariable = this.isVariable(triple.s) || this.isVariable(triple.o);
            if (hasVariable) continue;
            querySatisfied = this.isTripleSatisfied(triple.s, triple.p, triple.o);
        }
        return querySatisfied;
    }

    private boolean isTripleSatisfied(ATermAppl s, ATermAppl p, ATermAppl o) {
        Pellet.timers.startTimer("tripleSatisified");
        if (this.isVariable(s) || this.isVariable(o)) {
            throw new RuntimeException("No value assigned to variables when checking triple in query!");
        }
        boolean tripleSatisfied = false;
        tripleSatisfied = p.getName().equals(RDF.type.getURI()) ? this.reasoner.isType((ATerm)s, (ATerm)o) : (p.getName().equals(OWL.sameAs.getURI()) ? this.reasoner.isSameAs((ATerm)s, (ATerm)o) : (p.getName().equals(OWL.differentFrom.getURI()) ? this.reasoner.isDifferentFrom((ATerm)s, (ATerm)o) : this.reasoner.hasPropertyValue((ATerm)s, (ATerm)p, (ATerm)o)));
        Pellet.timers.stopTimer("tripleSatisified");
        return tripleSatisfied;
    }

    public String toString() {
        return this.triples.toString();
    }

    class Triple {
        ATermAppl s;
        ATermAppl p;
        ATermAppl o;

        Triple(ATermAppl s, ATermAppl p, ATermAppl o) {
            this.s = s;
            this.p = p;
            this.o = o;
        }

        public String toString() {
            return "(" + this.s + ", " + this.p + ", " + this.o + ")";
        }
    }

    class VarSpec {
        ATerm name;
        boolean isVariable;
        Vector types = new Vector();
        boolean allBindingsFound = false;
        int nextBinding = -1;
        Vector possibleBindings = null;
        Vector inEdges = new Vector();
        Vector outEdges = new Vector();

        VarSpec() {
        }

        public String toString() {
            return "(" + this.name + " -> " + this.types + " " + (this.possibleBindings == null ? -1 : this.possibleBindings.size()) + ")";
        }
    }
}

