/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DatatypeReasoner;
import org.mindswap.pellet.OWLParser;
import org.mindswap.pellet.OWLReasoner;
import org.mindswap.pellet.OWLTest;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.TestVocabulary;
import org.mindswap.pellet.TimeoutException;
import org.mindswap.pellet.UnsupportedFeatureException;

public class OWLTest {
    public static boolean DEBUG = false;
    public static int timeout = 10;
    public static final int NO_STATS = 0;
    public static final int SHORT_STATS = 1;
    public static final int LONG_STATS = 2;
    public static final int ALL_STATS = 3;
    public static int SHOW_STATS = 3;
    public static boolean USE_CACHE = false;
    public static String base = USE_CACHE ? "file://C/Mindswap/owl-test/" : "http://www.w3.org/2002/03owlt/editors-draft/draft/";
    public static boolean OUTPUT_DL = false;
    static final List TYPES = Arrays.asList(TestVocabulary.NotOwlFeatureTest, TestVocabulary.PositiveEntailmentTest, TestVocabulary.NegativeEntailmentTest, TestVocabulary.TrueTest, TestVocabulary.OWLforOWLTest, TestVocabulary.ConsistencyTest, TestVocabulary.InconsistencyTest, TestVocabulary.ImportEntailmentTest, TestVocabulary.ImportLevelTest);
    static final List LEVELS = Arrays.asList(TestVocabulary.Lite, TestVocabulary.DL, TestVocabulary.Full);
    static final List STATUS = Arrays.asList(TestVocabulary.Approved, TestVocabulary.Proposed, TestVocabulary.ExtraCredit, TestVocabulary.Obsoleted);
    int syntacticTestCount = 0;
    int syntacticTestPass = 0;
    public static final int TEST_PASS = 0;
    public static final int TEST_FAIL = 1;
    public static final int TEST_SKIP = 2;
    public static final List RESULTS = Arrays.asList("PASS", "FAIL", "SKIP");
    int[][][][] stats = new int[LEVELS.size()][STATUS.size()][TYPES.size()][RESULTS.size()];
    Vector results = new Vector();
    static int MAX_TEST_COUNT = Integer.MAX_VALUE;
    static String allTests = String.valueOf(base) + "Manifest.rdf";

    public static final void main(String[] args) {
        String manifestFile = allTests;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-timeout")) {
                timeout = Integer.parseInt(args[++i]);
            } else if (arg.equals("-manifest")) {
                if (!(manifestFile = args[++i]).startsWith("http://")) {
                    manifestFile = "http://www.w3.org/2002/03owlt/" + manifestFile;
                }
            } else if (arg.equals("-cache")) {
                USE_CACHE = true;
                if (!(base = args[++i]).startsWith("file://")) {
                    base = new File(base).toURI().toString();
                }
            } else if (arg.equals("-debug")) {
                ABox.DEBUG = true;
                OWLParser.DEBUG = true;
                OWLReasoner.DEBUG = true;
            } else if (arg.equals("-n")) {
                try {
                    MAX_TEST_COUNT = Integer.parseInt(args[++i]);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            } else if (arg.startsWith("-stats")) {
                String stats;
                if ((stats = args[++i].toLowerCase()).equals("no")) {
                    SHOW_STATS = 0;
                } else if (stats.equals("short")) {
                    SHOW_STATS = 1;
                } else if (stats.equals("long")) {
                    SHOW_STATS = 2;
                } else if (stats.equals("all")) {
                    SHOW_STATS = 3;
                }
            }
            ++i;
        }
        System.out.println("Reading manifest file " + manifestFile);
        System.out.println();
        OWLTest owlTest = new OWLTest();
        long time = System.currentTimeMillis();
        owlTest.doTest(manifestFile);
        time = System.currentTimeMillis() - time;
        System.out.println("Total time: " + time);
    }

    public void doTest(String manifestFile) {
        try {
            Model model = ModelFactory.createDefaultModel();
            Model outputModel = ModelFactory.createDefaultModel();
            Resource system = ResourceFactory.createResource();
            Property label = ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#label");
            Property comment = ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#comment");
            Literal name = outputModel.createLiteral("Pellet");
            Literal description = outputModel.createLiteral("This was generated by the Pellet reasoner which can be found at http://www.mindswap.org/2003/pellet/");
            outputModel.add(ResourceFactory.createStatement((Resource)system, (Property)label, (RDFNode)name));
            outputModel.add(ResourceFactory.createStatement((Resource)system, (Property)comment, (RDFNode)description));
            model.read(manifestFile, "");
            int testCount = 1;
            StmtIterator i = model.listStatements(null, RDF.type, null);
            while (i.hasNext() && testCount <= MAX_TEST_COUNT) {
                Statement stmt = i.nextStatement();
                if (!TYPES.contains(stmt.getObject())) continue;
                Resource testCase = stmt.getSubject();
                Statement levelStmt = testCase.getProperty(TestVocabulary.level);
                Statement statusStmt = testCase.getProperty(TestVocabulary.status);
                Vector<String> levels = new Vector<String>();
                int level = 3;
                StmtIterator si = testCase.listProperties(TestVocabulary.level);
                while (si.hasNext()) {
                    Statement s = si.nextStatement();
                    String levelName = s.getResource().getLocalName();
                    if (level <= LEVELS.indexOf(levelName)) continue;
                    levelStmt = s;
                    levels.add(levelName);
                }
                Resource testType = stmt.getResource();
                Resource testLevel = levelStmt.getResource();
                RDFNode testStatus = statusStmt.getObject();
                if (testStatus.equals(TestVocabulary.Obsoleted) || testStatus.toString().startsWith("OBSOLETE")) continue;
                DatatypeReasoner.supportAll();
                si = testCase.listProperties(TestVocabulary.notSupportedDatatype);
                while (si.hasNext()) {
                    Statement s = si.nextStatement();
                    String dt = s.getResource().getURI();
                    System.err.println("Support for datatype " + dt + " is turned off!");
                    DatatypeReasoner.dontSupport(dt);
                }
                String fileName = testCase.toString();
                System.out.println("Test  : " + testCount++);
                System.out.println("Name  : " + testCase);
                System.out.println("Type  : " + testType.getLocalName());
                System.out.println("Level : " + levels);
                System.out.println("Status: " + testStatus);
                Vector<Object> result = new Vector<Object>();
                result.add(new Integer(testCount - 1));
                result.add(fileName.substring(1 + fileName.substring(1, fileName.lastIndexOf("/") - 1).lastIndexOf("/")));
                result.add(testType.getLocalName());
                result.add(testLevel.getLocalName());
                result.add(testStatus);
                long time = System.currentTimeMillis();
                Pellet.timers.resetTimer("totalTime");
                int testResult = 1;
                if (timeout <= 0) {
                    testResult = this.doTestCase(testCase, testType);
                } else {
                    class TestThread
                    extends Thread {
                        public int testResult;
                        final /* synthetic */ OWLTest this$0;
                        private final /* synthetic */ Resource val$testCase;
                        private final /* synthetic */ Resource val$testType;

                        TestThread(OWLTest oWLTest, Resource resource, Resource resource2) {
                            this.this$0 = oWLTest;
                            this.val$testCase = resource;
                            this.val$testType = resource2;
                            this.testResult = 1;
                        }

                        public void run() {
                            try {
                                this.testResult = this.this$0.doTestCase(this.val$testCase, this.val$testType);
                            }
                            catch (StackOverflowError e) {
                                this.testResult = 1;
                                System.err.println("Fail  : Stack overflow");
                                OWLTest.printStackTrace(e);
                            }
                        }
                    }
                    TestThread test = new TestThread(this, testCase, testType);
                    test.start();
                    test.join(timeout * 1000);
                    if (test.isAlive()) {
                        test.stop();
                        testResult = 1;
                        System.err.println("Fail  : Couldn't find answer after " + timeout + " seconds");
                    } else {
                        testResult = test.testResult;
                    }
                }
                time = System.currentTimeMillis() - time;
                Resource testRun = ResourceFactory.createResource();
                Property type = ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
                Property tcProp = ResourceFactory.createProperty((String)"http://www.w3.org/2002/03owlt/resultsOntology#test");
                Resource runtype = ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#TestRun");
                Property systemProp = ResourceFactory.createProperty((String)"http://www.w3.org/2002/03owlt/resultsOntology#system");
                Resource resultType = null;
                if (testResult == 1) {
                    resultType = time >= (long)(timeout * 1000) ? ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#IncompleteRun") : ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#FailingRun");
                } else if (testResult == 0) {
                    resultType = ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#PassingRun");
                }
                outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)type, (RDFNode)runtype));
                outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)tcProp, (RDFNode)testCase));
                outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)systemProp, (RDFNode)system));
                if (resultType != null) {
                    outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)type, (RDFNode)resultType));
                }
                Property timeProp = ResourceFactory.createProperty((String)"http://owl.mindswap.org/2003/ont/owlweb.rdf#testTime");
                Literal timeLiteral = model.createLiteral("" + time);
                outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)timeProp, (RDFNode)timeLiteral));
                result.add(new Long(time));
                result.add(RESULTS.get(testResult));
                this.results.add(result);
                int i1 = LEVELS.indexOf(testLevel);
                int i2 = STATUS.indexOf(testStatus);
                int i3 = TYPES.indexOf(testType);
                int i4 = testResult;
                int[] nArray = this.stats[i1][i2][i3];
                int n = i4;
                nArray[n] = nArray[n] + 1;
                System.out.println("Time  : " + Pellet.getTimeInfo(true));
                System.out.println("Result: " + RESULTS.get(testResult));
                System.out.println("--------------------------------------------------------------------");
                System.out.println();
            }
            FileOutputStream output = new FileOutputStream("results.rdf");
            outputModel.write((OutputStream)output);
            output.close();
            this.printStatistics();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    void printStatistics() {
        Object[][] data;
        ArrayList<Object[][]> dataArray = new ArrayList<Object[][]>();
        int s = 0;
        while (s < STATUS.size() - 1) {
            data = new Object[LEVELS.size() * (TYPES.size() + 1) + 1][RESULTS.size()];
            int r = 0;
            while (r < 3) {
                int columnTotal = 0;
                int l = 0;
                while (l < LEVELS.size()) {
                    int total = 0;
                    int t = 0;
                    while (t < TYPES.size()) {
                        int count = this.stats[l][s][t][r];
                        data[l * (OWLTest.TYPES.size() + 1) + t + 1][r] = new Integer(count);
                        total += count;
                        ++t;
                    }
                    data[l * (OWLTest.TYPES.size() + 1)][r] = new Integer(total);
                    columnTotal += total;
                    ++l;
                }
                data[OWLTest.LEVELS.size() * (OWLTest.TYPES.size() + 1)][r] = new Integer(columnTotal);
                ++r;
            }
            dataArray.add(data);
            ++s;
        }
        if (SHOW_STATS >= 2) {
            int i = 0;
            while (i < this.results.size()) {
                Vector result = (Vector)this.results.get(i);
                int j = 0;
                while (j < result.size()) {
                    System.out.print(result.get(j) + " ");
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
        if (SHOW_STATS >= 1) {
            s = 0;
            while (s < STATUS.size() - 1) {
                data = (Object[][])dataArray.get(s);
                System.out.println(STATUS.get(s).toString());
                int c = 0;
                while (c < 3) {
                    System.out.print(data[data.length - 1][c] + " ");
                    ++c;
                }
                System.out.println();
                ++s;
            }
        }
        if (SHOW_STATS >= 3) {
            this.showStatistics(dataArray);
        }
    }

    private void showStatistics(ArrayList dataArray) {
        Object[][] types = new String[LEVELS.size() * (TYPES.size() + 1) + 1][1];
        int l = 0;
        while (l < LEVELS.size()) {
            types[l * (OWLTest.TYPES.size() + 1)][0] = ((Resource)LEVELS.get(l)).getLocalName();
            int t = 0;
            while (t < TYPES.size()) {
                types[l * (OWLTest.TYPES.size() + 1) + t + 1][0] = "     " + ((Resource)TYPES.get(t)).getLocalName();
                ++t;
            }
            types[OWLTest.LEVELS.size() * (OWLTest.TYPES.size() + 1)][0] = "TOTAL";
            ++l;
        }
        JFrame info = new JFrame("Result");
        info.getContentPane().setLayout(new BoxLayout(info.getContentPane(), 1));
        Box mainPanel = Box.createHorizontalBox();
        final JTable table = new JTable(types, new String[]{"TYPE"});
        Box p1 = Box.createVerticalBox();
        p1.add(new JLabel(" "));
        p1.add(new JScrollPane(table));
        mainPanel.add(p1);
        final JTable[] tables = new JTable[STATUS.size()];
        int s = 0;
        while (s < STATUS.size() - 1) {
            Box p = Box.createVerticalBox();
            Object[][] data = (Object[][])dataArray.get(s);
            tables[s] = new JTable(data, RESULTS.toArray());
            JLabel label = new JLabel(STATUS.get(s).toString());
            label.setAlignmentX(0.5f);
            p.add(label);
            p.add(new JScrollPane(tables[s]));
            mainPanel.add(p);
            ++s;
        }
        Box optionsPanel = Box.createVerticalBox();
        final JCheckBox details = new JCheckBox("Show Details", true);
        details.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int rowHeight = details.isSelected() ? table.getRowHeight(0) : 1;
                int l = 0;
                while (l < LEVELS.size()) {
                    int t = 0;
                    while (t < TYPES.size()) {
                        table.setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        tables[0].setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        tables[1].setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        tables[2].setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        ++t;
                    }
                    ++l;
                }
            }
        });
        details.doClick();
        optionsPanel.add(details);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("No");
        columnNames.add("Name");
        columnNames.add("Type");
        columnNames.add("Level");
        columnNames.add("Status");
        columnNames.add("Time (ms)");
        columnNames.add("Result");
        JTable resultsTable = new JTable(this.results, columnNames);
        resultsTable.getColumnModel().getColumn(0).setPreferredWidth(15);
        resultsTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        resultsTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        resultsTable.getColumnModel().getColumn(3).setPreferredWidth(30);
        resultsTable.getColumnModel().getColumn(5).setPreferredWidth(30);
        resultsTable.getColumnModel().getColumn(6).setPreferredWidth(30);
        info.getContentPane().add(mainPanel);
        info.getContentPane().add(optionsPanel);
        info.getContentPane().add(new JScrollPane(resultsTable));
        info.setDefaultCloseOperation(3);
        info.setSize(800, 600);
        info.show();
    }

    String getFileName(String fileName) {
        if (USE_CACHE) {
            fileName = String.valueOf(base) + fileName.substring(1 + fileName.substring(1, fileName.lastIndexOf("/") - 1).lastIndexOf("/")) + ".rdf";
        }
        return fileName;
    }

    int doConsistencyTest(Resource testCase, boolean isConsistent) {
        String inputFile = null;
        try {
            String string = inputFile = testCase.hasProperty(TestVocabulary.inputDocument) ? testCase.getProperty(TestVocabulary.inputDocument).getObject().toString() : null;
            if (inputFile != null) {
                inputFile = this.getFileName(inputFile);
                System.out.println("Input : " + inputFile);
            }
            OWLReasoner reasoner = new OWLReasoner();
            reasoner.loadOntology(inputFile);
            reasoner.checkConsistency();
            if (reasoner.isConsistent() != isConsistent) {
                System.err.println("Fail  : Consistency error");
                return 1;
            }
            if (OUTPUT_DL) {
                this.outputDL(inputFile);
            }
        }
        catch (UnsupportedFeatureException e) {
            System.err.println("Skip  : " + e.getMessage());
            return 2;
        }
        catch (TimeoutException e1) {
            System.err.println("Fail  : Timeout - Couldn't find answer after " + timeout + " seconds");
            return 1;
        }
        catch (Exception e) {
            System.err.println("Fail  : " + inputFile);
            OWLTest.printStackTrace(e);
            return 1;
        }
        return 0;
    }

    int doEntailmentTest(Resource testCase, boolean isEntailed) {
        String inputFile = null;
        try {
            inputFile = testCase.hasProperty(TestVocabulary.premiseDocument) ? testCase.getProperty(TestVocabulary.premiseDocument).getObject().toString() : null;
            String conclusionsFile = testCase.getProperty(TestVocabulary.conclusionDocument).getObject().toString();
            if (inputFile != null) {
                inputFile = this.getFileName(inputFile);
                System.out.println("Input : " + inputFile);
            }
            conclusionsFile = this.getFileName(conclusionsFile);
            System.out.println("Conc. : " + conclusionsFile);
            OWLReasoner reasoner = new OWLReasoner();
            reasoner.loadOntology(inputFile);
            reasoner.checkConsistency();
            if (!reasoner.isConsistent()) {
                System.err.println("Fail  : Premises file is not consistent!");
                return 1;
            }
            if (reasoner.isEntailed(conclusionsFile) != isEntailed) {
                System.err.println("Fail  : Entailment error");
                return 1;
            }
            if (OUTPUT_DL) {
                this.outputDL(inputFile);
                this.outputDL(conclusionsFile);
            }
        }
        catch (UnsupportedFeatureException e) {
            System.err.println("Skip  : " + e.getMessage());
            return 2;
        }
        catch (TimeoutException e1) {
            System.err.println("Fail  : Timeout - Couldn't find answer after " + timeout + " seconds");
            return 1;
        }
        catch (Exception e) {
            System.err.println("Fail  : " + inputFile);
            OWLTest.printStackTrace(e);
            return 1;
        }
        return 0;
    }

    int doNotOWLFeatureTest(Resource testCase) {
        String inputFile = null;
        try {
            inputFile = testCase.getProperty(TestVocabulary.inputDocument).getObject().toString();
            inputFile = this.getFileName(inputFile);
            System.out.println("Input : " + inputFile);
            OWLReasoner reasoner = new OWLReasoner();
            reasoner.loadOntology(inputFile);
            reasoner.isConsistent();
        }
        catch (UnsupportedFeatureException e) {
            return 0;
        }
        catch (Exception e) {
            System.err.println("Fail  : " + inputFile);
            OWLTest.printStackTrace(e);
            return 1;
        }
        return 1;
    }

    int doImportLevelTest(Resource testCase) {
        String inputFile = null;
        try {
            inputFile = testCase.getProperty(TestVocabulary.inputDocument).getObject().toString();
            inputFile = this.getFileName(inputFile);
            System.out.println("Input : " + inputFile);
            String testLevel = testCase.getProperty(TestVocabulary.level).getResource().getLocalName();
            OWLParser.readFile(inputFile);
            if (testLevel.equals(OWLParser.level)) {
                return 0;
            }
        }
        catch (UnsupportedFeatureException e) {
            return 0;
        }
        catch (Exception e) {
            System.err.println("Fail  : " + inputFile);
            OWLTest.printStackTrace(e);
            return 1;
        }
        return 1;
    }

    int doTestCase(Resource testCase, Resource testType) {
        if (testType.equals((Object)TestVocabulary.PositiveEntailmentTest)) {
            return this.doEntailmentTest(testCase, true);
        }
        if (testType.equals((Object)TestVocabulary.NegativeEntailmentTest)) {
            return this.doEntailmentTest(testCase, false);
        }
        if (testType.equals((Object)TestVocabulary.ConsistencyTest)) {
            return this.doConsistencyTest(testCase, true);
        }
        if (testType.equals((Object)TestVocabulary.InconsistencyTest)) {
            return this.doConsistencyTest(testCase, false);
        }
        if (testType.equals((Object)TestVocabulary.ImportEntailmentTest)) {
            return this.doEntailmentTest(testCase, true);
        }
        if (testType.equals((Object)TestVocabulary.NotOwlFeatureTest)) {
            return this.doNotOWLFeatureTest(testCase);
        }
        if (testType.equals((Object)TestVocabulary.ImportLevelTest)) {
            return this.doImportLevelTest(testCase);
        }
        return 2;
    }

    private void outputDL(String inputFile) throws Exception {
        String outputFile = "DLized\\" + inputFile.substring(1 + inputFile.substring(1, inputFile.lastIndexOf("/") - 1).lastIndexOf("/")) + ".rdf";
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.loadOntology(inputFile);
        if (OWLParser.nonDL.size() == 0) {
            System.out.println("Output: None. The file level is already " + OWLParser.level + "! No output file is created!");
        } else if (OWLParser.unsupportedFeatures.size() > 0) {
            System.out.println("Output: None. There are unsupported feature in the input document, cannot generate DL version!");
        } else if (!OWLParser.canOutputDL) {
            System.out.println("Output: None. This ontology cannot be converted to OWL DL!");
        } else {
            File f = new File(outputFile);
            f.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(f);
            OWLParser.model.union(OWLParser.missingTriples).write((OutputStream)out);
            System.out.println("Output: " + outputFile);
        }
    }

    public static void printStackTrace(Throwable e) {
        StackTraceElement[] ste = e.getStackTrace();
        System.err.println(e);
        if (ste.length > 25) {
            int i = 0;
            while (i < 15 && i < ste.length) {
                System.err.println("   " + ste[i]);
                ++i;
            }
            System.err.println("   ...");
            i = ste.length - 10;
            while (i < ste.length) {
                System.err.println("   " + ste[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < ste.length) {
                System.err.println("   " + ste[i]);
                ++i;
            }
        }
    }
}

