/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.ATermPlaceholder;
import aterm.pure.PureFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ATermUtils {
    public static String NOT = "not";
    public static String AND = "and";
    public static String OR = "or";
    public static String SOME = "some";
    public static String ALL = "all";
    public static String MIN = "min";
    public static String MAX = "max";
    public static String VALUE = "value";
    public static String INV = "inv";
    public static String SUB = "sub";
    public static String SAME = "same";
    public static String DT = "datatype";
    private static ATermFactory factory = new PureFactory();
    public static AFun LITFUN = factory.makeAFun("literal", 3, false);
    public static AFun DTFUN = factory.makeAFun("datatype", 1, false);
    public static AFun ANDFUN = factory.makeAFun(AND, 1, false);
    public static AFun ORFUN = factory.makeAFun(OR, 1, false);
    public static AFun SOMEFUN = factory.makeAFun(SOME, 2, false);
    public static AFun ALLFUN = factory.makeAFun(ALL, 2, false);
    public static AFun NOTFUN = factory.makeAFun(NOT, 1, false);
    public static AFun MAXFUN = factory.makeAFun(MAX, 2, false);
    public static AFun MINFUN = factory.makeAFun(MIN, 2, false);
    public static AFun VALUEFUN = factory.makeAFun(VALUE, 1, false);
    public static AFun INVFUN = factory.makeAFun(INV, 1, false);
    public static AFun SUBFUN = factory.makeAFun(SUB, 2, false);
    public static AFun SAMEFUN = factory.makeAFun(SAME, 2, false);
    public static AFun TYPEFUN = factory.makeAFun("type", 2, false);
    public static AFun IPFUN = factory.makeAFun("iptriple", 3, false);
    public static AFun DPFUN = factory.makeAFun("dptriple", 3, false);
    public static ATermPlaceholder VAR = (ATermPlaceholder)factory.parse("<term>");
    public static ATerm QUERYVAR = ATermUtils.makeTermAppl("http://www.mindswap.org/2003/pellet/ont#BoundVariable");
    static ATerm TOP = ATermUtils.makeTermAppl("_TOP_");
    static ATerm BOTTOM = ATermUtils.makeNot(TOP);
    public static StringComparator stringComparator = new StringComparator();
    public static ATermComparator comparator = new ATermComparator();

    public static ATermFactory getFactory() {
        return factory;
    }

    public static ATermAppl makeLiteral(String value, String lang, String dt) {
        return factory.makeAppl(LITFUN, (ATerm)ATermUtils.makeTermAppl(value), (ATerm)ATermUtils.makeTermAppl(lang), (ATerm)ATermUtils.makeTermAppl(dt));
    }

    public static ATermAppl makeDatatype(String dt) {
        return factory.makeAppl(DTFUN, (ATerm)factory.makeAppl(factory.makeAFun(dt, 0, false)));
    }

    public static ATermAppl makeTermAppl(String name) {
        return factory.makeAppl(factory.makeAFun(name, 0, false));
    }

    public static ATermAppl makeTermAppl(AFun fun, ATerm[] args) {
        return factory.makeAppl(fun, args);
    }

    public static ATermAppl makeNot(ATerm c) {
        return factory.makeAppl(NOTFUN, c);
    }

    public static ATermList negate(ATermList list) {
        if (list.isEmpty()) {
            return list;
        }
        ATerm a = list.getFirst();
        a = ATermUtils.isNot(a) ? ATermUtils.getNegated(a) : ATermUtils.makeNot(a);
        return ATermUtils.makeList(a, ATermUtils.negate(list.getNext()));
    }

    public static ATerm negate(ATerm a) {
        return ATermUtils.isNot(a) ? ATermUtils.getNegated(a) : ATermUtils.makeNot(a);
    }

    public static ATermAppl makeValue(ATerm c) {
        return factory.makeAppl(VALUEFUN, c);
    }

    public static ATermAppl makeInv(ATerm r) {
        ATermUtils.assertTrue(r instanceof ATermAppl);
        return factory.makeAppl(INVFUN, r);
    }

    public static ATermAppl makeSub(ATerm a, ATerm b) {
        return factory.makeAppl(SUBFUN, a, b);
    }

    public static ATermAppl makeSame(ATerm a, ATerm b) {
        return factory.makeAppl(SAMEFUN, a, b);
    }

    public static ATerm makeAnd(ATerm c1, ATerm c2) {
        return ATermUtils.makeAnd(ATermUtils.makeList(c2).insert(c1));
    }

    public static ATerm makeAnd(ATermList list) {
        if (list == null || list.isEmpty()) {
            return BOTTOM;
        }
        if (list.getNext().isEmpty()) {
            return list.getFirst();
        }
        return factory.makeAppl(ANDFUN, (ATerm)list);
    }

    public static ATerm makeOr(ATerm c1, ATerm c2) {
        return ATermUtils.makeOr(ATermUtils.makeList(c2).insert(c1));
    }

    public static ATerm makeOr(ATermList list) {
        if (list == null || list.isEmpty()) {
            return BOTTOM;
        }
        if (list.getNext().isEmpty()) {
            return list.getFirst();
        }
        return factory.makeAppl(ORFUN, (ATerm)list);
    }

    public static ATermAppl makeAllValues(ATerm r, ATerm c) {
        return factory.makeAppl(ALLFUN, r, c);
    }

    public static ATermAppl makeSomeValues(ATerm r, ATerm c) {
        return factory.makeAppl(SOMEFUN, r, c);
    }

    public static ATermAppl makeMax(ATerm r, int n) {
        ATermUtils.assertTrue(n >= 0);
        return ATermUtils.makeNot((ATerm)ATermUtils.makeMin(r, n + 1));
    }

    public static ATermAppl makeMin(ATerm r, int n) {
        ATermUtils.assertTrue(n > 0);
        return factory.makeAppl(MINFUN, r, (ATerm)factory.makeInt(n));
    }

    public static ATermAppl makeMax1(ATerm r) {
        return ATermUtils.makeMax(r, 1);
    }

    public static ATermAppl makeMin2(ATerm r) {
        return ATermUtils.makeMin(r, 2);
    }

    public static ATermList makeList() {
        return factory.makeList();
    }

    public static ATermList makeList(ATerm singleton) {
        return factory.makeList(singleton, ATermUtils.makeList());
    }

    public static ATermList makeList(ATerm first, ATermList rest) {
        return factory.makeList(first, rest);
    }

    public static ATermList makeList(ATerm[] aTerms) {
        return ATermUtils.makeList(aTerms, 0);
    }

    private static ATermList makeList(ATerm[] aTerms, int index) {
        if (index >= aTerms.length) {
            return ATermUtils.makeList();
        }
        if (index == aTerms.length - 1) {
            return ATermUtils.makeList(aTerms[index]);
        }
        return ATermUtils.makeList(aTerms[index], ATermUtils.makeList(aTerms, index + 1));
    }

    public static List memberMatch(ATerm pattern, ATermList list) {
        ArrayList<List> matches = new ArrayList<List>();
        while (!list.isEmpty()) {
            List match = list.getFirst().match(pattern);
            if (match != null) {
                matches.add(match);
            }
            list = list.getNext();
        }
        if (matches.size() == 0) {
            return null;
        }
        return matches;
    }

    public static boolean member(ATerm a, ATermList list) {
        return list.indexOf(a, 0) != -1;
    }

    public static boolean isSet(ATermList list) {
        if (list.isEmpty()) {
            return true;
        }
        ATerm curr = list.getFirst();
        list = list.getNext();
        while (!list.isEmpty()) {
            ATerm next = list.getFirst();
            if (comparator.compare(curr, next) >= 0) {
                return false;
            }
            curr = next;
            list = list.getNext();
        }
        return true;
    }

    private static void printList(String name, ATermList list) {
        ATermList l = list;
        System.out.print("\n" + name + " = [");
        while (!l.isEmpty()) {
            ATerm first = l.getFirst();
            System.out.print(String.valueOf(first.hashCode()) + ", ");
            l = l.getNext();
        }
        System.out.println("]");
    }

    public static ATermList toSet(ATermList list) {
        if (ATermUtils.isSet(list)) {
            return list;
        }
        int size = list.getLength();
        ATerm[] a = ATermUtils.toArray(list);
        if (a == null || a.length < size) {
            a = new ATerm[Math.max(100, size)];
        }
        Arrays.sort(a, 0, size, comparator);
        ATermList set = ATermUtils.makeList(a[size - 1]);
        int i = size - 2;
        while (i >= 0) {
            ATerm s = set.getFirst();
            ATerm b = a[i];
            if (!s.equals((Object)a[i])) {
                set = set.insert(a[i]);
            }
            --i;
        }
        return set;
    }

    public static ATermList setAdd(ATerm a, ATermList list) {
        int index = 0;
        ATermList l = list;
        while (!l.isEmpty()) {
            ATerm el = l.getFirst();
            int cmp = comparator.compare(a, el);
            if (cmp == 0) {
                return list;
            }
            if (cmp < 0) break;
            l = l.getNext();
            ++index;
        }
        return list.insertAt(a, index);
    }

    public static ATermList insert(ATerm a, ATermList list) {
        if (!ATermUtils.member(a, list)) {
            return list.insert(a);
        }
        return list;
    }

    public static ATermList append(ATerm a, ATermList list) {
        if (!ATermUtils.member(a, list)) {
            return list.append(a);
        }
        return list;
    }

    public static ATermList union(ATermList list1, ATermList list2) {
        ATermList list3 = list2;
        while (!list1.isEmpty()) {
            list3 = ATermUtils.insert(list1.getFirst(), list3);
            list1 = list1.getNext();
        }
        return list3;
    }

    public static ATermList intersection(ATermList list1, ATermList list2) {
        ATermList list3 = ATermUtils.makeList();
        while (!list1.isEmpty()) {
            if (ATermUtils.member(list1.getFirst(), list2)) {
                list3 = list3.insert(list1.getFirst());
            }
            list1 = list1.getNext();
        }
        return list3;
    }

    public static boolean subset(ATermList list1, ATermList list2) {
        return list1 == list2 || list1.getLength() == 0 || ATermUtils.member(list1.getFirst(), list2) && ATermUtils.subset(list1.getNext(), list2);
    }

    public static boolean setEquals(ATermList list1, ATermList list2) {
        return list1.getLength() == list2.getLength() && ATermUtils.subset(list1, list2) && ATermUtils.subset(list2, list1);
    }

    public static ATerm[] toArray(ATermList list) {
        ATerm[] a = new ATerm[list.getLength()];
        int i = 0;
        while (!list.isEmpty()) {
            a[i++] = list.getFirst();
            list = list.getNext();
        }
        return a;
    }

    public static void assertTrue(boolean condition) {
        if (!condition) {
            throw new RuntimeException("assertion failed.");
        }
    }

    public static boolean isDatatype(ATerm c) {
        return c instanceof ATermAppl && ((ATermAppl)c).getAFun().equals((Object)DTFUN);
    }

    public static boolean isPrimitive(ATerm c) {
        return c instanceof ATermAppl && ((ATermAppl)c).getArity() == 0;
    }

    public static ATerm getNegatedPrimitive(ATerm c) {
        ATermAppl a;
        if (c instanceof ATermAppl && (a = (ATermAppl)c).getAFun().equals((Object)NOTFUN) && ATermUtils.isPrimitive(a.getArgument(0))) {
            return a.getArgument(0);
        }
        return null;
    }

    public static ATerm getNegated(ATerm c) {
        ATermAppl a;
        if (c instanceof ATermAppl && (a = (ATermAppl)c).getAFun().equals((Object)NOTFUN)) {
            return a.getArgument(0);
        }
        return null;
    }

    public static ATermList setToList(HashSet set) {
        ATermList list = ATermUtils.makeList();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            list = list.insert((ATerm)iter.next());
        }
        return list;
    }

    public static ATermList andToList(ATermAppl term) {
        if (term.getName().equals(AND)) {
            return (ATermList)term.getArgument(0);
        }
        return ATermUtils.makeList().insert((ATerm)term);
    }

    public static ATermList orToList(ATermAppl term) {
        if (term.getName().equals(OR)) {
            return (ATermList)term.getArgument(0);
        }
        return ATermUtils.makeList().insert((ATerm)term);
    }

    public static boolean isAnd(ATerm a) {
        return ATermUtils.isFun(a, AND);
    }

    public static boolean isAllValues(ATerm a) {
        return ATermUtils.isFun(a, ALL);
    }

    public static boolean isNominal(ATerm a) {
        return ATermUtils.isFun(a, VALUE);
    }

    public static boolean isNot(ATerm a) {
        return ATermUtils.isFun(a, NOT);
    }

    public static boolean isMax(ATerm a) {
        return ATermUtils.isFun(a, MAX);
    }

    public static boolean isMin(ATerm a) {
        return ATermUtils.isFun(a, MIN);
    }

    private static boolean isFun(ATerm a, String fun) {
        return a instanceof ATermAppl && ((ATermAppl)a).getAFun().getName().equals(fun);
    }

    public static ATerm nnf(ATerm term) {
        Object newterm = null;
        if (term instanceof ATermList) {
            ATermList newList = factory.makeList();
            ATermList list = (ATermList)term;
            while (!list.isEmpty()) {
                newList = newList.append(ATermUtils.nnf(list.getFirst()));
                list = list.getNext();
            }
            return newList;
        }
        ATermAppl ta = (ATermAppl)term;
        AFun af = ta.getAFun();
        String name = af.getName();
        if (name.equals(NOT)) {
            ATermUtils.assertTrue(af.getArity() == 1);
            ATermAppl arg = (ATermAppl)ta.getArgument(0);
            String argname = arg.getAFun().getName();
            if (arg.getArity() == 0) {
                newterm = term;
            } else if (argname.equals(NOT)) {
                ATermUtils.assertTrue(arg.getArity() == 1);
                newterm = ATermUtils.nnf(arg.getArgument(0));
            } else if (argname.equals(VALUE) || argname.equals(DT)) {
                newterm = term;
            } else if (argname.equals(MAX)) {
                ATermUtils.assertTrue(arg.getArity() == 2);
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = ATermUtils.makeMin(arg.getArgument(0), n.getInt() + 1);
            } else if (argname.equals(MIN)) {
                ATermUtils.assertTrue(arg.getArity() == 2);
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = n.getInt() == 0 ? BOTTOM : ATermUtils.makeMax(arg.getArgument(0), n.getInt() - 1);
            } else {
                if (argname.equals(AND)) {
                    return ATermUtils.makeOr((ATermList)ATermUtils.nnf((ATerm)ATermUtils.negate((ATermList)arg.getArgument(0))));
                }
                if (argname.equals(OR)) {
                    return ATermUtils.makeAnd((ATermList)ATermUtils.nnf((ATerm)ATermUtils.negate((ATermList)arg.getArgument(0))));
                }
                if (argname.equals(SOME)) {
                    newterm = ATermUtils.makeAllValues(arg.getArgument(0), ATermUtils.nnf((ATerm)ATermUtils.makeNot(arg.getArgument(1))));
                } else if (argname.equals(ALL)) {
                    newterm = ATermUtils.makeSomeValues(arg.getArgument(0), ATermUtils.nnf((ATerm)ATermUtils.makeNot(arg.getArgument(1))));
                } else {
                    ATermUtils.assertTrue(false);
                }
            }
        } else {
            if (ta.getAFun().equals((Object)MINFUN) || ta.getAFun().equals((Object)MAXFUN)) {
                return ta;
            }
            ATerm[] args = new ATerm[ta.getArity()];
            int i = 0;
            while (i < ta.getArity()) {
                args[i] = ATermUtils.nnf(ta.getArgument(i));
                ++i;
            }
            newterm = factory.makeAppl(af, args);
        }
        ATermUtils.assertTrue(newterm != null);
        return newterm;
    }

    public static ATerm normalize(ATerm t) {
        ATerm arg2;
        if (t instanceof ATermList) {
            ATermList newList = factory.makeList();
            ATermList list = (ATermList)t;
            while (!list.isEmpty()) {
                newList = newList.insert(ATermUtils.normalize(list.getFirst()));
                list = list.getNext();
            }
            return ATermUtils.toSet(newList);
        }
        ATerm norm = t;
        ATermAppl term = (ATermAppl)t;
        String fun = term.getAFun().getName();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm aTerm = arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        if (fun.equals(NOT)) {
            norm = ATermUtils.simplify((ATerm)ATermUtils.makeNot(ATermUtils.normalize(arg1)));
        } else if (fun.equals(AND)) {
            norm = ATermUtils.simplify(ATermUtils.makeAnd((ATermList)ATermUtils.normalize(arg1)));
        } else if (fun.equals(OR)) {
            ATermList neg = ATermUtils.negate((ATermList)arg1);
            ATerm and = ATermUtils.makeAnd(neg);
            ATermAppl notAnd = ATermUtils.makeNot(and);
            norm = ATermUtils.normalize((ATerm)notAnd);
        } else if (fun.equals(ALL)) {
            norm = ATermUtils.simplify((ATerm)ATermUtils.makeAllValues(arg1, ATermUtils.normalize(arg2)));
        } else if (fun.equals(SOME)) {
            norm = ATermUtils.normalize((ATerm)ATermUtils.makeNot((ATerm)ATermUtils.makeAllValues(arg1, (ATerm)ATermUtils.makeNot(arg2))));
        } else if (fun.equals(MAX)) {
            norm = ATermUtils.makeNot((ATerm)ATermUtils.makeMin(arg1, ((ATermInt)arg2).getInt() + 1));
        } else if (fun.equals(MIN)) {
            norm = ATermUtils.simplify(norm);
        }
        return norm;
    }

    public static ATerm simplify(ATerm t) {
        ATermInt n;
        ATerm arg2;
        ATerm simp = t;
        ATermAppl term = (ATermAppl)t;
        String fun = term.getAFun().getName();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm aTerm = arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        if (fun.equals(NOT)) {
            ATermAppl arg;
            ATermInt n2;
            if (ATermUtils.isNot(arg1)) {
                simp = ATermUtils.simplify(ATermUtils.getNegated(arg1));
            } else if (ATermUtils.isMin(arg1) && (n2 = (ATermInt)(arg = (ATermAppl)arg1).getArgument(1)).getInt() == 0) {
                simp = BOTTOM;
            }
        } else if (fun.equals(AND)) {
            ATermList conjuncts = (ATermList)arg1;
            if (conjuncts.isEmpty()) {
                simp = TOP;
            } else {
                ATermList newConjuncts = ATermUtils.makeList();
                while (!conjuncts.isEmpty()) {
                    ATerm conj = conjuncts.getFirst();
                    if (!conj.equals((Object)TOP)) {
                        if (ATermUtils.isAnd(conj)) {
                            ATermAppl c = (ATermAppl)conj;
                            conjuncts = conjuncts.concat((ATermList)c.getArgument(0));
                        } else {
                            newConjuncts = newConjuncts.append(conj);
                        }
                    }
                    conjuncts = conjuncts.getNext();
                }
                ATermList c = newConjuncts;
                while (!c.isEmpty()) {
                    ATerm neg;
                    ATerm conj = c.getFirst();
                    if (conj.equals((Object)BOTTOM)) {
                        return BOTTOM;
                    }
                    if (ATermUtils.isNot(conj) && ATermUtils.member(neg = ATermUtils.getNegated(conj), newConjuncts)) {
                        return BOTTOM;
                    }
                    c = c.getNext();
                }
                simp = newConjuncts.isEmpty() ? TOP : (newConjuncts.getLength() == 1 ? newConjuncts.getFirst() : ATermUtils.makeAnd(ATermUtils.toSet(newConjuncts)));
            }
        } else if (fun.equals(ALL)) {
            if (arg2.equals((Object)TOP)) {
                simp = TOP;
            }
        } else if (fun.equals(MIN) && (n = (ATermInt)arg2).getInt() == 0) {
            simp = TOP;
        }
        return simp;
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    static class ATermComparator
    implements Comparator {
        ATermComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.hashCode() > o2.hashCode()) {
                return 1;
            }
            if (o1.hashCode() == o2.hashCode()) {
                return 0;
            }
            return -1;
        }
    }
}

