/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.rmi.server.UID;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.mindswap.pellet.ABoxQuery;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.DatatypeReasoner;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.DifferentFrom;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.OWLParser;
import org.mindswap.pellet.OWLRule;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.SameAs;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.TermDefinition;

public class ABox {
    public static boolean DEBUG = false;
    public static boolean USE_BACKJUMPING = true;
    public static boolean USE_SEMANTIC_BRANCHING = true;
    public static boolean USE_CACHING = true;
    public static boolean USE_ABSORPTION = true;
    public static boolean USE_CLONING = false;
    public static boolean CHECK_DATATYPE_COUNT = true;
    public String level = null;
    protected static final String anonPrefix = "anon";
    protected int anonCount = 0;
    public HashSet nominals = new HashSet();
    public static long satisfiabilityCount = 0L;
    DatatypeReasoner dtReasoner = new DatatypeReasoner();
    Hashtable ontologies = new Hashtable();
    protected Hashtable nodes;
    protected Vector nodeList = null;
    private int nodeCount = 0;
    protected Hashtable literals;
    private Vector literalList = null;
    private int literalCount = 0;
    protected ATermList UC = null;
    public boolean changed = false;
    HashMap cache = new HashMap();
    Node topNode = new Node(ATermUtils.TOP, -1, -1);
    Node bottomNode = new Node(ATermUtils.BOTTOM, -1, -1);
    protected Vector rules = new Vector();
    public SameAs sames = new SameAs(0);
    public DifferentFrom differents = new DifferentFrom(0);
    public SameAs dtSames = new SameAs(0);
    public DifferentFrom dtDifferents = new DifferentFrom(0);
    ATermList globalRestrictions = ATermUtils.makeList();
    Hashtable domainRestrictions = new Hashtable();
    private Hashtable merged = new Hashtable();
    private ABox completeABox = null;
    private boolean isComplete = false;
    public ATermList tboxAxioms = ATermUtils.makeList();
    public RBox rbox = null;
    public TBox tbox = null;
    private DependencySet dependencySet = null;
    private int branch = 0;

    public ABox() {
        this.nodes = new Hashtable();
        this.literals = new Hashtable();
        this.rbox = new RBox();
        this.tbox = new TBox();
        this.sames = new SameAs(0);
        this.differents = new DifferentFrom(0);
        this.nodeList = new Vector();
        this.literalList = new Vector();
        this.merged = new Hashtable();
        this.dependencySet = DependencySet.empty;
        this.topNode.addType(ATermUtils.TOP, DependencySet.initial);
        this.bottomNode.addType(ATermUtils.BOTTOM, DependencySet.initial);
        this.cache.put(ATermUtils.TOP, this.topNode);
        this.cache.put(ATermUtils.BOTTOM, this.bottomNode);
        this.branch = -1;
    }

    public Object clone() {
        Pellet.timers.startTimer("cloneABox");
        ABox abox = new ABox();
        abox.anonCount = this.anonCount;
        abox.nodes = this.cloneTable(this.nodes);
        abox.nodeList = (Vector)this.nodeList.clone();
        abox.nodeCount = this.nodeCount;
        abox.literals = this.cloneTable(this.literals);
        abox.literalList = (Vector)this.literalList.clone();
        abox.literalCount = this.literalCount;
        abox.rbox = this.rbox;
        abox.tbox = this.tbox;
        abox.merged = (Hashtable)this.merged.clone();
        abox.sames = (SameAs)this.sames.clone();
        abox.dtSames = (SameAs)this.dtSames.clone();
        abox.differents = (DifferentFrom)this.differents.clone();
        abox.dtDifferents = (DifferentFrom)this.dtDifferents.clone();
        abox.dtReasoner = this.dtReasoner;
        abox.rules = this.rules;
        abox.branch = this.branch;
        abox.UC = this.UC;
        abox.topNode = this.topNode;
        abox.bottomNode = this.bottomNode;
        abox.cache = this.cache;
        abox.nominals = this.nominals;
        abox.globalRestrictions = this.globalRestrictions;
        abox.domainRestrictions = this.domainRestrictions;
        Pellet.timers.stopTimer("cloneABox");
        return abox;
    }

    public ABox copy() {
        Pellet.timers.startTimer("copy");
        ABox abox = new ABox();
        abox.anonCount = this.anonCount;
        abox.nodes = this.nodes;
        abox.nodeList = this.nodeList;
        abox.nodeCount = this.nodeCount;
        abox.literals = this.literals;
        abox.literalList = this.literalList;
        abox.literalCount = this.literalCount;
        abox.merged = (Hashtable)this.merged.clone();
        abox.rbox = this.rbox;
        abox.tbox = this.tbox;
        abox.sames = (SameAs)this.sames.clone();
        abox.differents = (DifferentFrom)this.differents.clone();
        abox.dtSames = (SameAs)this.dtSames.clone();
        abox.dtDifferents = (DifferentFrom)this.dtDifferents.clone();
        abox.dtReasoner = this.dtReasoner;
        abox.rules = this.rules;
        abox.branch = this.branch;
        abox.UC = this.UC;
        abox.topNode = this.topNode;
        abox.bottomNode = this.bottomNode;
        abox.cache = this.cache;
        abox.nominals = this.nominals;
        abox.globalRestrictions = this.globalRestrictions;
        abox.domainRestrictions = this.domainRestrictions;
        Pellet.timers.stopTimer("copy");
        return abox;
    }

    private void restore() {
        ATerm x;
        Pellet.timers.startTimer("restore");
        if (DEBUG) {
            System.out.println("Restoring at " + this.branch + "...");
        }
        int i = 0;
        while (i < this.nodeList.size()) {
            x = (ATerm)this.nodeList.get(i);
            if (i >= this.nodeCount) {
                this.nodes.remove(x);
            } else {
                Node node = this.getNode(x);
                node.restore(this.branch);
            }
            ++i;
        }
        this.nodeList.setSize(this.nodeCount);
        ATermUtils.assertTrue(this.nodeCount == this.nodes.size());
        ATermUtils.assertTrue(this.nodeCount == this.nodeList.size());
        i = 0;
        while (i < this.literalList.size()) {
            x = (ATerm)this.literalList.get(i);
            if (i >= this.literalCount) {
                this.literals.remove(x);
            } else {
                Literal lit = this.getLiteral(x);
                Iterator j = lit.getTypes().iterator();
                while (j.hasNext()) {
                    ATerm c = (ATerm)j.next();
                    DependencySet d = lit.getDepends(c);
                    if (d.branch <= this.branch) continue;
                    lit.removeType(c);
                }
            }
            ++i;
        }
        this.literalList.setSize(this.literalCount);
        Pellet.timers.stopTimer("restore");
    }

    public ABox cloneABox() {
        return (ABox)this.clone();
    }

    private Hashtable cloneTable(Hashtable t) {
        Hashtable result = new Hashtable();
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object value = entry.getValue();
            if (value instanceof Node) {
                value = ((Node)value).clone();
            } else if (value instanceof Literal) {
                value = ((Literal)value).clone();
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public Vector retrieve(ATerm c) {
        Vector<ATerm> result = new Vector<ATerm>();
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            ATerm nodeName = node.getName();
            if (!node.hasType(c)) continue;
            result.add(nodeName);
        }
        return result;
    }

    private boolean isCached(ATerm c) {
        return this.cache.containsKey(c);
    }

    public boolean isSubclassOf(ATerm c1, ATerm c2) {
        ATerm notC2 = ATermUtils.negate(c2);
        if (USE_CACHING && this.isCached(c1) && this.isCached(notC2)) {
            Node[] roots;
            long time = System.currentTimeMillis();
            if (DEBUG) {
                System.out.print("Cached subsumption for " + OWLParser.getLocalName(c1.toString()) + " and " + OWLParser.getLocalName(c2.toString()));
            }
            if ((roots = new Node[]{(Node)this.cache.get(c1), (Node)this.cache.get(notC2)})[0] == this.bottomNode || roots[1] == this.bottomNode) {
                if (DEBUG) {
                    System.out.println("(1) true " + (System.currentTimeMillis() - time));
                }
                return true;
            }
            if (roots[0] == this.topNode && roots[1] != this.bottomNode) {
                if (DEBUG) {
                    System.out.println("(2) false " + (System.currentTimeMillis() - time));
                }
                return false;
            }
            if (roots[1] == this.topNode && roots[0] != this.bottomNode) {
                if (DEBUG) {
                    System.out.println("(3) false " + (System.currentTimeMillis() - time));
                }
                return false;
            }
            boolean hasClash = false;
            int root = 0;
            while (root < 2) {
                ATerm r;
                int otherRoot = 1 - root;
                Iterator i = roots[root].getAtomic().iterator();
                while (i.hasNext()) {
                    ATermAppl a = (ATermAppl)i.next();
                    ATermAppl notA = ATermUtils.makeNot((ATerm)a);
                    if (!roots[otherRoot].hasType((ATerm)notA)) continue;
                    hasClash = true;
                    break;
                }
                if (hasClash) break;
                i = roots[root].getAllValues().iterator();
                while (i.hasNext()) {
                    ATermAppl av = (ATermAppl)i.next();
                    r = av.getArgument(0);
                    if (!roots[otherRoot].hasEdgeR(r)) continue;
                    hasClash = true;
                    break;
                }
                if (hasClash) break;
                i = roots[root].getMaxCardinality().iterator();
                while (i.hasNext()) {
                    int n2;
                    ATermAppl mc = (ATermAppl)i.next();
                    mc = (ATermAppl)mc.getArgument(0);
                    r = mc.getArgument(0);
                    int n = ((ATermInt)mc.getArgument(1)).getInt() - 1;
                    int n1 = roots[root].getEdges().getEdgesNamed(r).size();
                    if (n1 + (n2 = roots[otherRoot].getEdges().getEdgesNamed(r).size()) < n) continue;
                    hasClash = true;
                    break;
                }
                if (hasClash) break;
                ++root;
            }
            if (DEBUG) {
                System.out.println(" " + hasClash + " " + (System.currentTimeMillis() - time));
            }
            if (!hasClash) {
                return false;
            }
        }
        return !this.isSatisfiable(ATermUtils.makeAnd(c1, (ATerm)ATermUtils.makeNot(c2)));
    }

    public boolean isSatisfiable(ATerm c) {
        if (USE_CACHING && this.isCached(c)) {
            boolean isSat;
            boolean bl = isSat = this.cache.get(c) != this.bottomNode;
            if (DEBUG) {
                System.out.println("Cached sat for " + c + " is " + isSat);
            }
            return isSat;
        }
        ++satisfiabilityCount;
        ABox abox = this.cloneABox();
        ATermAppl x = ATermUtils.makeTermAppl("x" + new UID());
        abox.addNode((ATerm)x);
        abox.addType((ATerm)x, c);
        boolean isConsistent = abox.isConsistent();
        if (USE_CACHING) {
            boolean isPrimitive = ATermUtils.isPrimitive(c);
            ATerm negation = ATermUtils.getNegatedPrimitive(c);
            if (isPrimitive || negation != null) {
                if (isConsistent) {
                    if (abox.completeABox.merged.containsKey(x)) {
                        x = (ATerm)abox.completeABox.merged.get(x);
                    }
                    Node rootNode = abox.completeABox.getNode((ATerm)x);
                    this.cache.put(c, rootNode);
                } else {
                    if (negation == null) {
                        negation = ATermUtils.makeNot(c);
                    }
                    if (DEBUG) {
                        System.out.println(c + " is not satisfiable");
                        System.out.println(negation + " is TOP");
                    }
                    this.cache.put(c, this.bottomNode);
                    this.cache.put(negation, this.topNode);
                }
            }
        }
        return isConsistent;
    }

    public boolean isConsistent() {
        if (this.completeABox == null) {
            this.completeABox = this.completeABox();
        }
        return this.completeABox.dependencySet.isEmpty();
    }

    public boolean clashFree() {
        return this.dependencySet.isEmpty();
    }

    public void init() {
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            this.applyGlobalRestrictions(n);
            int index = n.getIndex();
            ATermList sames = this.getSames(n.getName());
            while (!sames.isEmpty()) {
                ATerm same = sames.getFirst();
                if (this.getIndex(same) > index) {
                    this.mergeRootNodes(same, n.getName(), DependencySet.initial);
                }
                sames = sames.getNext();
            }
        }
    }

    public ABox completeABox() {
        if (DEBUG) {
            System.out.println("Tu (" + this.tbox.Tu.size() + ")");
            System.out.println("Tg (" + this.tbox.Tg.size() + ")");
        }
        if (DEBUG) {
            System.out.println("\ninitial\n" + this);
        }
        this.branch = 1;
        ABox abox = this.cloneABox();
        if (abox.nodeCount == 0) {
            abox.addNode(abox.createUniqueName());
        }
        abox.init();
        abox = abox.complete();
        if (DEBUG) {
            System.out.println("\nisComplete " + abox.dependencySet.isEmpty());
        }
        return abox;
    }

    private void simplifyUC() {
        ATermAppl a;
        ATermList conjuncts = ATermUtils.makeList();
        ATermList termlist = this.tbox.Tg.toList();
        while (!termlist.isEmpty()) {
            ATermAppl def = (ATermAppl)termlist.getFirst();
            Object newdef = null;
            if (def.getName().equals(ATermUtils.SAME)) {
                throw new RuntimeException("Tg still has same in");
            }
            if (def.getName().equals(ATermUtils.SUB)) {
                a = (ATermAppl)def.getArgument(0);
                ATermAppl b = (ATermAppl)def.getArgument(1);
                ATermAppl nota = ATermUtils.makeNot((ATerm)a);
                ATerm or = ATermUtils.normalize(ATermUtils.makeOr((ATerm)nota, (ATerm)b));
                boolean global = false;
                ATerm r = null;
                int n = 0;
                if (or.equals((Object)ATermUtils.TOP)) {
                    global = true;
                } else if (!or.equals((Object)ATermUtils.BOTTOM)) {
                    Object c;
                    if (a.getAFun().equals((Object)ATermUtils.MINFUN)) {
                        r = a.getArgument(0);
                        n = ((ATermInt)a.getArgument(1)).getInt();
                        boolean bl = global = n == 1;
                        if (global) {
                            c = (ATerm)this.domainRestrictions.get(r);
                            c = c != null ? ATermUtils.normalize(ATermUtils.makeAnd(c, (ATerm)b)) : b;
                            this.domainRestrictions.put(r, c);
                        }
                    } else if (b.getAFun().equals((Object)ATermUtils.MAXFUN)) {
                        r = b.getArgument(0);
                        n = ((ATermInt)b.getArgument(1)).getInt();
                        boolean bl = global = n == 0;
                        if (global) {
                            c = (ATerm)this.domainRestrictions.get(r);
                            a = (ATermAppl)ATermUtils.normalize((ATerm)ATermUtils.makeNot((ATerm)a));
                            c = c != null ? ATermUtils.normalize(ATermUtils.makeAnd(c, (ATerm)a)) : a;
                            this.domainRestrictions.put(r, a);
                        }
                    } else if (a.getAFun().equals((Object)ATermUtils.VALUEFUN)) {
                        ATerm x = a.getArgument(0);
                        global = true;
                        this.addType(x, (ATerm)b);
                    } else if (b.equals((Object)ATermUtils.TOP)) {
                        global = true;
                    }
                }
                if (!global) {
                    conjuncts = conjuncts.insert(or);
                    System.out.println(ATermUtils.normalize((ATerm)a) + " < " + ATermUtils.normalize((ATerm)b));
                }
            } else {
                throw new RuntimeException("Bad TBox - had term of unknown type (" + def.getName() + ")");
            }
            termlist = termlist.getNext();
        }
        ATerm and = ATermUtils.makeAnd(conjuncts);
        and = ATermUtils.normalize(and);
        this.UC = ATermUtils.andToList((ATermAppl)and);
        System.out.println("UC is (" + this.UC.getLength() + ")");
        ATermList l = this.UC;
        while (!l.isEmpty()) {
            ATermAppl disjunction = (ATermAppl)l.getFirst();
            a = (ATermAppl)disjunction.getArgument(0);
            if (a.getArity() > 0) {
                ATermList disjuncts = (ATermList)ATermUtils.normalize((ATerm)ATermUtils.negate((ATermList)a.getArgument(0)));
                System.out.println(disjuncts);
            } else {
                System.out.println(a);
            }
            l = l.getNext();
        }
    }

    private ABox complete() {
        boolean checkAllClashes = true;
        ABox aBox = this;
        this.changed = false;
        if (DEBUG) {
            System.out.println("completing " + aBox);
            System.out.print("Blocked nodes [");
            Iterator i = this.getNodeIterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                ATermAppl x = (ATermAppl)node.getName();
                if (!this.isBlocked((ATerm)x)) continue;
                System.out.print(x + " ");
            }
            System.out.println("]");
            if (this.nodeList.size() > 0) {
                this.printTree(this.getNode((ATerm)this.nodeList.get(0)), " ");
            }
        }
        Pellet.timers.startTimer("applyUnfoldingRule");
        aBox = aBox.applyUnfoldingRule();
        Pellet.timers.stopTimer("applyUnfoldingRule");
        aBox = aBox.applyDisjunctionRule();
        if (!aBox.dependencySet.isEmpty() || aBox.isComplete) {
            return aBox;
        }
        Pellet.timers.startTimer("applyAllValuesRule");
        aBox = aBox.applyAllValuesRule();
        Pellet.timers.stopTimer("applyAllValuesRule");
        Pellet.timers.startTimer("applyTransitiveAllValuesRule");
        aBox = aBox.applyTransitiveAllValuesRule();
        Pellet.timers.stopTimer("applyTransitiveAllValuesRule");
        Pellet.timers.startTimer("applySomeValuesRule");
        aBox = aBox.applySomeValuesRule();
        Pellet.timers.stopTimer("applySomeValuesRule");
        Pellet.timers.startTimer("applyMinRule");
        aBox = aBox.applyMinRule();
        Pellet.timers.stopTimer("applyMinRule");
        aBox = aBox.applyMaxRule(false);
        if (!aBox.dependencySet.isEmpty() || aBox.isComplete) {
            return aBox;
        }
        aBox = aBox.applyMaxRule(true);
        if (!aBox.dependencySet.isEmpty() || aBox.isComplete) {
            return aBox;
        }
        aBox = aBox.applyNominalRule();
        Pellet.timers.startTimer("hasClash");
        boolean hasClash = aBox.hasClash(true);
        Pellet.timers.stopTimer("hasClash");
        if (hasClash) {
            if (DEBUG) {
                System.out.println("found a clash " + this.branch + " " + aBox.dependencySet);
            }
            return aBox;
        }
        if (aBox.changed) {
            if (DEBUG) {
                System.out.println("rules were applied. continue to complete");
            }
            aBox = aBox.complete();
        } else {
            aBox.isComplete = true;
        }
        return aBox;
    }

    private ABox applyUnfoldingRule() {
        ABox newABox = this;
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            DependencySet ds;
            Node node = (Node)i.next();
            Pellet.timers.startTimer("unfoldingStart");
            ATermAppl nodeName = (ATermAppl)node.getName();
            if (this.isBlocked((ATerm)nodeName) || this.merged.containsKey(nodeName)) continue;
            Hashtable<ATerm, DependencySet> additions = new Hashtable<ATerm, DependencySet>();
            List[] primitiveTypes = new List[]{node.getAtomic(), node.getNegations()};
            Pellet.timers.stopTimer("unfoldingStart");
            int p = 0;
            while (p < 2) {
                Iterator j = primitiveTypes[p].iterator();
                while (j.hasNext()) {
                    ATerm cType = (ATerm)j.next();
                    Pellet.timers.startTimer("unfoldingClone");
                    ds = node.getDepends(cType).copy();
                    Pellet.timers.stopTimer("unfoldingClone");
                    boolean negated = false;
                    if (p == 1) {
                        if ((cType = ATermUtils.getNegatedPrimitive(cType)) == null) continue;
                        negated = true;
                    }
                    Pellet.timers.startTimer("unfoldingTBox");
                    TermDefinition termDef = this.tbox.Tu.getTD(cType);
                    Pellet.timers.stopTimer("unfoldingTBox");
                    if (termDef == null) continue;
                    Pellet.timers.startTimer("unfoldingSub");
                    if (!negated && termDef.sub != null) {
                        ATerm unfolded = termDef.sub.getArgument(1);
                        if (DEBUG && !node.hasType(unfolded)) {
                            System.out.println("Apply unfolding rule to  " + nodeName + ": " + cType + " -> " + unfolded + " " + ds);
                        }
                        additions.put(unfolded, ds);
                    }
                    Pellet.timers.stopTimer("unfoldingSub");
                    Pellet.timers.startTimer("unfoldingSame");
                    int k = 0;
                    while (k < termDef.samelist.size()) {
                        ATermAppl a = (ATermAppl)termDef.samelist.get(k);
                        ATerm unfolded = a.getArgument(1);
                        if (negated) {
                            unfolded = ATermUtils.negate(unfolded);
                        }
                        if (DEBUG && !node.hasType(unfolded)) {
                            System.out.println("Apply unfolding rule to  " + nodeName + ": " + cType + " -> " + unfolded + " " + ds);
                        }
                        additions.put(unfolded, ds);
                        ++k;
                    }
                    Pellet.timers.stopTimer("unfoldingSame");
                }
                ++p;
            }
            Pellet.timers.startTimer("unfoldingAdd");
            Iterator j = additions.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry entry = j.next();
                ATerm c = (ATerm)entry.getKey();
                ds = (DependencySet)entry.getValue();
                newABox.addType((ATerm)nodeName, c, ds);
            }
            Pellet.timers.stopTimer("unfoldingAdd");
        }
        return newABox;
    }

    private void applyGlobalRestrictions(Node node) {
        ATerm c;
        ATerm nodeName = node.getName();
        this.addType(nodeName, ATermUtils.TOP, DependencySet.initial);
        ATermList restr = this.globalRestrictions;
        while (!restr.isEmpty()) {
            c = restr.getFirst();
            this.addType(nodeName, restr.getFirst(), DependencySet.initial);
            restr = restr.getNext();
        }
        if (this.UC != null) {
            ATermList t = this.UC;
            while (!t.isEmpty()) {
                c = t.getFirst();
                this.addType(nodeName, t.getFirst(), DependencySet.initial);
                t = t.getNext();
            }
        }
    }

    private ABox applyConjunctionRule() {
        ABox newABox = this;
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            ATermAppl x = (ATermAppl)node.getName();
            List conjunctions = node.getConjunctions();
            if (conjunctions.isEmpty() || this.isIndirectlyBlocked((ATerm)x)) continue;
            Iterator j = conjunctions.iterator();
            while (j.hasNext()) {
                ATermAppl conjunction = (ATermAppl)j.next();
                ATermList conjuncts = (ATermList)conjunction.getArgument(0);
                boolean applyRule = false;
                ATermList c = conjuncts;
                while (!c.isEmpty()) {
                    ATerm conj = c.getFirst();
                    if (!node.hasType(conj)) {
                        applyRule = true;
                        break;
                    }
                    c = c.getNext();
                }
                if (!applyRule) continue;
                if (DEBUG) {
                    System.out.println("Apply conjunction rule to  " + x + " " + conjunction);
                }
                DependencySet ds = node.getDepends((ATerm)conjunction);
                ATermList c2 = conjuncts;
                while (!c2.isEmpty()) {
                    newABox.addType((ATerm)x, c2.getFirst(), ds);
                    c2 = c2.getNext();
                }
            }
        }
        return newABox;
    }

    private ABox applyDisjunctionRule() {
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            ATermAppl x = (ATermAppl)node.getName();
            List disjunctions = node.getDisjunctions();
            if (disjunctions.isEmpty() || this.isIndirectlyBlocked((ATerm)x)) continue;
            int j = disjunctions.size() - 1;
            while (j >= 0) {
                ATermAppl disjunction = (ATermAppl)disjunctions.get(j);
                ATermAppl a = (ATermAppl)disjunction.getArgument(0);
                ATermList disjuncts = ATermUtils.negate((ATermList)a.getArgument(0));
                boolean applyRule = true;
                ATermList c = disjuncts;
                while (!c.isEmpty()) {
                    if (node.hasType(c.getFirst())) {
                        applyRule = false;
                        break;
                    }
                    c = c.getNext();
                }
                if (applyRule) {
                    ABox newABox = this;
                    int size = disjuncts.getLength();
                    ATerm[] disj = ATermUtils.toArray(disjuncts);
                    DependencySet[] prevDS = new DependencySet[size];
                    int k = 0;
                    while (k < size) {
                        ATerm d = disj[k];
                        if (DEBUG) {
                            System.out.println("Apply disjunction rule (" + (k + 1) + "/" + size + ") at branch (" + this.branch + ") to  " + x + " " + d + " - " + disjunction);
                        }
                        newABox = USE_CLONING ? this.cloneABox() : this.copy();
                        newABox.branch = this.branch + 1;
                        if (USE_SEMANTIC_BRANCHING) {
                            int m = 0;
                            while (m < k) {
                                newABox.addType((ATerm)x, ATermUtils.negate(disj[m]), prevDS[m]);
                                ++m;
                            }
                        }
                        if (k == size - 1) {
                            DependencySet lastDS = node.getDepends((ATerm)disjunction);
                            if (lastDS == null) {
                                System.out.println("Null depends for " + x);
                                System.out.println("Apply disjunction rule (" + (k + 1) + "/" + size + ") at branch (" + this.branch + ") to  " + x + " " + d + " - " + disjunction);
                                System.out.println(disjunction);
                                System.out.println(node);
                            }
                            int m = 0;
                            while (m < k) {
                                lastDS = lastDS.union(prevDS[m]);
                                ++m;
                            }
                            lastDS.remove(this.branch);
                            newABox.addType((ATerm)x, d, lastDS.copy());
                        } else {
                            newABox.addType((ATerm)x, d, new DependencySet(this.branch));
                        }
                        Node thisNode = newABox.getNode((ATerm)x);
                        if (newABox.hasClash(thisNode, false)) {
                            if (DEBUG) {
                                System.out.println("Early clash detection worked at branch " + newABox.branch + " " + newABox.dependencySet + "!");
                            }
                        } else {
                            newABox = newABox.complete();
                        }
                        DependencySet ds = newABox.dependencySet;
                        boolean noClash = ds.isEmpty();
                        boolean backJump = USE_BACKJUMPING && !ds.contains(this.branch);
                        boolean skipRest = noClash || backJump;
                        prevDS[k] = ds.cloneSet();
                        prevDS[k].remove(this.branch);
                        if (DEBUG && backJump && !noClash) {
                            System.out.println("backjumping here " + this.branch + " " + ds);
                        }
                        if (skipRest) break;
                        if (!USE_CLONING) {
                            this.restore();
                        }
                        ++k;
                    }
                    if (DEBUG && k == size && !newABox.dependencySet.isEmpty()) {
                        System.out.println("Failing at " + this.branch);
                    }
                    return newABox;
                }
                --j;
            }
        }
        return this;
    }

    private ABox applySomeValuesRule() {
        ABox newABox = this;
        boolean ruleApplied = true;
        block0: while (ruleApplied) {
            ruleApplied = false;
            Iterator i = this.getNodeIterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                ATermAppl x = (ATermAppl)node.getName();
                List someValues = node.getSomeValues();
                if (someValues.isEmpty() || this.isBlocked((ATerm)x)) continue;
                Iterator j = someValues.iterator();
                while (j.hasNext()) {
                    ATermAppl sv = (ATermAppl)j.next();
                    ATermAppl a = (ATermAppl)sv.getArgument(0);
                    ATerm s = a.getArgument(0);
                    ATerm c = a.getArgument(1);
                    c = ATermUtils.negate(c);
                    boolean neighborFound = false;
                    EdgeList edges = this.getRNeighbors(s, (ATerm)x);
                    int e = 0;
                    while (!neighborFound && e < edges.size()) {
                        Edge edge = edges.edgeAt(e);
                        ATerm y = edge.from.equals((Object)x) ? edge.to : edge.from;
                        neighborFound = this.rbox.isDatatypeRole(s) ? this.getLiteral(y).hasType(c) : this.getNode(y).hasType(c);
                        ++e;
                    }
                    if (neighborFound) continue;
                    ATerm y = this.createUniqueName();
                    if (DEBUG) {
                        System.out.println("Apply some values rule to  " + x + " " + sv + " " + y);
                    }
                    DependencySet ds = node.getDepends((ATerm)sv).copy();
                    if (this.rbox.isDatatypeRole(s)) {
                        String value = null;
                        ATerm dtType = c;
                        if (ATermUtils.isNominal(c)) {
                            ATermAppl lit = (ATermAppl)((ATermAppl)c).getArgument(0);
                            value = ((ATermAppl)lit.getArgument(0)).getName();
                        }
                        newABox.addLiteral(y, value);
                        newABox.addLiteralType(y, dtType, ds);
                        newABox.addEdge(s, (ATerm)x, y, ds);
                    } else {
                        newABox.addNode(y);
                        newABox.addType(y, c, ds);
                        newABox.addEdge(s, (ATerm)x, y, ds);
                    }
                    ruleApplied = true;
                    break;
                }
                if (ruleApplied) continue block0;
            }
        }
        return newABox;
    }

    private ABox applyAllValuesRule() {
        ABox newABox = this;
        boolean ruleApplied = true;
        while (ruleApplied) {
            ruleApplied = false;
            Iterator i = this.getNodeIterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                ATermAppl x = (ATermAppl)node.getName();
                List allValues = node.getAllValues();
                if (allValues.isEmpty() || this.isIndirectlyBlocked((ATerm)x)) continue;
                Iterator j = allValues.iterator();
                while (j.hasNext()) {
                    ATermAppl av = (ATermAppl)j.next();
                    ATerm s = av.getArgument(0);
                    ATerm c = av.getArgument(1);
                    ATerm y = null;
                    Edge edgeToY = null;
                    EdgeList edges = this.getRNeighbors(s, (ATerm)x);
                    int e = 0;
                    while (y == null && e < edges.size()) {
                        edgeToY = edges.edgeAt(e);
                        y = edgeToY.from.equals((Object)x) ? edgeToY.to : edgeToY.from;
                        if (this.rbox.isDatatypeRole(s)) {
                            if (this.getLiteral(y).hasType(c)) {
                                y = null;
                            }
                        } else if (this.getNode(y).hasType(c)) {
                            y = null;
                        }
                        ++e;
                    }
                    if (y == null) continue;
                    if (DEBUG) {
                        System.out.println("Apply all values rule to  " + x + ", " + av + " " + y);
                    }
                    DependencySet ds = node.getDepends((ATerm)av).union(edgeToY.depends);
                    if (this.rbox.isDatatypeRole(s)) {
                        this.addLiteralType(y, c, ds);
                    } else {
                        this.addType(y, c, ds);
                    }
                    ruleApplied = true;
                }
            }
        }
        return newABox;
    }

    private ABox applyTransitiveAllValuesRule() {
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            ATermAppl x = (ATermAppl)node.getName();
            List allValues = node.getAllValues();
            if (allValues.isEmpty() || this.isIndirectlyBlocked((ATerm)x)) continue;
            Iterator j = allValues.iterator();
            while (j.hasNext()) {
                ATermAppl av = (ATermAppl)j.next();
                ATerm s = av.getArgument(0);
                ATerm c = av.getArgument(1);
                Iterator sr = this.rbox.getSubRoles(s).iterator();
                while (sr.hasNext()) {
                    ATerm r = (ATerm)sr.next();
                    if (!this.rbox.isTransitive(r)) continue;
                    ATermAppl allValuesRC = ATermUtils.makeAllValues(r, c);
                    ATerm y = null;
                    Edge edgeToY = null;
                    EdgeList edges = this.getRNeighbors(r, (ATerm)x);
                    int e = 0;
                    while (y == null && e < edges.size()) {
                        edgeToY = edges.edgeAt(e);
                        y = edgeToY.from.equals((Object)x) ? edgeToY.to : edgeToY.from;
                        if (this.getNode(y).hasType((ATerm)allValuesRC)) {
                            y = null;
                        }
                        ++e;
                    }
                    if (y == null) continue;
                    if (DEBUG) {
                        System.out.println("Apply transitive all values rule to  " + node);
                    }
                    DependencySet ds1 = node.getDepends((ATerm)av);
                    DependencySet ds2 = edgeToY.depends;
                    this.addType(y, (ATerm)allValuesRC, ds1.union(ds2));
                    return this.applyTransitiveAllValuesRule();
                }
            }
        }
        return this;
    }

    private ABox applyMinRule() {
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            ATermAppl x = (ATermAppl)node.getName();
            List minCardinality = node.getMinCardinality();
            if (minCardinality.isEmpty() || this.isBlocked((ATerm)x)) continue;
            Iterator j = minCardinality.iterator();
            while (j.hasNext()) {
                int n;
                ATermAppl mc = (ATermAppl)j.next();
                ATerm r = mc.getArgument(0);
                if (this.hasDistinctRNeighbors(r, (ATerm)x, n = ((ATermInt)mc.getArgument(1)).getInt()) != null) continue;
                if (DEBUG) {
                    System.out.println("Apply min rule to " + x + " " + mc);
                }
                DependencySet ds = node.getDepends((ATerm)mc);
                ATerm[] y = new ATerm[n];
                int c1 = 0;
                while (c1 < n) {
                    y[c1] = this.createUniqueName();
                    if (this.rbox.isDatatypeRole(r)) {
                        this.addLiteral(y[c1], null);
                    } else {
                        this.addNode(y[c1]);
                    }
                    this.addEdge(r, (ATerm)x, y[c1], ds);
                    ++c1;
                }
                if (this.rbox.isDatatypeRole(r)) {
                    c1 = 0;
                    while (c1 < n) {
                        int c2 = c1 + 1;
                        while (c2 < n) {
                            this.addLiteralDifferent(y[c1], y[c2]);
                            ++c2;
                        }
                        ++c1;
                    }
                } else {
                    c1 = 0;
                    while (c1 < n) {
                        int c2 = c1 + 1;
                        while (c2 < n) {
                            this.addDifferent(y[c1], y[c2]);
                            ++c2;
                        }
                        ++c1;
                    }
                }
                return this.applyMinRule();
            }
        }
        return this;
    }

    private ABox applyMaxRule(boolean applyRoots) {
        ABox newABox = this;
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            ATermAppl x = (ATermAppl)node.getName();
            List maxCardinality = node.getMaxCardinality();
            if (maxCardinality.isEmpty() || this.isIndirectlyBlocked((ATerm)x)) continue;
            Iterator j = maxCardinality.iterator();
            while (j.hasNext()) {
                Vector nsSet;
                ATermAppl mc = (ATermAppl)j.next();
                ATermAppl a = (ATermAppl)mc.getArgument(0);
                ATerm r = a.getArgument(0);
                int n = ((ATermInt)a.getArgument(1)).getInt() - 1;
                DependencySet ds = node.getDepends((ATerm)mc);
                Vector vector = nsSet = this.rbox.isDatatypeRole(r) ? this.findLiteralsForMax(r, (ATerm)x, n) : this.findNeighborsForMax(r, (ATerm)x, n, new Boolean(applyRoots));
                if (nsSet.size() == 0) continue;
                if (n == 0) {
                    EdgeList edges = this.getRNeighbors(r, (ATerm)x);
                    int e = 0;
                    while (e < edges.size()) {
                        Edge edge = edges.edgeAt(e);
                        ds = ds.union(edge.depends);
                        ++e;
                    }
                    newABox.dependencySet = ds;
                    return newABox;
                }
                DependencySet[] prevDS = new DependencySet[nsSet.size()];
                int k = 0;
                while (k < nsSet.size()) {
                    ATerm[] ns = (ATerm[])nsSet.get(k);
                    ATerm y = ns[0];
                    ATerm z = ns[1];
                    newABox = USE_CLONING ? this.cloneABox() : this.copy();
                    newABox.branch = this.branch + 1;
                    ds = ds.union(new DependencySet(this.branch));
                    if (DEBUG) {
                        System.out.println("Apply max rule to  (" + (k + 1) + "/" + nsSet.size() + ") at branch (" + this.branch + ") to  " + x + " for prop " + r + " merge " + y + " -> " + z);
                    }
                    if (applyRoots) {
                        newABox.mergeRootNodes(y, z, ds);
                    } else {
                        newABox.mergeNonRootNodes((ATerm)x, y, z, ds);
                    }
                    Node nodeZ = this.getNode(z);
                    if (newABox.hasClash(nodeZ, false)) {
                        if (DEBUG) {
                            System.out.println("Early clash detection worked at branch " + newABox.branch + " " + newABox.dependencySet + "!");
                        }
                    } else {
                        newABox = newABox.complete();
                    }
                    DependencySet d = newABox.dependencySet;
                    boolean noClash = d.isEmpty();
                    boolean backJump = USE_BACKJUMPING && !d.contains(this.branch);
                    boolean skipRest = noClash || backJump;
                    prevDS[k] = d.cloneSet();
                    prevDS[k].remove(this.branch);
                    if (DEBUG && backJump && !noClash) {
                        System.out.println("backjumping in max " + this.branch + " " + d);
                    }
                    if (skipRest) break;
                    if (!USE_CLONING) {
                        this.restore();
                    }
                    ++k;
                }
                if (!newABox.dependencySet.isEmpty()) {
                    DependencySet finalDS = ds;
                    int k2 = 0;
                    while (k2 < nsSet.size()) {
                        if (prevDS[k2] == null) break;
                        finalDS = finalDS.union(prevDS[k2]);
                        ++k2;
                    }
                    newABox.dependencySet = finalDS;
                }
                return newABox;
            }
        }
        return this;
    }

    private void mergeNonRootNodes(ATerm x, ATerm y, ATerm z, DependencySet ds) {
        ATermList yDiffs;
        Edge edge;
        int e;
        EdgeList edges;
        Pellet.timers.startTimer("mergeNonRootNodes");
        boolean isLiteral = this.isLiteral(y);
        if (isLiteral) {
            Literal lit = this.getLiteral(y);
            Iterator yTypes = lit.getTypes().iterator();
            while (yTypes.hasNext()) {
                ATerm yType = (ATerm)yTypes.next();
                this.addLiteralType(z, yType, lit.getDepends(yType).union(ds));
            }
        } else {
            ATermAppl valueY = ATermUtils.makeValue(y);
            Node n = this.getNode(y);
            Iterator yTypes = n.getTypes().iterator();
            while (yTypes.hasNext()) {
                ATerm yType = (ATerm)yTypes.next();
                if (yType.equals((Object)valueY)) continue;
                this.addType(z, yType, n.getDepends(yType).union(ds));
            }
        }
        if (this.isAncestor(z, x)) {
            edges = this.getEdges(x, y);
            e = 0;
            while (e < edges.size()) {
                edge = edges.edgeAt(e);
                this.addEdge(this.rbox.getInverseRole(edge.name), z, x, edge.depends.union(ds));
                ++e;
            }
        } else {
            edges = this.getEdges(x, y);
            e = 0;
            while (e < edges.size()) {
                edge = edges.edgeAt(e);
                this.addEdge(edge.name, x, z, edge.depends.union(ds));
                ++e;
            }
        }
        this.removeEdges(x, y);
        this.addEmptyEdge(x, y);
        if (isLiteral) {
            yDiffs = this.getDifferents(y);
            while (!yDiffs.isEmpty()) {
                if (!z.equals((Object)yDiffs.getFirst())) {
                    this.addLiteralDifferent(z, yDiffs.getFirst());
                }
                yDiffs = yDiffs.getNext();
            }
        } else {
            yDiffs = this.getDifferents(y);
            while (!yDiffs.isEmpty()) {
                if (!z.equals((Object)yDiffs.getFirst())) {
                    this.addDifferent(z, yDiffs.getFirst());
                }
                yDiffs = yDiffs.getNext();
            }
        }
        Pellet.timers.startTimer("mergeNonRootNodes");
    }

    private void mergeRootNodes(ATerm y, ATerm z, DependencySet ds) {
        ATerm yType;
        Iterator yTypes;
        Pellet.timers.startTimer("mergeRootNodes");
        boolean isLiteral = this.isLiteral(y);
        if (isLiteral) {
            Literal lit = this.getLiteral(y);
            yTypes = lit.getTypes().iterator();
            while (yTypes.hasNext()) {
                yType = (ATerm)yTypes.next();
                this.addLiteralType(z, yType, lit.getDepends(yType).union(ds));
            }
        } else {
            Node n = this.getNode(y);
            yTypes = n.getTypes().iterator();
            while (yTypes.hasNext()) {
                yType = (ATerm)yTypes.next();
                this.addType(z, yType, n.getDepends(yType).union(ds));
            }
        }
        EdgeList outEdges = this.getOutEdges(y);
        int e = 0;
        while (e < outEdges.size()) {
            Edge edge = outEdges.edgeAt(e);
            ATerm R = edge.name;
            ATerm w = edge.to;
            this.addEdge(R, z, w, edge.depends.union(ds));
            ++e;
        }
        EdgeList inEdges = this.getInEdges(y);
        int e2 = 0;
        while (e2 < inEdges.size()) {
            Edge edge = inEdges.edgeAt(e2);
            ATerm R = edge.name;
            ATerm w = edge.from;
            this.addEdge(R, w, z, edge.depends.union(ds));
            ++e2;
        }
        this.removeTypes(y);
        this.removeEdges(y);
        if (isLiteral) {
            ATermList yDiffs = this.getDifferents(y);
            while (!yDiffs.isEmpty()) {
                if (!z.equals((Object)yDiffs.getFirst())) {
                    this.addLiteralDifferent(z, yDiffs.getFirst());
                }
                yDiffs = yDiffs.getNext();
            }
        } else {
            ATermList yDiffs = this.getDifferents(y);
            while (!yDiffs.isEmpty()) {
                if (!z.equals((Object)yDiffs.getFirst())) {
                    this.addDifferent(z, yDiffs.getFirst());
                }
                yDiffs = yDiffs.getNext();
            }
        }
        if (isLiteral) {
            this.addLiteralSame(y, z);
        } else {
            this.addSame(y, z);
        }
        Pellet.timers.stopTimer("mergeRootNodes");
    }

    private Vector findNeighborsForMax(ATerm r, ATerm x, int n, Boolean findRoots) {
        Pellet.timers.startTimer("findNeighborsForMax");
        Vector<ATerm[]> answer = new Vector<ATerm[]>();
        EdgeList edges = this.getRNeighbors(r, x);
        ATerm[] neighbors = edges.getNeighbors(x);
        int[] index = this.getIndex(neighbors);
        index = this.sames.removeDuplicates(index);
        if (index.length <= n) {
            return answer;
        }
        Node[] nodes = this.getNode(index);
        int i = 0;
        while (i < nodes.length) {
            ATerm y = nodes[i].getName();
            int j = i + 1;
            while (j < nodes.length) {
                block13: {
                    ATerm z;
                    block14: {
                        z = nodes[j].getName();
                        if (this.isDifferent(y, z)) break block13;
                        if (findRoots != null && !findRoots.booleanValue()) break block14;
                        if (this.isNonRootNode(y) || this.isNonRootNode(z)) break block13;
                        if (!this.isAncestor(y, z)) {
                            answer.add(new ATerm[]{y, z});
                        } else if (!this.isAncestor(z, y)) {
                            answer.add(new ATerm[]{z, y});
                        }
                    }
                    if (findRoots == null || !findRoots.booleanValue()) {
                        if (this.isNonRootNode(y) && !this.isAncestor(y, z)) {
                            answer.add(new ATerm[]{y, z});
                        } else if (this.isNonRootNode(z) && !this.isAncestor(z, y)) {
                            answer.add(new ATerm[]{z, y});
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        Pellet.timers.stopTimer("findNeighborsForMax");
        return answer;
    }

    private Vector findLiteralsForMax(ATerm r, ATerm x, int n) {
        Vector<ATerm[]> answer = new Vector<ATerm[]>();
        EdgeList edges = this.getRNeighbors(r, x);
        ATerm[] neighbors = edges.getNeighbors(x);
        int[] index = this.getLiteralIndex(neighbors);
        if ((index = this.dtSames.removeDuplicates(index)).length <= n) {
            return answer;
        }
        Literal[] literals = this.getLiteral(index);
        int i = 0;
        while (i < literals.length) {
            ATerm y = literals[i].getName();
            int j = i + 1;
            while (j < literals.length) {
                ATerm z = literals[j].getName();
                if (!this.isDifferent(y, z)) {
                    answer.add(new ATerm[]{y, z});
                }
                ++j;
            }
            ++i;
        }
        return answer;
    }

    private DependencySet hasDistinctRNeighbors(ATerm r, ATerm x, long n) {
        Pellet.timers.startTimer("hasDistinctRNeighbors");
        EdgeList edges = this.getRNeighbors(r, x);
        ATerm[] neighbors = edges.getNeighbors(x);
        int[] index = null;
        if (this.rbox.isDatatypeRole(r)) {
            index = this.getLiteralIndex(neighbors);
            index = this.dtSames.removeDuplicates(index);
        } else {
            index = this.getIndex(neighbors);
            index = this.sames.removeDuplicates(index);
        }
        DependencySet ds = null;
        if ((long)index.length >= n) {
            ds = new DependencySet();
            int i = 0;
            while (i < edges.size()) {
                ds = this.dependencySet.union(edges.edgeAt((int)i).depends);
                ++i;
            }
        }
        Pellet.timers.stopTimer("hasDistinctRNeighbors");
        return ds;
    }

    private ABox applyNominalRule() {
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            ATermAppl y = (ATermAppl)node.getName();
            List nominals = node.getNominals();
            if (nominals.isEmpty() || this.isBlocked((ATerm)y)) continue;
            Iterator j = nominals.iterator();
            while (j.hasNext()) {
                ATermAppl nc = (ATermAppl)j.next();
                ATerm z = nc.getArgument(0);
                if (this.merged.containsKey(z)) {
                    z = (ATerm)this.merged.get(z);
                }
                if (y.equals((Object)z) || this.isSame((ATerm)y, z) || this.isDifferent((ATerm)y, z)) continue;
                if (DEBUG) {
                    System.out.println("Apply nominal rule to  " + node);
                    System.out.println("Merge  " + z + " " + y);
                }
                Iterator m = this.merged.entrySet().iterator();
                while (m.hasNext()) {
                    Map.Entry e = m.next();
                    ATerm v = (ATerm)e.getKey();
                    ATerm w = (ATerm)e.getValue();
                    if (!w.equals((Object)y)) continue;
                    this.merged.put(v, z);
                }
                this.merged.put(y, z);
                DependencySet ds = node.getDepends((ATerm)nc);
                this.mergeRootNodes((ATerm)y, z, ds);
                if (DEBUG) {
                    System.out.println("After nominal rule " + this);
                }
                return this.applyNominalRule();
            }
        }
        return this;
    }

    private ABox applyOWLRules() {
        Iterator i = this.rules.iterator();
        Vector temp = this.rules;
        this.rules = new Vector();
        ABoxQuery query = new ABoxQuery(this);
        while (i.hasNext()) {
            OWLRule rule = (OWLRule)i.next();
            Vector results = null;
            try {
                long time = System.currentTimeMillis();
                query.setQuery(rule.ruleBody);
                results = query.runQuery();
                time = System.currentTimeMillis() - time;
                System.out.println("Query execution: " + time);
            }
            catch (Exception e) {
                if (DEBUG) {
                    System.out.println("Rule query caused an exception " + rule);
                }
                e.printStackTrace();
            }
            if (results == null) {
                if (!DEBUG) continue;
                System.out.println("Rule didn't fire " + rule);
                continue;
            }
            System.out.println("Rule is firing " + rule);
            ATermAppl consequent = (ATermAppl)rule.ruleHead.get(0);
            ATerm var1 = consequent.getArgument(0);
            ATerm var2 = consequent.getArity() > 2 ? consequent.getArgument(2) : null;
            int j = 0;
            while (j < results.size()) {
                Hashtable bindings = (Hashtable)results.get(j);
                if (consequent.getAFun().equals((Object)ATermUtils.TYPEFUN)) {
                    ATerm c = consequent.getArgument(1);
                    ATerm binding = (ATerm)bindings.get(var1);
                    if (!this.isBlocked(binding)) {
                        System.out.println("rule adds type " + binding + " " + c);
                        this.addType(binding, c, new DependencySet(0, this.branch));
                    }
                } else if (consequent.getAFun().equals((Object)ATermUtils.IPFUN)) {
                    ATerm p = consequent.getArgument(1);
                    ATerm binding1 = (ATerm)bindings.get(var1);
                    ATerm binding2 = (ATerm)bindings.get(var2);
                    if (!this.isBlocked(binding1)) {
                        if (!this.getNode(binding1).hasEdge(p, binding2)) {
                            System.out.println("rule adds edge " + binding1 + " " + p + " " + binding2);
                        }
                        this.addEdge(p, binding1, binding2, new DependencySet(0, this.branch));
                    }
                }
                ++j;
            }
        }
        this.rules = temp;
        return this;
    }

    private boolean hasClash(boolean checkAllClashes) {
        if (DEBUG) {
            System.out.println("Check clash in " + this);
        }
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (!this.hasClash(node, checkAllClashes)) continue;
            if (DEBUG) {
                System.out.println("found a clash in " + node.getName());
            }
            return true;
        }
        i = this.literals.values().iterator();
        while (i.hasNext()) {
            Literal lit = (Literal)i.next();
            if (!this.hasClash(lit)) continue;
            if (DEBUG) {
                System.out.println("found a clash in " + lit);
            }
            return true;
        }
        return false;
    }

    private boolean hasClash(Literal lit) {
        Object val = lit.getValue();
        ATerm[] dt = new ATerm[lit.getDatatypes().size()];
        lit.getDatatypes().toArray(dt);
        if (lit.hasType(ATermUtils.BOTTOM)) {
            this.dependencySet = lit.getDepends(ATermUtils.BOTTOM);
            if (DEBUG) {
                System.out.println("1) Literal clash dependency = " + this.dependencySet);
            }
            return true;
        }
        boolean clash = this.dtReasoner.isEmpty(dt, val);
        if (clash) {
            this.dependencySet = new DependencySet();
            int i = 0;
            while (i < dt.length) {
                this.dependencySet = this.dependencySet.union(lit.getDepends(dt[i]));
                ++i;
            }
            if (DEBUG) {
                System.out.println("2) Literal clash dependency " + dt + " = " + this.dependencySet);
            }
        }
        return clash;
    }

    private boolean hasClash(Node node, boolean checkAllClashes) {
        ATerm r;
        ATerm x = node.getName();
        Pellet.timers.startTimer("clashNegation");
        List[] negations = new List[]{node.getNegations(), node.getSomeValues(), node.getDisjunctions()};
        int p = 0;
        while (p < 3) {
            Iterator i = negations[p].iterator();
            while (i.hasNext()) {
                ATermAppl negation = (ATermAppl)i.next();
                ATerm c = negation.getArgument(0);
                DependencySet ds = node.getDepends((ATerm)negation);
                if (!node.hasType(c)) continue;
                this.dependencySet = ds.union(node.getDepends(c));
                if (DEBUG) {
                    System.out.println("5) Clash dependency " + x + " has " + negation + " and " + c + " -> " + ds + " U " + node.getDepends(c) + " = " + this.dependencySet);
                }
                Pellet.timers.stopTimer("clashNegation");
                return true;
            }
            ++p;
        }
        Pellet.timers.stopTimer("clashNegation");
        Pellet.timers.startTimer("clashMax");
        Iterator i = node.getMaxCardinality().iterator();
        while (i.hasNext()) {
            DependencySet dsEdges;
            ATermAppl mc = (ATermAppl)i.next();
            ATermAppl a = (ATermAppl)mc.getArgument(0);
            r = a.getArgument(0);
            int n = ((ATermInt)a.getArgument(1)).getInt() - 1;
            DependencySet ds = node.getDepends((ATerm)mc);
            Iterator j = node.getMinCardinality().iterator();
            while (j.hasNext()) {
                ATermAppl min = (ATermAppl)j.next();
                ATerm r2 = min.getArgument(0);
                int n2 = ((ATermInt)min.getArgument(1)).getInt();
                if (!r.equals((Object)r2) || n >= n2) continue;
                this.dependencySet = ds.union(node.getDepends((ATerm)min));
                if (DEBUG) {
                    System.out.println("4) Clash dependency " + x + " has " + min + " and " + mc + " -> " + ds + " U " + node.getDepends((ATerm)min) + " = " + this.dependencySet);
                }
                Pellet.timers.stopTimer("clashMax");
                return true;
            }
            if (!checkAllClashes || (dsEdges = this.hasDistinctRNeighbors(r, x, n + 1)) == null) continue;
            this.dependencySet = ds.union(dsEdges);
            if (DEBUG) {
                System.out.println("3) Clash dependency all " + x + " has " + mc + " and more neighbors -> " + this.dependencySet);
            }
            Pellet.timers.stopTimer("clashMax");
            return true;
        }
        Pellet.timers.stopTimer("clashMax");
        if (!checkAllClashes) {
            return false;
        }
        if (CHECK_DATATYPE_COUNT) {
            Pellet.timers.startTimer("clashDatatype");
            Hashtable allValues = new Hashtable();
            Hashtable<ATerm, DependencySet> depends = new Hashtable<ATerm, DependencySet>();
            Iterator<Object> i2 = node.getAllValues().iterator();
            while (i2.hasNext()) {
                ATermAppl av = (ATermAppl)i2.next();
                ATerm r2 = av.getArgument(0);
                ATerm c = av.getArgument(1);
                if (!this.rbox.isDatatypeRole(r2)) continue;
                Vector<ATerm> ranges = (Vector<ATerm>)allValues.get(r2);
                DependencySet ds = (DependencySet)depends.get(r2);
                if (ranges == null) {
                    ranges = new Vector<ATerm>();
                    ds = new DependencySet();
                }
                ATerm[] dt = new ATerm[1];
                if (ATermUtils.isAnd(c)) {
                    dt = ATermUtils.toArray((ATermList)((ATermAppl)c).getArgument(0));
                } else {
                    dt[0] = c;
                }
                int k = 0;
                while (k < dt.length) {
                    ranges.add(dt[k]);
                    ++k;
                }
                ds = ds.union(node.getDepends((ATerm)av));
                allValues.put(r2, ranges);
                depends.put(r2, ds);
            }
            i2 = allValues.keySet().iterator();
            while (i2.hasNext()) {
                r = (ATerm)i2.next();
                Vector ranges = (Vector)allValues.get(r);
                ATerm[] dt = new ATerm[ranges.size()];
                int k = 0;
                while (k < dt.length) {
                    dt[k] = (ATerm)ranges.get(k);
                    ++k;
                }
                Pellet.timers.startTimer("getMaxCount");
                long n = this.dtReasoner.getMaxCount(dt);
                Pellet.timers.stopTimer("getMaxCount");
                DependencySet dsEdges = this.hasDistinctRNeighbors(r, x, n + 1L);
                if (dsEdges == null) continue;
                DependencySet ds = (DependencySet)depends.get(r);
                this.dependencySet = ds.union(dsEdges);
                if (DEBUG) {
                    System.out.println("7) Clash dependency literal restriction " + x + " has " + ranges + " and more neighbors -> " + this.dependencySet);
                }
                Pellet.timers.stopTimer("clashDatatype");
                return true;
            }
            Pellet.timers.stopTimer("clashDatatype");
        }
        i = node.getNominals().iterator();
        while (i.hasNext()) {
            ATermAppl nominal = (ATermAppl)i.next();
            ATerm value = nominal.getArgument(0);
            if (this.isSame(value, x)) continue;
            this.dependencySet = node.getDepends((ATerm)nominal).cloneSet();
            if (DEBUG) {
                System.out.println("2) Clash dependency " + x + " has " + nominal + " -> " + this.dependencySet);
            }
            Pellet.timers.stopTimer("clashNominal");
            return true;
        }
        return false;
    }

    public Node getNode(ATerm x) {
        return (Node)this.nodes.get(x);
    }

    private Literal getLiteral(ATerm x) {
        return (Literal)this.literals.get(x);
    }

    private EdgeList getEdges(ATerm x, ATerm y) {
        Node n = this.getNode(x);
        return n.getEdges(y);
    }

    private EdgeList getOutEdges(ATerm x) {
        return this.getNode(x).getEdges();
    }

    private EdgeList getInEdges(ATerm x) {
        return this.getNode(x).getReverseEdges();
    }

    private HashSet getSuccessors(ATerm x, boolean isRecursive, HashSet relatives) {
        Node node = this.getNode(x);
        Iterator i = node.getSuccessors().iterator();
        while (i.hasNext()) {
            ATerm succ = (ATerm)i.next();
            if (relatives.contains(succ)) continue;
            relatives.add(succ);
            if (!isRecursive || succ == x) continue;
            this.getPredecessors(succ, isRecursive, relatives);
        }
        return relatives;
    }

    private HashSet getPredecessors(ATerm x, boolean isRecursive, HashSet relatives) {
        Node node = this.getNode(x);
        Iterator i = node.getPredecessors().iterator();
        while (i.hasNext()) {
            ATerm succ = (ATerm)i.next();
            if (relatives.contains(succ)) continue;
            relatives.add(succ);
            if (!isRecursive || succ == x) continue;
            this.getPredecessors(succ, isRecursive, relatives);
        }
        return relatives;
    }

    private HashSet getSuccessors(ATerm x) {
        return this.getSuccessors(x, false, new HashSet());
    }

    private HashSet getPredecessors(ATerm x) {
        return this.getPredecessors(x, false, new HashSet());
    }

    private HashSet getDescendants(ATerm x) {
        return this.getSuccessors(x, true, new HashSet());
    }

    private HashSet getAncestors(ATerm x) {
        return this.getPredecessors(x, true, new HashSet());
    }

    private EdgeList getRRelatives(ATerm r, ATerm x, boolean findSuccessors) {
        Pellet.timers.startTimer("getRRelatives");
        HashSet subRoles = this.rbox.getSubRoles(r);
        EdgeList relatives = new EdgeList();
        EdgeList edges = findSuccessors ? this.getOutEdges(x) : this.getInEdges(x);
        int i = 0;
        while (i < edges.size()) {
            Edge edge = edges.edgeAt(i);
            if (subRoles.contains(edge.name)) {
                relatives.addEdge(edge);
            }
            ++i;
        }
        Pellet.timers.stopTimer("getRRelatives");
        return relatives;
    }

    private EdgeList getRSuccessors(ATerm r, ATerm x) {
        return this.getRRelatives(r, x, true);
    }

    private EdgeList getRPredecessors(ATerm r, ATerm x) {
        return this.getRRelatives(r, x, false);
    }

    private EdgeList getRNeighbors(ATerm r, ATerm x) {
        EdgeList neighbors = this.getRSuccessors(r, x);
        ATerm inverse = this.rbox.getInverseRole(r);
        if (inverse != null) {
            neighbors.addEdgeList(this.getRPredecessors(inverse, x));
        }
        return neighbors;
    }

    private boolean isSuccessor(ATerm x, ATerm y) {
        return this.getEdges(y, x) != null;
    }

    private boolean isPredecessor(ATerm x, ATerm y) {
        return this.getEdges(x, y) != null;
    }

    private boolean isAncestor(ATerm x, ATerm y) {
        return this.getAncestors(y).contains(x);
    }

    private boolean isRSuccessor(ATerm r, ATerm x, ATerm y) {
        return !this.getRSuccessors(r, x).getEdgesTo(y).isEmpty();
    }

    private boolean isRNeighbor(ATerm r, ATerm x, ATerm y) {
        return !this.getRNeighbors(r, x).getEdgesTo(y).isEmpty();
    }

    public boolean edgeExists(ATerm r, ATerm x, ATerm y) {
        return this.isRNeighbor(r, x, y);
    }

    public boolean edgeExists(ATerm r, ATerm x) {
        return this.getRNeighbors(r, x).size() > 0;
    }

    private boolean isBlocked(ATerm x) {
        Pellet.timers.startTimer("blocking");
        boolean isBlocked = this.isNonRootNode(x) && (this.isIndirectlyBlocked(x) || this.isDirectlyBlocked(x));
        Pellet.timers.stopTimer("blocking");
        return isBlocked;
    }

    private boolean isAncestorBlocked(ATerm x) {
        Iterator ancestors = this.getAncestors(x).iterator();
        while (ancestors.hasNext()) {
            ATerm ancestor = (ATerm)ancestors.next();
            if (ancestor.equals((Object)x) || !this.isBlocked(ancestor)) continue;
            return true;
        }
        return false;
    }

    private boolean isIndirectlyBlocked(ATerm y) {
        Iterator succ = this.getPredecessors(y).iterator();
        while (succ.hasNext()) {
            ATerm x = (ATerm)succ.next();
            EdgeList edgesXY = this.getEdges(x, y);
            if (edgesXY == null || edgesXY.size() != 0) continue;
            return true;
        }
        return this.isAncestorBlocked(y);
    }

    private boolean isDirectlyBlocked(ATerm x) {
        Iterator ancestors = this.getAncestors(x).iterator();
        Iterator predecessors = this.getPredecessors(x).iterator();
        while (predecessors.hasNext()) {
            ATerm x1 = (ATerm)predecessors.next();
            while (ancestors.hasNext()) {
                ATerm y = (ATerm)ancestors.next();
                if (this.isRootNode(y)) continue;
                Iterator y1s = this.getPredecessors(y).iterator();
                while (y1s.hasNext()) {
                    ATerm y1 = (ATerm)y1s.next();
                    if (x.equals((Object)y) || y.equals((Object)y1) || !this.blockCondition2(x, x1, y, y1) || !this.blockCondition3(x, x1, y, y1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean blockCondition2(ATerm x, ATerm x1, ATerm y, ATerm y1) {
        return this.hasSameTypes(x, y) && this.hasSameTypes(x1, y1);
    }

    private boolean hasSameTypes(ATerm x, ATerm y) {
        Node n = this.getNode(x);
        Iterator yTypes = this.getNode(y).getTypes().iterator();
        while (yTypes.hasNext()) {
            ATerm c = (ATerm)yTypes.next();
            if (n.hasType(c)) continue;
            return false;
        }
        return true;
    }

    private boolean blockCondition3(ATerm x, ATerm x1, ATerm y, ATerm y1) {
        EdgeList xEdges = this.getEdges(x1, x);
        EdgeList yEdges = this.getEdges(y1, y);
        int i = 0;
        while (i < xEdges.size()) {
            if (!yEdges.hasEdge(xEdges.edgeAt((int)i).name)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addLiteralSame(ATerm x, ATerm y) {
        this.changed = true;
        this.dtSames.setSameAs(this.getLiteralIndex(x), this.getLiteralIndex(y));
    }

    public void addSame(ATerm x, ATerm y) {
        this.changed = true;
        this.sames.setSameAs(this.getIndex(x), this.getIndex(y));
    }

    public void addDifferent(ATerm x, ATerm y) {
        this.changed = true;
        this.differents.setDifferentFrom(this.getIndex(x), this.getIndex(y));
    }

    public void addLiteralDifferent(ATerm x, ATerm y) {
        this.changed = true;
        this.dtDifferents.setDifferentFrom(this.getLiteralIndex(x), this.getLiteralIndex(y));
    }

    public int getIndex(ATerm x) {
        return this.getNode(x).getIndex();
    }

    public int[] getIndex(ATerm[] x) {
        int[] index = new int[x.length];
        int i = 0;
        while (i < x.length) {
            index[i] = this.getIndex(x[i]);
            ++i;
        }
        return index;
    }

    public Node getNode(int i) {
        ATerm x = (ATerm)this.nodeList.get(i);
        return this.getNode(x);
    }

    public Node[] getNode(int[] index) {
        Node[] nodes = new Node[index.length];
        int i = 0;
        while (i < index.length) {
            nodes[i] = this.getNode(index[i]);
            ++i;
        }
        return nodes;
    }

    public Literal getLiteral(int i) {
        ATerm x = (ATerm)this.literalList.get(i);
        return this.getLiteral(x);
    }

    public Literal[] getLiteral(int[] index) {
        Literal[] literals = new Literal[index.length];
        int i = 0;
        while (i < index.length) {
            literals[i] = this.getLiteral(index[i]);
            ++i;
        }
        return literals;
    }

    public int getLiteralIndex(ATerm x) {
        return this.getLiteral((ATerm)x).index;
    }

    public int[] getLiteralIndex(ATerm[] x) {
        int[] index = new int[x.length];
        int i = 0;
        while (i < x.length) {
            index[i] = this.getLiteralIndex(x[i]);
            ++i;
        }
        return index;
    }

    public boolean isSame(ATerm x, ATerm y) {
        if (this.isNode(x) && this.isNode(y)) {
            return this.sames.isSameAs(this.getIndex(x), this.getIndex(y));
        }
        if (this.isLiteral(x) && this.isLiteral(y)) {
            return this.dtSames.isSameAs(this.getLiteralIndex(x), this.getLiteralIndex(y));
        }
        return false;
    }

    public boolean isDifferent(ATerm x, ATerm y) {
        if (this.isNode(x) && this.isNode(y)) {
            return this.differents.isDifferentFrom(this.getIndex(x), this.getIndex(y));
        }
        if (this.isLiteral(x) && this.isLiteral(y)) {
            Literal l1 = this.getLiteral(x);
            Literal l2 = this.getLiteral(y);
            if (this.dtDifferents.isDifferentFrom(this.getLiteralIndex(x), this.getLiteralIndex(y))) {
                return true;
            }
            if (l1.value != null && l2.value != null) {
                return !l1.value.equals(l2.value);
            }
            if (l1.value == null && l2.value == null) {
                return false;
            }
        }
        return true;
    }

    private ATermList getDifferents(ATerm x) {
        boolean isNode = this.isNode(x);
        Vector list = isNode ? this.differents.getDifferentFrom(this.getIndex(x)) : this.dtDifferents.getDifferentFrom(this.getLiteralIndex(x));
        ATermList result = ATermUtils.makeList();
        int i = 0;
        while (i < list.size()) {
            int index = (Integer)list.get(i);
            ATerm diff = isNode ? this.getNode(index).getName() : this.getLiteral(index).getName();
            result = result.append(diff);
            ++i;
        }
        return result;
    }

    private ATermList getSames(ATerm x) {
        boolean isNode = this.isNode(x);
        Vector list = isNode ? this.sames.getSameAs(this.getIndex(x)) : this.dtSames.getSameAs(this.getLiteralIndex(x));
        ATermList result = ATermUtils.makeList();
        int i = 0;
        while (i < list.size()) {
            int index = (Integer)list.get(i);
            ATerm eq = isNode ? this.getNode(index).getName() : this.getLiteral(index).getName();
            result = result.append(eq);
            ++i;
        }
        return result;
    }

    public void addLiteralType(ATerm x, ATerm c, DependencySet d) {
        Literal n = this.getLiteral(x);
        if (n.hasType(c)) {
            return;
        }
        this.changed = true;
        d.branch = this.branch;
        n.addType(c, d);
    }

    private void addType(ATerm x, ATerm c, DependencySet d) {
        Node n = this.getNode(x);
        if (n.hasType(c)) {
            return;
        }
        this.changed = true;
        d = d.copy();
        d.branch = this.branch;
        n.addType(c, d);
    }

    public void addType(ATerm x, ATerm c) {
        c = ATermUtils.normalize(c);
        this.addType(x, c, DependencySet.initial);
    }

    public void removeTypes(ATerm x) {
        this.changed = true;
        Node n = this.getNode(x);
        n.removeTypes(this.branch);
    }

    public Literal addLiteral(ATerm name, Object value) {
        Literal lit = new Literal(name, value, this.branch);
        lit.index = this.literalList.size();
        this.literalList.add(name);
        this.dtSames.incrementSize();
        this.dtDifferents.incrementSize();
        ++this.literalCount;
        this.literals.put(name, lit);
        return lit;
    }

    public Node addNode(ATerm x) {
        if (this.nodes.containsKey(x)) {
            throw new RuntimeException("adding a node twice " + x);
        }
        this.changed = true;
        Node n = new Node(x, this.nodes.size(), this.branch);
        this.nodes.put(x, n);
        this.nodeList.add(x);
        this.sames.incrementSize();
        this.differents.incrementSize();
        ++this.nodeCount;
        ATermAppl valueX = ATermUtils.makeValue(x);
        if (this.isRootNode(x)) {
            if (this.branch == -1) {
                this.addType(x, (ATerm)valueX, DependencySet.initial);
            } else {
                this.addType(x, (ATerm)valueX, new DependencySet(this.branch));
            }
        } else {
            this.applyGlobalRestrictions(n);
        }
        return n;
    }

    public void addEdge(ATerm r, ATerm x, ATerm y) {
        this.addEdge(r, x, y, DependencySet.initial);
    }

    private void addEdge(ATerm r, ATerm x, ATerm y, DependencySet d) {
        Node n = this.getNode(x);
        if (n.hasEdge(r, y)) {
            return;
        }
        this.changed = true;
        d = d.copy();
        d.branch = this.branch;
        Edge e = new Edge(r, x, y, d);
        n.addEdge(e);
        Node m = this.getNode(y);
        if (m != null) {
            m.addReverseEdge(e);
        }
        Iterator i = this.rbox.getSuperRoles(r).iterator();
        while (i.hasNext()) {
            ATerm s = (ATerm)i.next();
            ATerm gc = (ATerm)this.domainRestrictions.get(s);
            if (gc == null) continue;
            this.addType(x, gc, d);
            break;
        }
        ATerm invR = this.rbox.getInverseRole(r);
        if (invR == null) {
            return;
        }
        i = this.rbox.getSuperRoles(invR).iterator();
        while (i.hasNext()) {
            ATerm s = (ATerm)i.next();
            ATerm gc = (ATerm)this.domainRestrictions.get(s);
            if (gc == null) continue;
            this.addType(y, gc, d);
            break;
        }
    }

    private void removeEdges(ATerm x, ATerm y) {
        this.changed = true;
        this.getNode(x).removeEdge(y, this.branch);
        this.getNode(y).removeReverseEdge(x, this.branch);
    }

    private void addEmptyEdge(ATerm x, ATerm y) {
        this.changed = true;
        Node n = this.getNode(x);
        Node m = this.getNode(y);
        n.addEmptyEdge(y);
        if (m != null) {
            m.addEmptyReverseEdge(x);
        }
    }

    private void removeEdges(ATerm x) {
        ATerm y;
        this.changed = true;
        Iterator i = this.getSuccessors(x).iterator();
        while (i.hasNext()) {
            y = (ATerm)i.next();
            this.removeEdges(x, y);
        }
        i = this.getPredecessors(x).iterator();
        while (i.hasNext()) {
            y = (ATerm)i.next();
            this.removeEdges(y, x);
        }
    }

    public void removeNode(ATerm x) {
        this.removeEdges(x);
        this.nodes.remove(x);
    }

    public void removeNodes(ATermList list) {
        while (!list.isEmpty()) {
            this.removeNode(list.getFirst());
            list = list.getNext();
        }
    }

    public boolean isRole(ATerm r) {
        return this.rbox.isRole(r);
    }

    public boolean isNode(ATerm x) {
        return this.getNode(x) != null;
    }

    private boolean isRootNode(ATerm x) {
        return !this.isNonRootNode(x);
    }

    private boolean isNonRootNode(ATerm x) {
        return this.getNode(x).getNameStr().startsWith(anonPrefix);
    }

    public boolean isLiteral(ATerm l) {
        return this.getLiteral(l) != null;
    }

    public boolean hasType(ATerm x, ATerm c) {
        return this.getNode(x).hasType(ATermUtils.normalize(c));
    }

    public ATerm createUniqueName() {
        return ATermUtils.makeTermAppl(anonPrefix + ++this.anonCount);
    }

    private String getDifferents() {
        String diffs = "";
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            ATermAppl x = (ATermAppl)node.getName();
            ATermList d = this.getDifferents((ATerm)x);
            if (d.getLength() <= 0) continue;
            diffs = String.valueOf(diffs) + x + "!=" + d;
        }
        return diffs;
    }

    private String getSames() {
        String diffs = "";
        Iterator i = this.getNodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            ATermAppl x = (ATermAppl)node.getName();
            ATermList d = this.getSames((ATerm)x);
            if (d.getLength() <= 1) continue;
            diffs = String.valueOf(diffs) + x + "=" + d + ", ";
        }
        return diffs;
    }

    public Collection getNodes() {
        return this.nodes.values();
    }

    public Vector getNodeNames() {
        return this.nodeList;
    }

    public Iterator getNodeIterator() {
        Pellet.timers.startTimer("nodeIterator");
        Iterator i = this.nodes.values().iterator();
        Pellet.timers.stopTimer("nodeIterator");
        return i;
    }

    public void printTree(Node node, String indent) {
        System.out.println(" " + node.getNameStr() + " " + node.getAtomic());
        indent = String.valueOf(indent) + "  ";
        Iterator allEdges = node.getEdgeMappings().entrySet().iterator();
        while (allEdges.hasNext()) {
            Map.Entry entry = allEdges.next();
            ATerm x = (ATerm)entry.getKey();
            EdgeList edges = (EdgeList)entry.getValue();
            System.out.print(String.valueOf(indent) + edges);
            Node succ = this.getNode(x);
            if (succ != null) {
                this.printTree(succ, indent);
                continue;
            }
            System.out.println("Literal");
        }
    }

    private void validate() {
    }

    public String toString() {
        String str;
        int maxLength = 10000;
        String nodeStr = "" + this.nodes;
        String litStr = "" + this.literals;
        if (nodeStr.length() > maxLength) {
            nodeStr = String.valueOf(nodeStr.substring(0, maxLength)) + "...";
        }
        if (litStr.length() > maxLength) {
            litStr = String.valueOf(litStr.substring(0, maxLength)) + "...";
        }
        if ((str = "[ABox size=" + this.nodeCount + " nodes=" + nodeStr + ";\nliterals=" + litStr + ";" + "sames = {" + this.getSames() + "}; differents = {" + this.getDifferents() + "}]\n").length() > 2 * maxLength) {
            str = String.valueOf(str.substring(0, 2 * maxLength)) + "...";
        }
        return str;
    }
}

