/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.iface.util.RadioButtonBox;
import ix.iface.util.SimpleToolFrame;
import ix.itest.DestinationChoice;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Strings;
import ix.util.xml.XML;
import ix.util.xml.XMLTranslator;
import ix.util.xml.XMLTreeEditFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdom.Document;

class XMLTreeSendFrame
extends SimpleToolFrame
implements ActionListener {
    DestinationChoice destinationChoice;
    RadioButtonBox formSelector = this.makeFormControl();
    XMLTreeEditFrame frame;

    XMLTreeSendFrame(XMLTreeEditFrame xMLTreeEditFrame, String string) {
        super(string);
        this.frame = xMLTreeEditFrame;
        this.setup();
    }

    void setEditFrame(XMLTreeEditFrame xMLTreeEditFrame) {
        this.frame = xMLTreeEditFrame;
    }

    protected void setup() {
        super.setup();
        this.setActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.setContentPane(jPanel);
        jPanel.setBorder(BorderFactory.createTitledBorder("Send To"));
        this.contentPane = jPanel;
        this.destinationChoice = new DestinationChoice(this.frame.getAgent(), new String[]{"me"});
        this.contentPane.add((Component)this.destinationChoice, "North");
        this.contentPane.add((Component)this.formSelector, "Center");
        JPanel jPanel2 = this.makeButtonPanel(new String[]{"Send", "Cancel"});
        this.contentPane.add((Component)jPanel2, "South");
        this.pack();
    }

    protected RadioButtonBox makeFormControl() {
        RadioButtonBox radioButtonBox = RadioButtonBox.createHorizontalBox();
        radioButtonBox.add(Box.createHorizontalGlue());
        radioButtonBox.add(new JRadioButton("Send XML"));
        radioButtonBox.add(new JRadioButton("Send Object", true));
        radioButtonBox.add(Box.createHorizontalGlue());
        return radioButtonBox;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            this.setVisible(false);
        } else if (string.equals("Send")) {
            this.Send();
            this.setVisible(false);
        } else {
            throw new ConsistencyException("Nothing to do for " + string);
        }
    }

    protected void Send() {
        String string = this.destinationChoice.getSelectedString();
        String string2 = this.formSelector.getSelection();
        if (string2.equals("Send XML")) {
            this.sendXML(string, this.frame.getDocument());
        } else if (string2.equals("Send Object")) {
            this.sendObject(string, this.frame.getObject());
        } else {
            throw new ConsistencyException("Invalid form for send: " + Strings.quote(string2));
        }
    }

    protected void sendObject(String string, Object object) {
        if (string.equals("me")) {
            this.frame.getAgent().handleInput(new IPC.BasicInputMessage(object));
        } else {
            IPC.sendObject(string, object);
        }
    }

    protected void sendXML(final String string, Document document) {
        if (string.equals("me")) {
            this.sendObject(string, XML.objectFromDocument(document));
            return;
        }
        Debug.expect(!(XML.defaultTranslator() instanceof SubversiveTranslator));
        final Object object = new Object();
        SubversiveTranslator subversiveTranslator = new SubversiveTranslator();
        subversiveTranslator.setTranslation(object, document);
        XML.withDefaultTranslator(subversiveTranslator, new Runnable(){

            public void run() {
                IPC.sendObject(string, object);
            }
        });
    }

    class SubversiveTranslator
    extends XMLTranslator {
        Map subversions;

        SubversiveTranslator() {
            this(XML.defaultTranslator());
        }

        SubversiveTranslator(XMLTranslator xMLTranslator) {
            super(xMLTranslator.getClassSyntax());
            this.subversions = new HashMap();
            this.omitImplAttributes = xMLTranslator.omitImplAttributes;
        }

        public String objectToXMLString(Object object) {
            Document document = (Document)this.subversions.get(object);
            return this.documentToXMLString(document != null ? document : this.objectToDocument(object));
        }

        void setTranslation(Object object, Document document) {
            this.subversions.put(object, document);
        }
    }
}

