/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.icore.IXAgent;
import ix.iface.util.ToolController;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.xml.XML;
import ix.util.xml.XMLTreeEditFrame;
import javax.swing.UIManager;
import org.jdom.Document;

public class XMLTreeEditor
extends IXAgent {
    protected XMLTreeEditFrame frame;
    protected MessageFrame messageFrame;

    public XMLTreeEditor() {
        this.displayName = "I-X XML Tree Editor";
        UIManager.put("Tree.expandedIcon", Util.resourceImageIcon("ix-symbol-fold.gif"));
        UIManager.put("Tree.collapsedIcon", Util.resourceImageIcon("ix-symbol-unfold.gif"));
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("XML Tree Editor");
        new XMLTreeEditor().mainStartup(stringArray);
    }

    protected void processCommandLineArguments() {
        super.processCommandLineArguments();
    }

    public void startup() {
        Util.swingAndWait(new Runnable(){

            public void run() {
                XMLTreeEditor.this.frame = new XMLTreeEditFrame(XMLTreeEditor.this, XMLTreeEditor.this.displayName);
                XMLTreeEditor.this.frame.setVisible(true);
                String string = Parameters.getParameter("document");
                if (string != null) {
                    Document document = XML.readDocument(string);
                    XMLTreeEditor.this.frame.editDocument(document);
                }
            }
        });
    }

    public void handleInput(IPC.InputMessage inputMessage) {
        if (this.messageFrame == null) {
            this.messageFrame = new MessageFrame(this);
        }
        this.messageFrame.addMessage(inputMessage);
        this.messageFrame.setVisible(true);
    }

    public void addTool(ToolController toolController) {
        this.frame.addTool(toolController);
    }

    protected class MessageFrame
    extends XMLTreeEditFrame {
        MessageFrame(IXAgent iXAgent) {
            super(iXAgent, XMLTreeEditor.this.displayName + " Messages");
            this.editDocument(XML.parseXML("<messages-received />"));
            this.pack();
            this.editPanel.hideTemplates();
        }

        void addMessage(IPC.InputMessage inputMessage) {
            Object object = inputMessage.getContents();
            this.editPanel.addRootChild(XML.objectToDocument(object));
        }
    }
}

