/*
 * Decompiled with CFR 0.152.
 */
package ix.util.reflect;

import ix.util.ConsistencyException;
import ix.util.EnumeratedValue;
import ix.util.SemiPrimitive;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.ClassVisitor;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.FieldMap;
import ix.util.reflect.FieldVisitor;
import ix.util.reflect.ObjectMapper;
import ix.util.reflect.ObjectVisitor;
import ix.util.xml.LiteralDocument;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassDescr {
    protected ClassSyntax syntax;
    public final Class theClass;
    protected ClassDescr eltType = null;
    protected ClassDescr keyType = null;
    protected ClassDescr valType = null;
    protected int type;
    protected FieldMap fields;
    protected String externalName;
    protected String upperName;
    protected static final int INTERFACE = 0;
    protected static final int PRIMITIVE = 1;
    protected static final int LIST = 2;
    protected static final int SET = 3;
    protected static final int MAP = 4;
    protected static final int STRUCT = 5;
    protected static final int XML = 6;
    protected static final String[] typeName = new String[]{"INTERFACE", "PRIMITIVE", "LIST", "SET", "MAP", "STRUCT", "XML"};

    ClassDescr(ClassSyntax classSyntax, Class clazz) {
        this.syntax = classSyntax;
        this.theClass = clazz;
        this.init(clazz);
    }

    ClassDescr(ClassSyntax classSyntax, Class clazz, Class clazz2) {
        this.syntax = classSyntax;
        this.theClass = clazz;
        this.eltType = this.syntax.getClassDescr(clazz2);
        this.init(clazz);
    }

    ClassDescr(ClassSyntax classSyntax, Class clazz, Class clazz2, Class clazz3) {
        this.syntax = classSyntax;
        this.theClass = clazz;
        this.keyType = this.syntax.getClassDescr(clazz2);
        this.valType = this.syntax.getClassDescr(clazz3);
        this.init(clazz);
    }

    protected void init(Class clazz) {
        this.type = this.determineType(clazz);
        this.externalName = this.syntax.externalNameForClass(clazz);
        this.upperName = this.syntax.upperNameForClass(clazz);
    }

    public Class getDescribedClass() {
        return this.theClass;
    }

    public ClassDescr getEltType() {
        return this.eltType;
    }

    public ClassDescr getKeyType() {
        return this.keyType;
    }

    public ClassDescr getValType() {
        return this.valType;
    }

    Class getSuperclass() {
        return this.theClass.getSuperclass();
    }

    protected int determineType(Class clazz) {
        if (this.isPrimitive(clazz)) {
            return 1;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return 3;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            throw new ConsistencyException("Class of unknown collection type", clazz);
        }
        if (clazz.isInterface()) {
            return 0;
        }
        if (LiteralDocument.class.isAssignableFrom(clazz)) {
            return 6;
        }
        return 5;
    }

    public boolean isInterface() {
        return this.type == 0 || this.theClass.isInterface();
    }

    public boolean isPrimitive() {
        return this.type == 1;
    }

    protected boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive() || clazz == String.class || Number.class.isAssignableFrom(clazz) || SemiPrimitive.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || this.syntax.getStringer(clazz) != null;
    }

    public boolean isAbstract() {
        int n = this.theClass.getModifiers();
        return Modifier.isAbstract(n);
    }

    public boolean isEnumeration() {
        return EnumeratedValue.class.isAssignableFrom(this.theClass);
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.theClass);
    }

    public boolean isList() {
        return this.type == 2;
    }

    public boolean isTypedList() {
        return this.type == 2 && this.eltType != null;
    }

    public boolean isSet() {
        return this.type == 3;
    }

    public boolean isMap() {
        return this.type == 4;
    }

    public boolean isStruct() {
        return this.type == 5;
    }

    public boolean isXML() {
        return this.type == 6;
    }

    public void visitClass(ClassVisitor classVisitor) {
        switch (this.type) {
            case 0: {
                classVisitor.visitInterface(this);
                break;
            }
            case 1: {
                classVisitor.visitPrimitive(this);
                break;
            }
            case 2: {
                classVisitor.visitList(this, this.eltType);
                break;
            }
            case 3: {
                classVisitor.visitSet(this, this.eltType);
                break;
            }
            case 4: {
                classVisitor.visitMap(this, this.keyType, this.valType);
                break;
            }
            case 5: {
                classVisitor.visitStruct(this);
                break;
            }
            case 6: {
                classVisitor.visitXML(this);
                break;
            }
            default: {
                throw new ConsistencyException("Unknown type for class " + this.theClass + this.type);
            }
        }
    }

    public void visitObject(Object object, ObjectVisitor objectVisitor) {
        if (!this.theClass.isInstance(object)) {
            throw new IllegalArgumentException(object + " is not an instance of " + this);
        }
        switch (this.type) {
            case 0: {
                throw new ConsistencyException("Instance class appears to be interface " + this);
            }
            case 1: {
                objectVisitor.visitPrimitive(object, this);
                break;
            }
            case 2: {
                objectVisitor.visitList((List)object, this);
                break;
            }
            case 3: {
                objectVisitor.visitSet((Set)object, this);
                break;
            }
            case 4: {
                objectVisitor.visitMap((Map)object, this);
                break;
            }
            case 5: {
                objectVisitor.visitStruct(object, this);
                break;
            }
            case 6: {
                objectVisitor.visitXML((LiteralDocument)object, this);
                break;
            }
            default: {
                throw new ConsistencyException("Unknown type for class " + this.theClass + this.type);
            }
        }
    }

    public Object mapObject(Object object, ObjectMapper objectMapper) {
        if (!this.theClass.isInstance(object)) {
            throw new IllegalArgumentException(object + " is not an instance of " + this);
        }
        switch (this.type) {
            case 0: {
                throw new ConsistencyException("Instance class appears to be interface " + this);
            }
            case 1: {
                return objectMapper.mapPrimitive(object, this);
            }
            case 2: {
                return objectMapper.mapList((List)object, this);
            }
            case 3: {
                return objectMapper.mapSet((Set)object, this);
            }
            case 4: {
                return objectMapper.mapMap((Map)object, this);
            }
            case 5: {
                return objectMapper.mapStruct(object, this);
            }
            case 6: {
                return objectMapper.mapXML((LiteralDocument)object, this);
            }
        }
        throw new ConsistencyException("Unknown type for class " + this.theClass + this.type);
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getUpperName() {
        return this.upperName;
    }

    public List getFieldDescrs() {
        this.ensureFields();
        return this.fields.getFields();
    }

    protected void ensureFields() {
        if (this.fields == null) {
            this.fields = this.syntax.makeFieldDescrs(this.theClass);
        }
    }

    public FieldDescr fieldForName(String string) {
        this.ensureFields();
        return this.fields.fieldForName(string);
    }

    public FieldDescr fieldForExternalName(String string) {
        this.ensureFields();
        return this.fields.fieldForExternalName(string);
    }

    public void visitFields(FieldVisitor fieldVisitor) {
        for (FieldDescr fieldDescr : this.getFieldDescrs()) {
            fieldVisitor.visitField(this, fieldDescr);
        }
    }

    public String description() {
        if (this.isList()) {
            if (this.eltType == null) {
                return "list";
            }
            return "list of " + this.eltType.getExternalName();
        }
        if (this.isSet()) {
            if (this.eltType == null) {
                return "set";
            }
            return "set of " + this.eltType.getExternalName();
        }
        if (this.isMap()) {
            return "map";
        }
        return this.externalName;
    }

    public String toString() {
        String string = this.description();
        if (this.isCollection() || this.isMap()) {
            string = this.externalName + ", a " + string;
        }
        return "ClassDescr[" + typeName[this.type] + ": " + string + "]";
    }
}

