/*
 * Decompiled with CFR 0.152.
 */
package ix.util.rdf;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import ix.test.xml.MapEntry;
import ix.test.xml.Mapping;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.EnumeratedValue;
import ix.util.Function1;
import ix.util.Parameters;
import ix.util.Proc;
import ix.util.rdf.Morphology;
import ix.util.rdf.Rdf;
import ix.util.rdf.Vocabulary;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.InheritanceTree;
import ix.util.xml.XML;
import ix.util.xml.XMLSyntax;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public class OwlSyntax
extends XMLSyntax {
    String base = "http://www.aiai.ed.ac.uk/~jeff/ix/3.x/owl/";
    String hash = this.base + "#";
    Vocabulary xsd = new Vocabulary("http://www.w3.org/2001/XMLSchema");
    Morphology morph = new Morphology();
    Class rootClass;
    OntModel om;
    RDFWriter writer;
    private DatatypeProperty _hasValueP;

    public OwlSyntax(Class clazz) {
        this.rootClass = clazz;
        this.classSyntax = Rdf.classSyntax();
    }

    public OntModel getOntModel() {
        Debug.expect(this.om == null, "model already built in", this);
        this.om = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);
        this.om.setNsPrefix("ix", this.hash);
        Ontology ontology = this.om.createOntology(this.base);
        ontology.addProperty((Property)this.om.createAnnotationProperty(DC.creator.getURI()), "I-X");
        this.writer = this.makeWriter();
        this.buildOntModel();
        return this.om;
    }

    RDFWriter makeWriter() {
        RDFWriter rDFWriter = this.om.getWriter("RDF/XML-ABBREV");
        rDFWriter.setProperty("tab", (Object)"1");
        rDFWriter.setProperty("prettyTypes", (Object)new Resource[]{OWL.Ontology, OWL.ObjectProperty, OWL.DatatypeProperty, OWL.FunctionalProperty, OWL.Class, OWL.AllDifferent});
        return rDFWriter;
    }

    void write(OutputStream outputStream) {
        this.writer.write((Model)this.om, outputStream, this.base);
    }

    void buildOntModel() {
        List list = this.relevantClasses(this.rootClass);
        this.inheritance = new InheritanceTree(list);
        this.ontClass(Object.class);
        this.addClass(MapEntry.class);
        this.addClass(Mapping.class);
        for (Class clazz : list) {
            this.addClass(clazz);
        }
    }

    OntClass ontClass(Class clazz) {
        return this.ontClass(this.getClassDescr(clazz));
    }

    OntClass ontClass(ClassDescr classDescr) {
        String string = this.hash + classDescr.getExternalName();
        OntClass ontClass = this.om.getOntClass(string);
        if (ontClass == null) {
            ontClass = this.om.createClass(string);
        }
        return ontClass;
    }

    List ontClassList(List list) {
        return (List)Collect.map(list, new Function1(){

            public Object funcall(Object object) {
                return OwlSyntax.this.ontClass((Class)object);
            }
        });
    }

    void addClass(Class clazz) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        if (classDescr.isStruct()) {
            if (classDescr.isAbstract()) {
                this.addAbstractStructClass(classDescr);
            } else {
                this.addStructClass(classDescr);
            }
        } else if (classDescr.isEnumeration()) {
            this.addEnumerationClass(classDescr);
        } else if (classDescr.isPrimitive()) {
            this.addPrimitiveClass(classDescr);
        } else {
            OntClass ontClass = this.ontClass(classDescr);
            ontClass.addComment("Definition not yet available.", "en");
        }
        this.ontClass(classDescr).addLabel(classDescr.getExternalName(), null);
    }

    void addAbstractStructClass(ClassDescr classDescr) {
        OntClass ontClass = this.ontClass(classDescr);
        ontClass.addComment("Abstract", null);
        List list = this.inheritance.getSubclasses(classDescr.theClass);
        if (list != null) {
            List list2 = this.ontClassList(list);
            RDFList rDFList = this.om.createList(list2.iterator());
            UnionClass unionClass = this.om.createUnionClass(null, rDFList);
            ontClass.addProperty(OWL.equivalentClass, (RDFNode)unionClass);
            Collect.walkTriangle(list2, new Proc(){

                public void call(Object object, Object object2) {
                    OntClass ontClass = (OntClass)object;
                    OntClass ontClass2 = (OntClass)object2;
                    ontClass.addProperty(OWL.disjointWith, (RDFNode)ontClass2);
                }
            });
        }
    }

    void addStructClass(ClassDescr classDescr) {
        OntClass ontClass = this.ontClass(classDescr);
        List list = classDescr.getFieldDescrs();
        for (FieldDescr fieldDescr : list) {
            this.addField(ontClass, fieldDescr);
        }
        Class clazz = this.inheritance.getSuperclass(classDescr.theClass);
        if (clazz != null) {
            ontClass.addSuperClass((Resource)this.ontClass(clazz));
        }
    }

    void addField(OntClass ontClass, FieldDescr fieldDescr) {
        ClassDescr classDescr = fieldDescr.getTypeDescr();
        String string = fieldDescr.getExternalName();
        this.addField(ontClass, string, classDescr);
    }

    void addField(OntClass ontClass, String string, ClassDescr classDescr) {
        if (classDescr.isTypedList()) {
            String string2 = this.morph.singular(string);
            String string3 = this.hash + "has-" + string2;
            ObjectProperty objectProperty = this.om.createObjectProperty(string3);
            ClassDescr classDescr2 = classDescr.getEltType();
            AllValuesFromRestriction allValuesFromRestriction = this.om.createAllValuesFromRestriction(null, (Property)objectProperty, this.fieldClass(classDescr2));
            ontClass.addSuperClass((Resource)allValuesFromRestriction);
        } else if (classDescr.isMap()) {
            this.addField(ontClass, string, this.getClassDescr(Mapping.class));
        } else {
            String string4 = string;
            String string5 = this.hash + "has-" + string4;
            ObjectProperty objectProperty = this.om.createObjectProperty(string5);
            AllValuesFromRestriction allValuesFromRestriction = this.om.createAllValuesFromRestriction(null, (Property)objectProperty, this.fieldClass(classDescr));
            ontClass.addSuperClass((Resource)allValuesFromRestriction);
            MaxCardinalityRestriction maxCardinalityRestriction = this.om.createMaxCardinalityRestriction(null, (Property)objectProperty, 1);
            ontClass.addSuperClass((Resource)maxCardinalityRestriction);
        }
    }

    Resource fieldClass(ClassDescr classDescr) {
        if (classDescr.isList()) {
            ClassDescr classDescr2 = classDescr.getEltType();
            if (classDescr2 == null) {
                return RDF.List;
            }
            return this.ontClass(classDescr2);
        }
        return this.ontClass(classDescr);
    }

    OntClass typedListOntClass(Class clazz) {
        ClassDescr classDescr = this.getClassDescr(clazz);
        String string = "list-of-" + classDescr.getExternalName();
        return this.typedListOntClass(string, clazz);
    }

    OntClass typedListOntClass(String string, Class clazz) {
        String string2 = this.hash + string;
        OntClass ontClass = this.om.getOntClass(string2);
        if (ontClass != null) {
            return ontClass;
        }
        ontClass = this.om.createClass(string2);
        ontClass.addSuperClass(RDF.List);
        OntClass ontClass2 = this.ontClass(clazz);
        ontClass.addSuperClass((Resource)this.om.createAllValuesFromRestriction(null, RDF.first, (Resource)ontClass2));
        ontClass.addSuperClass((Resource)this.om.createAllValuesFromRestriction(null, RDF.rest, (Resource)ontClass));
        return ontClass;
    }

    void addEnumerationClass(final ClassDescr classDescr) {
        final EnumeratedClass enumeratedClass = this.ontClass(classDescr).convertToEnumeratedClass(this.om.createList());
        Iterator iterator = this.getEnumerationValues(classDescr.theClass).iterator();
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                Debug.expect(object instanceof EnumeratedValue);
                String string = object.toString();
                String string2 = OwlSyntax.this.base + classDescr.getExternalName();
                return OwlSyntax.this.om.createIndividual(string2 + "#" + object, (Resource)enumeratedClass);
            }
        };
        Map1Iterator map1Iterator = new Map1Iterator(map1, iterator);
        RDFList rDFList = this.om.createList((Iterator)map1Iterator);
        enumeratedClass.setOneOf(rDFList);
        this.om.createAllDifferent(this.om.createList((Iterator)rDFList.iterator()));
    }

    void addPrimitiveClass(ClassDescr classDescr) {
        OntClass ontClass = this.ontClass(classDescr);
        String string = this.classSyntax.xmlSchemaDatatype(classDescr.theClass);
        AllValuesFromRestriction allValuesFromRestriction = this.om.createAllValuesFromRestriction(null, (Property)this.hasValueProp(), this.xsd.resource(string));
        ontClass.addSuperClass((Resource)allValuesFromRestriction);
    }

    DatatypeProperty hasValueProp() {
        if (this._hasValueP == null) {
            this._hasValueP = this.om.createDatatypeProperty(this.hash + "has-litvalue", true);
        }
        return this._hasValueP;
    }

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        Class clazz = Rdf.classSyntax().classForExternalName(Parameters.getParameter("root", "domain"));
        OwlSyntax owlSyntax = new OwlSyntax(clazz);
        OntModel ontModel = owlSyntax.getOntModel();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        owlSyntax.write(byteArrayOutputStream);
        XML.printXMLWithWhitespace(((Object)byteArrayOutputStream).toString(), 2);
    }
}

