/*
 * Decompiled with CFR 0.152.
 */
package ix.util.owls;

import ix.icore.Activity;
import ix.icore.plan.Input;
import ix.icore.plan.Output;
import ix.icore.plan.ProcessParameter;
import ix.ip2.AgendaItem;
import ix.iplan.ServiceSymbols;
import ix.util.Gensym;
import ix.util.StableHashMap;
import ix.util.lisp.Symbol;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProcessDataFlow
implements ServiceSymbols {
    Gensym.Generator gensym = new Gensym.Generator();
    Map objectToParametersMap = new StableHashMap();
    List sameValueLists = new LinkedList();

    public ProcessDataFlow(List list) {
        this.recordSameValueLists(list);
    }

    public List getSameValueLists() {
        return this.sameValueLists;
    }

    void recordSameValueLists(List list) {
        for (AgendaItem agendaItem : list) {
            Activity activity = (Activity)agendaItem.getAbout();
            List list2 = (List)activity.getAnnotation(S_INPUTS);
            List list3 = (List)activity.getAnnotation(S_OUTPUTS);
            if (list2 != null) {
                this.recordParameters(activity, list2);
            }
            if (list3 == null) continue;
            this.recordParameters(activity, list3);
        }
    }

    void recordParameters(Activity activity, List list) {
        for (ProcessParameter processParameter : list) {
            Symbol symbol = processParameter.getValue();
            LinkedList<ProcessParameter> linkedList = (LinkedList<ProcessParameter>)this.objectToParametersMap.get(symbol);
            if (linkedList == null) {
                linkedList = new LinkedList<ProcessParameter>();
                this.sameValueLists.add(linkedList);
                this.objectToParametersMap.put(symbol, linkedList);
            }
            linkedList.add(processParameter.attachTo(activity));
        }
    }

    public List getInitialInputs() {
        LinkedList<Input> linkedList = new LinkedList<Input>();
        for (LinkedList linkedList2 : this.sameValueLists) {
            ProcessParameter processParameter = (ProcessParameter)linkedList2.getFirst();
            if (!processParameter.isInput()) continue;
            Symbol symbol = this.gensym.nextSymbol("?input_" + processParameter.getType());
            Input input = new Input(symbol, processParameter.getType(), processParameter.getValue());
            linkedList.add(input);
        }
        return linkedList;
    }

    public List getFinalOutputs() {
        LinkedList<Output> linkedList = new LinkedList<Output>();
        for (LinkedList linkedList2 : this.sameValueLists) {
            ProcessParameter processParameter = (ProcessParameter)linkedList2.getLast();
            if (!processParameter.isOutput()) continue;
            Symbol symbol = this.gensym.nextSymbol("?output_" + processParameter.getType());
            Output output = new Output(symbol, processParameter.getType(), processParameter.getValue());
            linkedList.add(output);
        }
        return linkedList;
    }

    public List makeFullSameList(List list, List list2) {
        LinkedList<ProcessParameter> linkedList;
        List list3;
        Symbol symbol;
        StableHashMap stableHashMap = new StableHashMap(this.objectToParametersMap);
        for (ProcessParameter processParameter : list) {
            symbol = processParameter.getValue();
            list3 = (List)stableHashMap.get(symbol);
            linkedList = new LinkedList<ProcessParameter>(list3);
            linkedList.addFirst(processParameter);
            stableHashMap.put(symbol, linkedList);
        }
        for (ProcessParameter processParameter : list2) {
            symbol = processParameter.getValue();
            list3 = (List)stableHashMap.get(symbol);
            linkedList = new LinkedList(list3);
            linkedList.addLast(processParameter);
            stableHashMap.put(symbol, linkedList);
        }
        return new LinkedList(stableHashMap.values());
    }
}

