/*
 * Decompiled with CFR 0.152.
 */
package ix.util.ipc;

import ix.util.Debug;
import ix.util.IPC;
import ix.util.ipc.ParameterizedCommStrategy;
import java.util.Arrays;

public class WrapperStrategy
implements ParameterizedCommStrategy {
    IPC.CommunicationStrategy innerStrategy;

    public WrapperStrategy() {
    }

    public WrapperStrategy(IPC.CommunicationStrategy communicationStrategy) {
        this.innerStrategy = communicationStrategy;
    }

    public IPC.CommunicationStrategy apply(String[] stringArray) {
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("Wrapper strategy expected 1 parameter but received " + stringArray.length + ": " + Arrays.asList(stringArray));
        }
        this.innerStrategy = IPC.makeCommunicationStrategy(stringArray[0]);
        return this;
    }

    public void sendObject(Object object, Object object2) {
        Debug.expect(this.innerStrategy != null, "No inner strategy has been given to ", this);
        this.innerStrategy.sendObject(object, object2);
    }

    public void setupServer(Object object, IPC.MessageListener messageListener) {
        Debug.expect(this.innerStrategy != null, "No inner strategy has been given to ", this);
        this.innerStrategy.setupServer(object, messageListener);
    }
}

