/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Activity;
import ix.icore.Status;
import ix.icore.domain.Domain;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.Refinement;
import ix.icore.plan.Plan;
import ix.icore.process.PNodeEnd;
import ix.iface.util.KeyValueTable;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.iplan.IPlanOptionManager;
import ix.test.PlainIp2;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Parameters;
import ix.util.Predicate1;
import ix.util.TopologicalSorter;
import ix.util.Util;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.match.MatchEnv;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SimpleRSim {
    protected Ip2 ip2;
    protected Ip2ModelManager modelManager;
    protected boolean trace = true;
    protected PrintStream traceOut = Debug.out;

    public SimpleRSim(Ip2 ip2) {
        this.ip2 = ip2;
        this.modelManager = (Ip2ModelManager)ip2.getModelManager();
    }

    public SimpleRSim(Plan plan, Domain domain) {
        this.ip2 = IPlanOptionManager.ModelHolder.newInstance();
        this.modelManager = (Ip2ModelManager)this.ip2.getModelManager();
        this.ip2.loadDomain(domain);
        this.ip2.loadPlan(plan);
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setTraceOutput(PrintStream printStream) {
        this.traceOut = printStream;
    }

    public void simulateExecution(List list) {
        for (LList lList : list) {
            Activity activity = new Activity(lList);
            try {
                this.simulateExecution(activity);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
            }
        }
    }

    protected void simulateExecution(Activity activity) {
        this.traceln("Executing", activity);
        boolean bl = false;
        for (Refinement refinement : this.ip2.getDomain().getRefinements()) {
            List list = this.modelManager.satisfyRefinementPreconditions(activity, refinement);
            boolean bl2 = bl = bl || list != null;
            if (list == null || list.isEmpty()) continue;
            MatchEnv matchEnv = (MatchEnv)list.get(0);
            this.traceln("Using env", matchEnv);
            refinement = this.modelManager.fillInRefinement(refinement, matchEnv);
            ListOfConstraint listOfConstraint = refinement.getEffectConstraints();
            if (!listOfConstraint.isEmpty()) {
                this.traceln("Effects:", listOfConstraint);
            }
            this.modelManager.executeRefinementEffects(refinement, matchEnv);
            return;
        }
        if (!bl) {
            this.traceln("No refinement matched");
        } else {
            this.traceln("No refinement had satisfiable preconditions");
        }
    }

    public void describeFinalWorldState() {
        this.describeFinalWorldState(this.traceOut);
    }

    public void describeFinalWorldState(PrintStream printStream) {
        TreeMap treeMap = new TreeMap(new KeyValueTable.PatternObjectComparator());
        treeMap.putAll(this.modelManager.getWorldStateMap());
        this.describeState(printStream, "Final world state", treeMap);
    }

    protected void describeState(PrintStream printStream, String string, Map map) {
        if (map.isEmpty()) {
            printStream.println(string + " is empty");
        } else {
            printStream.println(string + ":");
            for (Map.Entry entry : map.entrySet()) {
                printStream.println("   " + entry.getKey() + " = " + entry.getValue());
            }
        }
    }

    protected List maybeShuffle(List list) {
        return list;
    }

    protected List removeIf(final Status status, List list) {
        return (List)Collect.filter(list, new Predicate1(){

            public boolean trueOf(Object object) {
                return ((PNodeEnd)object).getStatus() != status;
            }
        });
    }

    protected List keepIf(final Status status, List list) {
        return (List)Collect.filter(list, new Predicate1(){

            public boolean trueOf(Object object) {
                return ((PNodeEnd)object).getStatus() == status;
            }
        });
    }

    protected void traceln(String string) {
        if (this.trace) {
            this.traceOut.println(string);
        }
    }

    protected void traceln(String string, Object object) {
        if (this.trace) {
            this.traceOut.println(string + " " + object);
        }
    }

    public static void main(String[] stringArray) {
        Debug.off();
        PlainIp2 plainIp2 = new PlainIp2();
        plainIp2.mainStartup(stringArray);
        SimpleRSim simpleRSim = new SimpleRSim(plainIp2);
        simpleRSim.processCommandLineArguments();
        while (true) {
            SimpleRSim.getPatternsAndRun(simpleRSim);
        }
    }

    static void getPatternsAndRun(SimpleRSim simpleRSim) {
        String string;
        System.out.println("\nEnter patterns one per line ending with a blank line.");
        LinkedList<LList> linkedList = new LinkedList<LList>();
        while (!(string = Util.askLine(">").trim()).equals("")) {
            linkedList.add(Lisp.elementsFromString(string));
        }
        simpleRSim.traceln("");
        simpleRSim.traceln("- - - - - Beginning simulation - - - - -");
        simpleRSim.traceln("");
        simpleRSim.simulateExecution(linkedList);
        simpleRSim.traceln("");
        simpleRSim.traceln("");
        if (simpleRSim.trace) {
            simpleRSim.describeFinalWorldState();
        }
        simpleRSim.traceln("");
        simpleRSim.traceln("- - - - - Simulation ended - - - - -");
        simpleRSim.traceln("");
    }

    protected void processCommandLineArguments() {
        this.setTrace(Parameters.getBoolean("trace", true));
    }

    protected class ExecOrderSorter
    extends TopologicalSorter {
        protected ExecOrderSorter() {
        }

        protected Collection getChildren(Object object) {
            return SimpleRSim.this.maybeShuffle(((PNodeEnd)object).getSuccessors());
        }
    }

    class RecordIfUnbound
    implements Function1 {
        private Set unbound = new TreeSet();

        RecordIfUnbound() {
        }

        public Object funcall(Object object) {
            this.unbound.add(Util.mustBe(ItemVar.class, object));
            return object;
        }

        Set getUnboundVars() {
            return this.unbound;
        }
    }
}

