/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.util.Debug;
import ix.util.Parameters;
import ix.util.xml.XML;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class ReadURLTest {
    public static void main(String[] stringArray) throws IOException {
        URL uRL;
        Object object;
        Parameters.processCommandLineArguments(stringArray);
        if (Parameters.haveParameter("name")) {
            object = Parameters.getParameter("name");
            uRL = XML.toURL((String)object);
            if (uRL == null) {
                throw new IllegalArgumentException("Don't know how to read " + (String)object);
            }
        } else if (Parameters.haveParameter("file")) {
            object = Parameters.getParameter("file");
            uRL = new File((String)object).toURL();
        } else if (Parameters.haveParameter("url")) {
            uRL = new URL(new URL("file:./"), Parameters.getParameter("url"));
        } else {
            System.err.println("Must specify -name=name or -file=name or -url=name");
            return;
        }
        Debug.noteln("Reading from", (Object)uRL);
        object = uRL.openConnection();
        InputStream inputStream = ((URLConnection)object).getInputStream();
        String string = ((URLConnection)object).getContentEncoding();
        if (string == null) {
            ReadURLTest.read(new InputStreamReader(inputStream));
        } else {
            ReadURLTest.read(new InputStreamReader(inputStream, string));
        }
    }

    static URL toURL(String string) throws MalformedURLException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.exists()) {
                return file.toURL();
            }
            return ReadURLTest.class.getClassLoader().getResource(string);
        }
    }

    static void read(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println(string);
        }
    }
}

