/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HttpRequestTest {
    public static void main(String[] stringArray) throws MalformedURLException, ProtocolException, IOException {
        while (true) {
            String string;
            URL uRL = new URL(Util.askLine("URL:"));
            System.out.println("Type some XML followed by a blank line:");
            LinkedList<String> linkedList = new LinkedList<String>();
            while (!(string = Util.readLine(System.in)).equals("")) {
                linkedList.add(string);
            }
            string = Strings.joinLines(linkedList);
            byte[] byArray = string.getBytes("UTF-8");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Length", "" + byArray.length);
            httpURLConnection.setRequestProperty("Content-Type", "application/xml; charset=UTF-8");
            httpURLConnection.setRequestProperty("Host", uRL.getHost() + ":" + uRL.getPort());
            httpURLConnection.connect();
            OutputStream outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            System.out.println("");
            System.out.println("Response:");
            System.out.println(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
            System.out.println("");
            System.out.println("Reply Headers:");
            for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                System.out.println(entry.getKey() + ": " + entry.getValue());
            }
            InputStream inputStream = httpURLConnection.getInputStream();
            String object2 = httpURLConnection.getContentEncoding();
            InputStreamReader inputStreamReader = object2 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, object2);
            int n = httpURLConnection.getContentLength();
            String string2 = "";
            if (n < 0) {
                Debug.noteln("No contet length; will read everything.");
                string2 = HttpRequestTest.readAllLines(inputStreamReader);
                ((Reader)inputStreamReader).close();
            } else {
                string2 = HttpRequestTest.readText(inputStreamReader, n);
                ((Reader)inputStreamReader).close();
                if (string2 == null) {
                    throw new RuntimeException("EOF");
                }
            }
            System.out.println("");
            System.out.println("Reply:");
            System.out.println(string2);
        }
    }

    static String readText(Reader reader, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            int n4 = reader.read(cArray, n3, n2);
            if (n4 == -1) {
                return null;
            }
            n2 -= n4;
            n3 += n4;
        }
        return new String(cArray);
    }

    static String readAllLines(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            linkedList.add(string);
        }
        return Strings.joinLines(linkedList);
    }
}

