/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.Annotations;
import ix.icore.IXObject;
import ix.icore.domain.event.DomainEvent;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.ui.IFormModel;
import ix.iface.ui.IFormPanel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.IXLabelRenderer;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.table.IXTreeTable;
import ix.iview.AConstructFramePanel;
import ix.iview.ConstructEditing;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.event.CurrentActionListener;
import ix.iview.table.ActionTreeTableModel;
import ix.iview.util.ActionListRenderer;
import ix.util.Debug;
import java.awt.Dimension;
import java.util.EventListener;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GlobalFormPanel
extends IFormPanel
implements ConstructEditing,
UIDomainListener,
ListSelectionListener {
    private UIObject uiConstruct;
    private UIRefinement currentAction;
    private ActionTreeTableModel tableModel;
    public IXTreeTable table;
    private AConstructFramePanel parent;
    HashSet actionListeners = new HashSet();
    private boolean reactingActionChange = false;

    public GlobalFormPanel(AConstructFramePanel aConstructFramePanel) {
        this.parent = aConstructFramePanel;
    }

    public GlobalFormPanel(AConstructFramePanel aConstructFramePanel, IFormModel iFormModel) {
        super(iFormModel);
        this.parent = aConstructFramePanel;
    }

    protected void setRenderers() {
        ActionListRenderer actionListRenderer = new ActionListRenderer(false);
        this.fieldRenderers.put("refinements", actionListRenderer);
    }

    protected IXEditorPanel makeDisplayBit(String string) {
        if (string.equals("refinements")) {
            String[] stringArray = new String[]{"Add", "Edit", "Delete"};
            this.tableModel = new ActionTreeTableModel(false, this.getUIDomain());
            this.table = new IXTreeTable(this.tableModel);
            this.tableModel.setParentsBold(true);
            this.table.setPreferredScrollableViewportSize(new Dimension(200, 100));
            this.table.getSelectionModel().addListSelectionListener(this);
            return new ListEditorPanel((EventListener)this, this.model.getFieldName(string), true, (JComponent)this.table, stringArray);
        }
        return super.makeDisplayBit(string);
    }

    public void saveFieldData(String string) {
        if (string.equals("annotations")) {
            Debug.noteln("Cannot save annotations yet");
        } else if (!string.equals("refinements") && !string.equals("objectClasses")) {
            super.saveFieldData(string);
        }
    }

    public Object getFieldData(String string) {
        if (string.equals("refinements") || string.equals("objectClasses")) {
            return null;
        }
        return super.getFieldData(string);
    }

    public void setFieldData(String string, Object object) {
        if (string.equals("refinements")) {
            this.updateTable();
        } else if (string.equals("objectClasses")) {
            this.updateList();
        } else {
            super.setFieldData(string, object);
        }
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
    }

    public void refinementRemoved(RefinementEvent refinementEvent) {
    }

    public void constructAdded(DomainEvent domainEvent) {
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        this.updateList();
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
        this.displayModelData();
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.displayModelData();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
        this.displayModelData();
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.getModel().setObject(uIDomainEvent.getDomain());
    }

    public void setSort(boolean bl) {
        this.tableModel.setSort(bl);
    }

    public boolean getSort() {
        return this.tableModel.getSort();
    }

    public void updateTable() {
        this.tableModel.reloadData();
        this.table.setSelectedObject(this.currentAction);
    }

    public void updateList() {
        super.setFieldData("objectClasses", this.getUIDomain().getAllObjectClasses());
    }

    public UIDomain getUIDomain() {
        return this.parent.getUIDomain();
    }

    public void setConstruct(IXObject iXObject) {
        this.setUIConstruct(this.getUIDomain().getUIObject(iXObject));
    }

    public IXObject getConstruct() {
        if (this.uiConstruct == null) {
            return null;
        }
        return this.uiConstruct.getBaseObject();
    }

    public void setUIConstruct(UIObject uIObject) {
        this.setUIConstructOnly(uIObject);
    }

    public void setUIConstructOnly(UIObject uIObject) {
        UIObject uIObject2 = this.uiConstruct;
        this.uiConstruct = uIObject;
        this.getModel().setObject(uIObject);
        this.parent.fireConstructChanged(uIObject2, uIObject, this);
    }

    public UIObject getUIConstruct() {
        return this.uiConstruct;
    }

    public void loadFromObject() {
        this.displayModelData();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        UIRefinement uIRefinement = this.currentAction;
        int n = this.table.getSelectedRow();
        if (n != -1 && n < this.table.getRowCount() && (object = this.tableModel.getRowObject(n)) instanceof UIRefinement) {
            UIRefinement uIRefinement2;
            this.currentAction = uIRefinement2 = (UIRefinement)object;
            this.fireCurrentActionChanged(uIRefinement, uIRefinement2);
        }
    }

    public void addCurrentActionListener(CurrentActionListener currentActionListener) {
        this.actionListeners.add(currentActionListener);
    }

    private void fireCurrentActionChanged(UIRefinement uIRefinement, UIRefinement uIRefinement2) {
        if (this.reactingActionChange) {
            return;
        }
        if (uIRefinement == null && uIRefinement2 == null || uIRefinement != null && uIRefinement.equals(uIRefinement2)) {
            return;
        }
        for (CurrentActionListener currentActionListener : this.actionListeners) {
            currentActionListener.actionChanged(this, uIRefinement, uIRefinement2);
        }
        if (uIRefinement2 == null || uIRefinement2.isEmpty()) {
            this.table.clearSelection();
        }
    }

    public void reactingActionChange(boolean bl) {
        this.reactingActionChange = bl;
    }

    public void setSelectedAction(UIRefinement uIRefinement) {
        this.table.clearSelection();
        this.table.setSelectedObject(uIRefinement);
    }

    private class DescriptionsRenderer
    extends IXLabelRenderer {
        public DescriptionsRenderer(boolean bl) {
            super(bl);
        }

        public void setInfo(Object object) {
            if (object == null) {
                this.setText("");
            } else if (Annotations.class.isInstance(object)) {
                // empty if block
            }
        }
    }
}

