/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXObject;
import ix.icore.Issue;
import ix.icore.domain.End;
import ix.icore.domain.Named;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.SchemaTerms;
import ix.icore.domain.event.DomainEvent;
import ix.iface.domain.SyntaxException;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IFormModel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.IXRenderer;
import ix.iface.ui.JObjectMenu;
import ix.iface.ui.JObjectPopup;
import ix.iface.ui.event.DataChangeListener;
import ix.iface.ui.table.AbstractIXTableModel;
import ix.iface.ui.table.IXTreeTable;
import ix.iface.ui.util.UIUtil;
import ix.iface.util.CatchingActionListener;
import ix.iview.AConstructFramePanel;
import ix.iview.ActionFormModel;
import ix.iview.ActionFormPanel;
import ix.iview.ConditionEffectEditor;
import ix.iview.ConstructEditing;
import ix.iview.ConstructFraming;
import ix.iview.DeclarationEditor;
import ix.iview.DefaultConstraintEditor;
import ix.iview.DomainEditorFrame;
import ix.iview.IDESymbols;
import ix.iview.MiniConstraintPanel;
import ix.iview.ObjectConstraintEditor;
import ix.iview.OrderingEditor;
import ix.iview.PanelSearcher;
import ix.iview.SpecEditor;
import ix.iview.domain.UINodeSpec;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.event.CurrentActionListener;
import ix.iview.igraph.GExpansionEditor;
import ix.iview.table.ActionTreeTableModel;
import ix.iview.table.ShortActionTreeTableModel;
import ix.iview.util.ActionListRenderer;
import ix.iview.util.FullNodeRenderer;
import ix.iview.util.IDEUtil;
import ix.iview.util.IVUtil;
import ix.iview.util.IssueRenderer;
import ix.iview.util.NodeNameRenderer;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActionEditorPanel
extends AConstructFramePanel
implements ConstructFraming,
ActionListener,
DataChangeListener,
UIDomainListener,
CurrentActionListener,
IDESymbols,
SchemaTerms {
    private IXEditorPanel miniConstraintsPanel;
    private IXEditorPanel nodesTextPanel;
    private boolean minimalView = false;
    private IXRenderer fullNodeRenderer = new FullNodeRenderer(false);
    private IXRenderer miniNodeRenderer = new NodeNameRenderer(false);
    private IXRenderer fullIssueRenderer = new IssueRenderer(false);
    private IXRenderer miniIssueRenderer = new IssueRenderer(false);
    private boolean sequence = true;
    public OrderingEditor orderingEditor;
    public ConditionEffectEditor conditionEditor;
    public DefaultConstraintEditor constraintEditor;
    public SpecEditor nodeSpecEditor;
    public SpecEditor issueSpecEditor;
    public DeclarationEditor declarationEditor;
    public ObjectConstraintEditor objectConstraintEditor;
    public PanelSearcher searcher;
    private JSplitPane actionSplit = new JSplitPane(1);
    private JScrollPane scrollTree = new JScrollPane();
    private IXTreeTable actionTree;
    private ActionTreeTableModel treeModel;
    IFormModel formModel;
    ConstructEditing currentPanel;
    private Point mousePoint = new Point(100, 100);
    private Symbol currentView = VIEW_MINIMAL;
    private Symbol formView = VIEW_MINIMAL;
    private boolean graphMode = false;
    GExpansionEditor graphPanel;
    int comprehensiveConstrIndex = 3;
    List comprehensiveFields = new ArrayList();
    List minimalFields = new ArrayList();
    private boolean updatingView = false;
    private UIRefinement uiConstruct;
    boolean updatingTree = false;
    HashSet actionListeners = new HashSet();

    public ActionEditorPanel(DomainEditorFrame domainEditorFrame) {
        super(domainEditorFrame);
        this.currentPanel = (ActionFormPanel)this.formPanel;
        this.setupActionTree();
        this.hasOverview = true;
        this.setSort(DEFAULT_SORT);
        this.formModel = new ActionFormModel(domainEditorFrame);
        String[] stringArray = new String[]{"pattern", "issues", "nodes", "orderings", "conditions", "constraints", "comments"};
        this.comprehensiveFields.addAll(Arrays.asList(stringArray));
        String[] stringArray2 = new String[]{"pattern", "issues", "nodes", "miniConstraints", "comments"};
        this.minimalFields.addAll(Arrays.asList(stringArray2));
        this.enableComprehensive();
        String[] stringArray3 = new String[]{"name"};
        this.formModel.setNameFields(stringArray3);
        this.formPanel.setModel(this.formModel);
        this.formPanel.addFormActionListener(this);
        this.makeTreePopup(new CatchingActionListener(this.parent));
    }

    public void setupPanelProperties(Symbol symbol, Symbol symbol2) {
        this.setConstraintsView(symbol2);
        this.setCurrentView(symbol);
    }

    public ActionEditorPanel(DomainEditorFrame domainEditorFrame, Symbol symbol, Symbol symbol2) {
        super(domainEditorFrame);
        this.hasOverview = true;
        this.setSort(DEFAULT_SORT);
        this.currentPanel = (ActionFormPanel)this.formPanel;
        this.setupActionTree();
        this.formModel = new ActionFormModel(domainEditorFrame);
        String[] stringArray = new String[]{"pattern", "issues", "nodes", "orderings", "conditions", "constraints", "comments"};
        this.comprehensiveFields.addAll(Arrays.asList(stringArray));
        String[] stringArray2 = new String[]{"pattern", "issues", "nodes", "miniConstraints", "comments"};
        this.minimalFields.addAll(Arrays.asList(stringArray2));
        this.setConstraintsView(symbol2);
        this.enableComprehensive();
        String[] stringArray3 = new String[]{"name"};
        this.formModel.setNameFields(stringArray3);
        this.formPanel.setModel(this.formModel);
        this.formPanel.addFormActionListener(this);
        this.setCurrentView(symbol);
        this.newConstruct();
        this.makeTreePopup(new CatchingActionListener(this.parent));
    }

    protected JPanel setupMainPanel() {
        this.formPanel = new ActionFormPanel(this);
        this.graphPanel = new GExpansionEditor(this);
        XML.addImport("ix.iview.igraph.NodePosition");
        return this.formPanel;
    }

    protected void setupActionTree() {
        this.actionSplit.setRightComponent(this.scrollPane);
        this.actionSplit.setLeftComponent(this.scrollTree);
        this.actionSplit.setResizeWeight(0.3);
        this.add((Component)this.actionSplit, "Center");
        JPanel jPanel = new JPanel();
        this.scrollTree.add(jPanel);
        this.treeModel = new ShortActionTreeTableModel(this.getUIDomain());
        this.actionTree = new IXTreeTable(this.treeModel);
        this.treeModel.setParentsBold(true);
        ListSelectionModel listSelectionModel = this.actionTree.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                Object object = ActionEditorPanel.this.actionTree.getSelectedObject();
                if (object != null && !object.equals(ActionEditorPanel.this.getUIConstruct()) && object instanceof UIObject) {
                    ActionEditorPanel.this.editConstruct(object);
                }
            }
        });
        this.actionTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                IXTreeTable iXTreeTable;
                AbstractIXTableModel abstractIXTableModel;
                Object object;
                if (SwingUtilities.isRightMouseButton(mouseEvent) && (object = (abstractIXTableModel = (AbstractIXTableModel)(iXTreeTable = ActionEditorPanel.this.actionTree).getModel()).getRowObject(n = iXTreeTable.rowAtPoint(mouseEvent.getPoint()))) instanceof UINodeSpec && iXTreeTable.hasPopup()) {
                    JObjectPopup jObjectPopup = (JObjectPopup)iXTreeTable.getPopup();
                    ActionEditorPanel.this.populatePopup(jObjectPopup, object);
                    jObjectPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.actionTree.setPreferredScrollableViewportSize(new Dimension(50, 500));
        this.scrollTree.getViewport().add(this.actionTree);
        this.actionSplit.setOneTouchExpandable(true);
        this.actionSplit.setDividerLocation(170);
    }

    protected void setPanel(ConstructEditing constructEditing) {
        Dimension dimension = this.parent.getSize();
        if (this.currentPanel != null) {
            ((JPanel)((Object)this.currentPanel)).setVisible(false);
            this.scrollPane.getViewport().remove((JPanel)((Object)this.currentPanel));
        }
        this.scrollPane.getViewport().add((JPanel)((Object)constructEditing));
        this.currentPanel = constructEditing;
        this.mainPanel = (JPanel)((Object)constructEditing);
        ((JPanel)((Object)constructEditing)).setVisible(true);
        this.scrollPane.invalidate();
        this.parent.setSize(dimension);
        this.parent.validate();
    }

    public void updateToolbar(boolean bl) {
        if (this.graphPanel != null) {
            this.graphPanel.newGNodeItem.showButtonText(bl);
            this.graphPanel.deleteGNodesItem.showButtonText(bl);
            this.graphPanel.layoutItem.showButtonText(bl);
            this.graphPanel.layoutLeftItem.showButtonText(bl);
        }
    }

    public void refresh() {
        this.updateTree();
    }

    private void makeTreePopup(CatchingActionListener catchingActionListener) {
        JPopupMenu jPopupMenu = this.actionTree.getPopup();
        if (jPopupMenu == null) {
            jPopupMenu = new JObjectPopup();
            this.actionTree.setPopup(jPopupMenu);
        }
        JMenuItem jMenuItem = new JMenuItem("New Expansion");
        jMenuItem.addActionListener(catchingActionListener);
        jPopupMenu.add(jMenuItem);
    }

    public boolean isComprehensive() {
        return this.formView.equals(VIEW_COMPREHENSIVE);
    }

    public Symbol getActivityView() {
        return this.currentView;
    }

    public void setCurrentView(Symbol symbol) {
        if (symbol.equals(this.currentView)) {
            return;
        }
        if (!this.beforeSwitching()) {
            return;
        }
        if (symbol.equals(VIEW_GRAPHICAL)) {
            this.updatingView = true;
            try {
                if (!this.graphMode) {
                    this.setPanel(this.graphPanel);
                    this.graphMode = true;
                    this.currentView = symbol;
                    this.parent.setActivityView(symbol);
                    this.setUIConstructPanel(this.uiConstruct);
                }
                this.updatingView = false;
            }
            catch (Exception exception) {
                this.updatingView = false;
            }
        } else if (this.graphMode) {
            this.updatingView = true;
            try {
                this.setPanel((ActionFormPanel)this.formPanel);
                this.graphMode = false;
                this.currentView = symbol;
                if (!this.formView.equals(symbol)) {
                    this.formView = symbol;
                    this.enableComprehensive();
                } else {
                    this.setUIConstructPanel(this.uiConstruct);
                    this.invalidate();
                    this.validate();
                }
                this.parent.setActivityView(symbol);
                this.updatingView = false;
            }
            catch (Exception exception) {
                this.updatingView = false;
            }
        } else if (!this.formView.equals(symbol)) {
            this.updatingView = true;
            try {
                this.formView = symbol;
                this.currentView = symbol;
                this.enableComprehensive();
                this.parent.setActivityView(symbol);
                this.updatingView = false;
            }
            catch (Exception exception) {
                this.updatingView = false;
            }
        }
        this.afterSwitching();
    }

    public void setConstraintsView(Symbol symbol) {
        int n = this.comprehensiveFields.indexOf("constraints");
        if (n != -1) {
            this.comprehensiveFields.remove(n);
        }
        if ((n = this.comprehensiveFields.indexOf("conditions")) != -1) {
            this.comprehensiveFields.remove(n);
        }
        if ((n = this.comprehensiveFields.indexOf("orderings")) != -1) {
            this.comprehensiveFields.remove(n);
        }
        if (IDEUtil.showOther(symbol)) {
            this.comprehensiveFields.add(this.comprehensiveConstrIndex, "constraints");
        }
        if (IDEUtil.showConditions(symbol)) {
            this.comprehensiveFields.add(this.comprehensiveConstrIndex, "conditions");
        }
        if (IDEUtil.showOrder(symbol)) {
            this.comprehensiveFields.add(this.comprehensiveConstrIndex, "orderings");
        }
        this.setComprehensiveFields(this.isComprehensive(), this.uiConstruct);
    }

    public boolean isSequenceSet() {
        return ((ActionFormPanel)this.formPanel).isSequenceSet();
    }

    public void setDefaultSequence(boolean bl) {
        if (bl == this.sequence) {
            return;
        }
        this.sequence = bl;
    }

    public static boolean orderingsAreSequential(LList lList, LList lList2) {
        HashSet hashSet = new HashSet(ActionEditorPanel.makeSequence(lList));
        return new HashSet(lList2).equals(hashSet);
    }

    public void setOrdering(boolean bl) {
        if (bl) {
            this.makeSequence();
        } else {
            this.makeParallel();
        }
    }

    public void makeSequence() {
        try {
            this.uiConstruct.setOrderings(ActionEditorPanel.makeSequence(this.uiConstruct.getNodes()));
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    public static List makeSequence(List list) {
        NodeSpec nodeSpec = null;
        End end = End.END;
        End end2 = End.BEGIN;
        LListCollector lListCollector = new LListCollector();
        for (NodeSpec nodeSpec2 : list) {
            if (nodeSpec != null) {
                Ordering ordering = new Ordering(new NodeEndRef(end, nodeSpec.getId()), new NodeEndRef(end2, nodeSpec2.getId()));
                lListCollector.add(ordering);
            }
            nodeSpec = nodeSpec2;
        }
        return lListCollector;
    }

    public void makeParallel() {
        this.clearOrderings();
    }

    private void enableComprehensive() {
        this.setComprehensiveFields(this.isComprehensive(), this.uiConstruct);
    }

    private void setComprehensiveFields(boolean bl, UIRefinement uIRefinement) {
        if (bl) {
            this.formPanel.unsetSimpleField("nodes");
            this.formPanel.unsetSimpleField("issues");
            this.formPanel.setRenderer("nodes", this.fullNodeRenderer);
            this.formPanel.setRenderer("issues", this.fullIssueRenderer);
            this.formModel.setDisplayFields(this.comprehensiveFields);
        } else {
            this.formPanel.setSimpleField("nodes");
            this.formPanel.setSimpleField("issues");
            this.formPanel.setRenderer("nodes", this.miniNodeRenderer);
            this.formPanel.setRenderer("issues", this.miniIssueRenderer);
            this.formModel.setDisplayFields(this.minimalFields);
        }
        if (uIRefinement != null) {
            this.setUIConstructPanel(uIRefinement);
        }
        this.uiConstruct = uIRefinement;
        this.invalidate();
        this.validate();
    }

    public void ensureRelationEditor() {
        if (this.orderingEditor == null) {
            this.orderingEditor = new OrderingEditor(this.parent);
            this.orderingEditor.setVisible(false);
        }
    }

    public void ensureConditionEditor() {
        if (this.conditionEditor == null) {
            this.conditionEditor = new ConditionEffectEditor(this.parent);
            this.conditionEditor.setVisible(false);
        }
    }

    public void ensureConstraintEditor() {
        if (this.constraintEditor == null) {
            this.constraintEditor = new DefaultConstraintEditor(this.parent);
            this.constraintEditor.setVisible(false);
        }
    }

    public void ensureObjectConstraintEditor() {
        if (this.objectConstraintEditor == null) {
            this.objectConstraintEditor = new ObjectConstraintEditor((Frame)this.parent, this.getUIDomain());
            this.objectConstraintEditor.setVisible(false);
        }
    }

    public void ensureNodeSpecEditor() {
        if (this.nodeSpecEditor == null) {
            this.nodeSpecEditor = new SpecEditor((Frame)this.parent, "sub-activity");
            this.nodeSpecEditor.setVisible(false);
        }
    }

    public void ensureIssueSpecEditor() {
        if (this.issueSpecEditor == null) {
            this.issueSpecEditor = new SpecEditor((Frame)this.parent, "issue");
            this.issueSpecEditor.setVisible(false);
        }
    }

    public void ensureDeclarationEditor() {
        if (this.declarationEditor == null) {
            this.declarationEditor = new DeclarationEditor(this.parent);
            this.declarationEditor.setVisible(false);
        }
    }

    public void ensureSearcher() {
        if (this.searcher == null) {
            this.searcher = new PanelSearcher((AConstructFramePanel)this, new ActionListRenderer(false));
            this.searcher.setVisible(false);
        }
    }

    public void userSearch() {
        this.ensureSearcher();
        this.searcher.setVisible(true);
    }

    private void searchOld() {
        String string = JOptionPane.showInputDialog(this, (Object)"Search string (regex)");
        if (string == null || string.equals("")) {
            Debug.noteln("No search string");
        } else {
            Set set = this.getUIDomain().getMatchingRefinements(string);
            Debug.noteln("Matching specifications:", (Object)set);
            Debug.noteln("  names:", (Object)IVUtil.namedListToDisplay(set));
        }
    }

    private Point getEditorLocation() {
        Point point = this.getLocation();
        Point point2 = this.parent.getLocation();
        point.translate((int)point2.getX(), (int)point2.getY());
        Point point3 = new Point(point);
        point3.translate((int)this.mousePoint.getX(), (int)this.mousePoint.getY());
        return point3;
    }

    public boolean beforeClosing() {
        if (this.nodeSpecEditor != null) {
            this.nodeSpecEditor.setVisible(false);
        }
        if (this.issueSpecEditor != null) {
            this.issueSpecEditor.setVisible(false);
        }
        if (this.orderingEditor != null) {
            this.orderingEditor.setVisible(false);
        }
        if (this.conditionEditor != null) {
            this.conditionEditor.setVisible(false);
        }
        if (this.constraintEditor != null) {
            this.constraintEditor.setVisible(false);
        }
        if (this.objectConstraintEditor != null) {
            this.objectConstraintEditor.setVisible(false);
        }
        if (this.declarationEditor != null) {
            this.declarationEditor.setVisible(false);
        }
        if (this.searcher != null) {
            this.searcher.close();
        }
        return this.beforeSwitching();
    }

    public void setUIConstruct(UIObject uIObject) {
        if (this.beforeSwitching()) {
            this.setUIConstructPanel(uIObject);
            this.afterSwitching();
        }
    }

    public void setUIConstructPanel(UIObject uIObject) {
        UIRefinement uIRefinement = this.uiConstruct;
        this.setUIConstructOnly(uIObject);
        this.currentPanel.setUIConstruct(this.uiConstruct);
        this.fireCurrentActionChanged(uIRefinement, this.uiConstruct);
    }

    public void setUIConstructOnly(UIObject uIObject) {
        this.uiConstruct = (UIRefinement)uIObject;
        this.updateTreeSelection();
    }

    public void clearUIConstruct() {
        this.uiConstruct = (UIRefinement)this.makeNewConstruct();
        this.setUIConstructPanel(this.uiConstruct);
        this.graphPanel.setUIConstruct(this.uiConstruct);
        ((ConstructEditing)((Object)this.formPanel)).setUIConstruct(this.uiConstruct);
    }

    public UIRefinement makeNewRefinement(String string, LList lList) {
        UIRefinement uIRefinement = (UIRefinement)this.makeNewConstruct();
        uIRefinement.setName(string);
        uIRefinement.setPattern(lList);
        return uIRefinement;
    }

    public ArrayList getAllExpansions(UIRefinement uIRefinement) {
        if (this.getUIDomain() == null) {
            return null;
        }
        LList lList = uIRefinement.getPattern();
        Set set = this.getUIDomain().getMatchingRefinements(lList);
        return new ArrayList(set);
    }

    public ArrayList getAllExpansions(NodeSpec nodeSpec) {
        if (this.getUIDomain() == null) {
            return null;
        }
        LList lList = nodeSpec.getPattern();
        Set set = this.getUIDomain().getMatchingRefinements(lList);
        return new ArrayList(set);
    }

    protected UIObject noteConstruct() {
        if (this.uiConstruct == null) {
            this.uiConstruct = (UIRefinement)this.makeNewConstruct();
        }
        this.currentPanel.saveToObject(this.uiConstruct);
        this.uiConstruct.noteChange();
        if (!this.getUIDomain().equals(this.uiConstruct.getUIDomain())) {
            this.uiConstruct.moveToUIDomain(this.getUIDomain());
        }
        this.getUIDomain().updateConstruct(this.uiConstruct);
        return this.uiConstruct;
    }

    protected void resetUIConstruct(UIObject uIObject) {
        if (this.currentView.equals(VIEW_MINIMAL)) {
            MiniConstraintPanel miniConstraintPanel = (MiniConstraintPanel)this.formPanel.getFieldBit("miniConstraints");
            AbstractButton abstractButton = miniConstraintPanel.getLast();
            this.setUIConstruct(uIObject);
            this.formPanel.setFieldData("miniConstraints", abstractButton.getText());
        } else {
            this.setUIConstruct(uIObject);
        }
    }

    public boolean checkConstruct() {
        try {
            if (this.uiConstruct != null) {
                this.uiConstruct.checkConsistency();
            }
            return true;
        }
        catch (SyntaxException syntaxException) {
            JOptionPane.showMessageDialog(this, syntaxException.getMessage());
            return false;
        }
    }

    protected UIObject cloneConstruct(UIObject uIObject) {
        return ((UIRefinement)uIObject).cloneThis();
    }

    public UIObject makeNewConstruct() {
        return new UIRefinement(this.getUIDomain());
    }

    public List getAllConstructs() {
        if (this.getUIDomain() == null) {
            return new LinkedList();
        }
        List list = this.getUIDomain().getAllRefinements();
        if (list == null) {
            return new LinkedList();
        }
        return new LinkedList(list);
    }

    public Named getNamedConstruct(String string) {
        if (this.getUIDomain() == null) {
            return null;
        }
        Object object = this.getUIDomain().getNamedRefinement(string);
        if (object != null && object instanceof UIObject) {
            return (Named)object;
        }
        return this.getUIDomain().newUIObject((IXObject)object);
    }

    public void userMakeSequence() {
        this.makeSequence();
    }

    public void userMakeParallel() {
        this.makeParallel();
    }

    public void userDeclareVariables() {
        this.ensureDeclarationEditor();
        this.declarationEditor.start("Variable Declaration Editor", (Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userAddChild() {
        this.ensureNodeSpecEditor();
        this.nodeSpecEditor.start((Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userAddIssue() {
        this.ensureIssueSpecEditor();
        this.issueSpecEditor.start((Object)this.uiConstruct, this.getEditorLocation());
    }

    public void noteTextNodes() {
        JTextArea jTextArea = (JTextArea)this.nodesTextPanel.getItemComponent();
        List list = UIRefinement.parseNodes(this.getUIDomain(), jTextArea.getText());
        this.uiConstruct.updateNodes(list);
        if (this.isSequenceSet()) {
            this.makeSequence();
        }
    }

    private void userDeleteChild() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("nodes");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a sub-activity to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                this.uiConstruct.deleteNode((NodeSpec)object);
            }
            jList.clearSelection();
        }
    }

    private void userDeleteIssue() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("issues");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select an issue to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                this.uiConstruct.deleteIssue((Issue)object);
            }
            jList.clearSelection();
        }
    }

    private void userEditChild() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("nodes");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a sub-activity to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureNodeSpecEditor();
            this.nodeSpecEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userEditIssue() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("issues");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select an issue to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureIssueSpecEditor();
            this.issueSpecEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userEditOrdering() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("orderings");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a constraint to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureRelationEditor();
            this.orderingEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userEditCondition() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("conditions");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a condition to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureConditionEditor();
            this.conditionEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userEditConstraint() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("constraints");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a constraint to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureConstraintEditor();
            this.constraintEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userEditObjectConstraint() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("constraints");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a constraint to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureObjectConstraintEditor();
            this.objectConstraintEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userClearChildren() {
        List list = this.uiConstruct.getNodes();
        if (list == null || list.isEmpty()) {
            return;
        }
        String[] stringArray = new String[]{"This will clear all sub-activities.", " Are you sure you want to do this?"};
        int n = JOptionPane.showConfirmDialog(this, stringArray, "Warning", 2, 2);
        if (n == 0) {
            this.uiConstruct.setNodes(Lisp.NIL);
            this.uiConstruct.setOrderings(Lisp.NIL);
        }
    }

    private void userAddOrdering() {
        this.ensureRelationEditor();
        this.orderingEditor.start((Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userAddCondition() {
        if (this.parent.useNewCondEd) {
            this.userAddObjectConstraint();
        } else {
            this.userAddSimpleCondition();
        }
    }

    private void userAddConstraint() {
        this.ensureConstraintEditor();
        this.constraintEditor.start((Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userAddObjectConstraint() {
        this.ensureDeclarationEditor();
        this.declarationEditor.start("Object Constraint Editor", (Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userAddSimpleCondition() {
        this.ensureConditionEditor();
        this.conditionEditor.start((Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userAddSimpleObjectConstraint() {
        this.ensureObjectConstraintEditor();
        this.objectConstraintEditor.start((Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userDeleteOrdering() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("orderings");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a constraint to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                ArrayList arrayList = new ArrayList(this.uiConstruct.getOrderings());
                arrayList.remove(object);
                this.uiConstruct.setOrderings(arrayList);
            }
            jList.clearSelection();
        }
    }

    private void userDeleteCondition() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("conditions");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a condition to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                ArrayList arrayList = new ArrayList(this.uiConstruct.getConditions());
                arrayList.remove(object);
                this.uiConstruct.setConditions(arrayList);
            }
            jList.clearSelection();
        }
    }

    private void userDeleteConstraint() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("constraints");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a constraint to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                ArrayList arrayList = new ArrayList(this.uiConstruct.getConstraints());
                arrayList.remove(object);
                this.uiConstruct.setConstraints(arrayList);
            }
            jList.clearSelection();
        }
    }

    protected boolean clearOrderings() {
        List list = this.uiConstruct.getOrderings();
        if (list == null || list.isEmpty()) {
            return true;
        }
        String[] stringArray = new String[]{"This will clear all orderings between sub-activities.", " Are you sure you want to do this?"};
        int n = JOptionPane.showConfirmDialog(this, stringArray, "Warning", 2, 2);
        if (n == 0) {
            this.uiConstruct.setOrderings(Lisp.NIL);
            return true;
        }
        return false;
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
    }

    public void constructAdded(DomainEvent domainEvent) {
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        if (uIDomainEvent.getObject().equals(this.uiConstruct)) {
            this.clearUIConstruct();
        }
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.clearUIConstruct();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.clearUIConstruct();
    }

    public void setSort(boolean bl) {
        this.treeModel.setSort(bl);
    }

    public boolean getSort() {
        return this.treeModel.getSort();
    }

    public void updateTree() {
        this.treeModel.reloadData();
        this.updateTreeSelection();
    }

    public void updateTreeSelection() {
        Object object = this.actionTree.getSelectedObject();
        if (object != null && object.equals(this.uiConstruct)) {
            return;
        }
        if (object == null && this.uiConstruct == null) {
            return;
        }
        if (!this.updatingTree) {
            this.updatingTree = true;
            this.actionTree.setSelectedObject(this.uiConstruct);
            this.updatingTree = false;
        }
    }

    public void addCurrentActionListener(CurrentActionListener currentActionListener) {
        this.actionListeners.add(currentActionListener);
    }

    private void fireCurrentActionChanged(UIRefinement uIRefinement, UIRefinement uIRefinement2) {
        if (uIRefinement == null && uIRefinement2 == null) {
            return;
        }
        for (CurrentActionListener currentActionListener : this.actionListeners) {
            currentActionListener.actionChanged(this, uIRefinement, uIRefinement2);
        }
        if (uIRefinement2 == null || uIRefinement2.isEmpty()) {
            this.actionTree.clearSelection();
        }
    }

    public void actionChanged(Component component, UIRefinement uIRefinement, UIRefinement uIRefinement2) {
        if (uIRefinement2 != null && uIRefinement2.equals(uIRefinement)) {
            return;
        }
        if (uIRefinement2 == null && uIRefinement == null) {
            return;
        }
        Debug.noteln("AEP: action change in", (Object)component);
        Object object = this.actionTree.getSelectedObject();
        if (!this.equals(component) || uIRefinement2 == null || uIRefinement2.isEmpty()) {
            this.actionTree.clearSelection();
        }
        if (object == null && uIRefinement2 != null || !object.equals(uIRefinement2)) {
            this.actionTree.setSelectedObject(uIRefinement2);
        }
        if (!this.equals(component)) {
            this.setUIConstruct(uIRefinement2);
        }
    }

    public boolean frameActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "newEdit") {
            this.newConstruct();
        } else if (string == "editConstruct") {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText().trim();
            this.setUIConstruct((UIObject)this.getNamedConstruct(string2));
        } else if (string == "cut") {
            this.deleteConstruct();
        } else if (string == "copy") {
            this.copyConstruct();
        } else if (string == "modify") {
            this.saveConstruct();
        } else if (string == "revert") {
            this.revertConstruct();
        } else if (string == "revertO") {
            this.revertOConstruct();
        } else if (string == "check") {
            this.checkConstruct();
        } else if (string == "search") {
            this.userSearch();
        } else if (string == "declareVars") {
            this.userDeclareVariables();
        } else if (string == "makeSequence") {
            this.userMakeSequence();
        } else if (string == "makeParallel") {
            this.userMakeParallel();
        } else if (string == "defSequence") {
            Object object = actionEvent.getSource();
            this.parent.setDefaultSequence(((JCheckBoxMenuItem)object).getState());
        } else if (string == "graphical" && !this.updatingView) {
            this.updatingView = true;
            try {
                this.parent.setActivityView(VIEW_GRAPHICAL);
                this.updatingView = false;
            }
            catch (Exception exception) {
                this.updatingView = false;
            }
        } else if (string == "minimal" && !this.updatingView) {
            this.updatingView = true;
            try {
                this.parent.setActivityView(VIEW_MINIMAL);
                this.updatingView = false;
            }
            catch (Exception exception) {
                this.updatingView = false;
            }
        } else if (string == "comprehensive" && !this.updatingView) {
            this.updatingView = true;
            try {
                this.parent.setActivityView(VIEW_COMPREHENSIVE);
                this.updatingView = false;
            }
            catch (Exception exception) {
                this.updatingView = false;
            }
        } else {
            if (string.startsWith("Expansions for ")) {
                try {
                    return this.goToExpansion(((AbstractButton)actionEvent.getSource()).getText());
                }
                catch (Exception exception) {
                    Debug.noteException(exception);
                    return false;
                }
            }
            if (string == "New Expansion") {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                try {
                    Debug.noteln("new expansion", ((JObjectPopup)jMenuItem.getParent()).getObject());
                    this.editConstruct(((JObjectPopup)jMenuItem.getParent()).getObject());
                    return true;
                }
                catch (Exception exception) {
                    Debug.noteException(exception);
                    Debug.noteln("menu item's parent is", (Object)jMenuItem.getParent());
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public void populatePopup(JObjectPopup jObjectPopup, Object object) {
        if (object instanceof UINodeSpec) {
            ArrayList arrayList = this.getAllExpansions((UINodeSpec)object);
            String string = NodeNameRenderer.makeText((UINodeSpec)object);
            JObjectMenu jObjectMenu = null;
            try {
                jObjectMenu = (JObjectMenu)jObjectPopup.getComponent(1);
            }
            catch (Exception exception) {
                jObjectMenu = new JObjectMenu("Expansions");
                jObjectPopup.add(jObjectMenu);
            }
            UIUtil.populateMenu((ActionListener)this.parent, jObjectMenu, object, "Expansions for " + string, (List)arrayList);
            jObjectPopup.setObject(object);
            jObjectPopup.setLabel(object.toString());
        }
    }

    private boolean goToExpansion(String string) {
        UIObject uIObject = (UIObject)this.getNamedConstruct(string);
        if (uIObject == null) {
            return false;
        }
        this.setUIConstruct(uIObject);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.frameActionPerformed(actionEvent)) {
            return;
        }
        String string = actionEvent.getActionCommand();
        Debug.noteln("ActionEditorPanel: Got action command", (Object)string);
        if (string.equals("add node")) {
            this.userAddChild();
        } else if (string.equals("delete node")) {
            this.userDeleteChild();
        } else if (string.equals("add ordering")) {
            this.userAddOrdering();
        } else if (string.equals("delete ordering")) {
            this.userDeleteOrdering();
        } else {
            if (this.buttonActionPerformed(actionEvent)) {
                return;
            }
            Debug.noteln("ActionEditorPanel cannot recognise command", (Object)string);
        }
    }

    private boolean buttonActionPerformed(ActionEvent actionEvent) {
        IXEditorPanel iXEditorPanel = UIUtil.getEventPanel(actionEvent);
        if (iXEditorPanel == null) {
            return false;
        }
        String string = iXEditorPanel.getName();
        if (string == null) {
            return false;
        }
        String string2 = actionEvent.getActionCommand();
        if (string2 == null) {
            return false;
        }
        Debug.noteln("ActEdP: button action", (Object)string2);
        if (string.equals("Nodes")) {
            if (string2.equals("Add")) {
                this.userAddChild();
            } else if (string2.equals("Delete")) {
                this.userDeleteChild();
            } else if (string2.equals("Edit")) {
                this.userEditChild();
            } else {
                ActionEditorPanel.notImp(string2 + " for nodes");
                return false;
            }
            return true;
        }
        if (string.equals("Issues")) {
            if (string2.equals("Add")) {
                this.userAddIssue();
            } else if (string2.equals("Delete")) {
                this.userDeleteIssue();
            } else if (string2.equals("Edit")) {
                this.userEditIssue();
            } else {
                ActionEditorPanel.notImp(string2 + " for issues");
                return false;
            }
            return true;
        }
        if (string.equals("Ordering") || string.equals("Orderings")) {
            if (string2.equals("Add")) {
                this.userAddOrdering();
            } else if (string2.equals("Delete")) {
                this.userDeleteOrdering();
            } else if (string2.equals("Edit")) {
                this.userEditOrdering();
            } else if (string2.equals("parallel")) {
                AbstractButton abstractButton = UIUtil.getEventButton(actionEvent);
                if (abstractButton != null) {
                    ((MiniConstraintPanel)iXEditorPanel).setLast(abstractButton);
                }
                this.setOrdering(false);
            } else if (string2.equals("sequential")) {
                AbstractButton abstractButton = UIUtil.getEventButton(actionEvent);
                if (abstractButton != null) {
                    ((MiniConstraintPanel)iXEditorPanel).setLast(abstractButton);
                }
                this.setOrdering(true);
            } else if (!string2.equals("other")) {
                if (string2.equals("Comprehensive")) {
                    this.parent.setActivityView(VIEW_COMPREHENSIVE);
                } else {
                    ActionEditorPanel.notImp(string2 + " for orderings");
                    return false;
                }
            }
            return true;
        }
        if (string.equals("Conditions/Effects")) {
            if (string2.equals("Add")) {
                this.userAddCondition();
            } else if (string2.equals("Delete")) {
                this.userDeleteCondition();
            } else if (string2.equals("Edit")) {
                this.userEditCondition();
            } else {
                ActionEditorPanel.notImp(string2 + " for conditions/effects");
                return false;
            }
            return true;
        }
        if (string.equals("Constraints") || string.equals("Other Constraints") || string.equals("Constraints (Other)")) {
            if (string2.equals("Add")) {
                this.userAddConstraint();
            } else if (string2.equals("Delete")) {
                this.userDeleteConstraint();
            } else if (string2.equals("Edit")) {
                this.userEditConstraint();
            } else {
                ActionEditorPanel.notImp(string2 + " for constraints");
                return false;
            }
            return true;
        }
        ActionEditorPanel.notImp("Command " + string2);
        return false;
    }

    protected static void notImp(String string) {
        UIUtil.notImplemented(null, string);
    }

    public void dataChanged(EditableObject editableObject, String string, Object object, Object object2) {
        if (string != null && (string.equals("name") || string.equals("pattern") || string.equals("nodes"))) {
            this.updateTree();
        }
    }
}

