/*
 * Decompiled with CFR 0.152.
 */
package ix.isim.dynamic;

import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.iface.util.IFUtil;
import ix.ip2.Ip2Frame;
import ix.isim.ISim;
import ix.isim.SimulationEngine;
import ix.isim.dynamic.AnimatedObject;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.lisp.Cons;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XMLLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class ObjectAnimator
implements SimulationEngine {
    private List allAnimated = new LinkedList();
    private static ISim isim;
    private JMenuItem startStop;

    public ObjectAnimator(ISim iSim) {
        isim = iSim;
    }

    public void init() {
        Ip2Frame ip2Frame = isim.getFrame();
        JMenuBar jMenuBar = ip2Frame.getJMenuBar();
        JMenu jMenu = new JMenu("Sim");
        jMenuBar.add((Component)jMenu, 2);
        ActionInterpreter actionInterpreter = new ActionInterpreter();
        jMenu.add(IFUtil.makeMenuItem("Load Dynamic Objects ...", actionInterpreter));
        this.startStop = IFUtil.makeMenuItem("Start Dynamic Objects", actionInterpreter);
        jMenu.add(this.startStop);
        if (Parameters.haveParameter("dynamic-objects")) {
            String string = Parameters.getParameter("dynamic-objects");
            try {
                this.allAnimated.addAll(ObjectAnimator.loadObjectFile(new FileReader(string)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Debug.displayException(fileNotFoundException);
            }
        }
    }

    public void startSimulation() {
        ListIterator listIterator = this.allAnimated.listIterator();
        while (listIterator.hasNext()) {
            ((AnimatedObject)listIterator.next()).start();
        }
    }

    public void stopSimulation() {
        Iterator iterator = this.allAnimated.iterator();
        while (iterator.hasNext()) {
            ((AnimatedObject)iterator.next()).terminate();
        }
        this.allAnimated.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void sendConstraint(String string, String string2, double d, String string3) {
        Constraint constraint = ObjectAnimator.makeConstraint(string, string2, d);
        try {
            ISim iSim = isim;
            synchronized (iSim) {
                isim.handleNewConstraint(constraint);
            }
        }
        catch (Throwable throwable) {
            Debug.displayException(throwable);
        }
    }

    public static Constraint makeConstraint(String string, String string2, double d) {
        Cons cons = Lisp.list(Symbol.intern(string), Symbol.intern(string2));
        PatternAssignment patternAssignment = new PatternAssignment(cons, new Double(d));
        return new Constraint("world-state", "effect", (List)Lisp.list(patternAssignment));
    }

    protected void loadObjects() {
        XMLLoader xMLLoader = new XMLLoader(isim.getFrame(), ISim.AnimatedObjectList.class);
        List list = (List)xMLLoader.loadObject();
        if (list != null) {
            this.allAnimated.addAll(list);
        }
    }

    public static ISim.AnimatedObjectList loadObjectFile(Reader reader) {
        ISim.AnimatedObjectList animatedObjectList = new ISim.AnimatedObjectList();
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        try {
            streamTokenizer.nextToken();
            while (streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("animate")) {
                streamTokenizer.nextToken();
                animatedObjectList.add(new AnimatedObject(streamTokenizer));
            }
            if (streamTokenizer.ttype != -1) {
                throw new ParseException("EOF expected", streamTokenizer.lineno());
            }
        }
        catch (IOException iOException) {
            Debug.displayException("Unable to read objects from file because", iOException);
        }
        catch (ParseException parseException) {
            Debug.displayException("Syntax error in object animation file", parseException);
        }
        Debug.noteln("Nr of animated objects read: " + animatedObjectList.size());
        return animatedObjectList;
    }

    class ActionInterpreter
    implements ActionListener {
        ActionInterpreter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("ObjectAnimator action:", (Object)string);
            if (string.startsWith("Start")) {
                ObjectAnimator.this.startStop.setText("Stop Dynamic Objects");
                ObjectAnimator.this.startSimulation();
            } else if (string.startsWith("Stop")) {
                ObjectAnimator.this.stopSimulation();
            } else if (string.startsWith("Load")) {
                ObjectAnimator.this.loadObjects();
            } else {
                throw new ConsistencyException("Nothing to do for", string);
            }
        }
    }
}

