/*
 * Decompiled with CFR 0.152.
 */
package ix.isim;

import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.isim.ISimTimer;
import ix.isim.ISimTimerException;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.LinkedList;
import java.util.ListIterator;

public class ISimTimerServer
extends ISimTimer {
    private LinkedList registryList;

    protected ISimTimerServer(IXAgent iXAgent) {
        super(iXAgent);
        this.initializeRegistry();
    }

    public void start(long l, double d) throws ISimTimerException {
        super.start(l, d);
        this.sendStartActivity(l, d);
    }

    public long pause() {
        long l = super.pause();
        this.sendPauseActivity(l);
        return l;
    }

    public long resume() {
        long l = super.resume();
        this.sendResumeActivity(l);
        return l;
    }

    public long changeAccelerationFactor(double d) {
        long l = super.changeAccelerationFactor(d);
        this.sendAccelerateActivity(d);
        return l;
    }

    public void terminateTimer() {
        super.terminateTimer();
        this.sendStopActivity();
    }

    private void initializeRegistry() {
        this.registryList = new LinkedList();
    }

    public void handleSynchronizeActivity(Activity activity) {
        Symbol symbol = (Symbol)activity.getVerb();
        Debug.expectSame(this.SYNCHRONIZE_LABEL, symbol);
        LList lList = activity.getParameters();
        String string = (String)lList.get(0);
        if (!string.equalsIgnoreCase("register")) {
            Debug.noteln("Unrecognised synchronization activity: " + string + ". Ignoring.");
        } else {
            String string2 = (String)lList.get(1);
            this.registerAgent(string2);
        }
    }

    public synchronized void registerAgent(String string) {
        if (!this.registryList.contains(string)) {
            this.registryList.add(string);
            Debug.noteln(string + " has been registered with I-Sim.");
        }
        if (this.simulationStarted()) {
            long l = this.getSimTimeInMillis();
            Activity activity = new Activity(Lisp.list(this.SYNCHRONIZE_LABEL, "start", Long.toString(l), Double.toString(this.getAccelerationFactor())));
            IPC.sendObject(string, activity);
            if (!this.simulationActive) {
                Activity activity2 = new Activity(Lisp.list(this.SYNCHRONIZE_LABEL, "pause", Long.toString(l)));
                IPC.sendObject(string, activity2);
            }
        }
    }

    public void sendStartActivity(long l, double d) {
        Activity activity = new Activity(Lisp.list(this.SYNCHRONIZE_LABEL, "start", Long.toString(l), Double.toString(d)));
        this.iterateSendMessage(activity);
    }

    public void sendPauseActivity(long l) {
        Activity activity = new Activity(Lisp.list(this.SYNCHRONIZE_LABEL, "pause", Long.toString(l)));
        this.iterateSendMessage(activity);
    }

    public void sendResumeActivity(long l) {
        Activity activity = new Activity(Lisp.list(this.SYNCHRONIZE_LABEL, "resume", Long.toString(l)));
        this.iterateSendMessage(activity);
    }

    public void sendAccelerateActivity(double d) {
        Activity activity = new Activity(Lisp.list(this.SYNCHRONIZE_LABEL, "accelerate", Double.toString(d)));
        this.iterateSendMessage(activity);
    }

    public void sendStopActivity() {
        Activity activity = new Activity(Lisp.list(this.SYNCHRONIZE_LABEL, "stop"));
        this.iterateSendMessage(activity);
    }

    private synchronized void iterateSendMessage(Activity activity) {
        ListIterator listIterator = this.registryList.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            try {
                IPC.sendObject(string, activity);
            }
            catch (IPC.IPCException iPCException) {
                listIterator.remove();
            }
        }
    }
}

