/*
 * Decompiled with CFR 0.152.
 */
package ix.isim;

import ix.icore.IXAgent;
import ix.icore.domain.Refinement;
import ix.ip2.Ip2ModelManager;
import ix.isim.ISim;
import ix.isim.SimulationException;
import ix.isim.TimedEvent;
import ix.util.match.MatchEnv;
import java.util.List;

public abstract class ExecutableAction {
    protected TimedEvent action;
    protected Refinement method;
    private MatchEnv env = null;

    public abstract void executeAction(MatchEnv var1) throws SimulationException;

    protected void simulate(TimedEvent timedEvent, Refinement refinement) {
        this.action = timedEvent;
        this.method = refinement;
        ActionExecutionThread actionExecutionThread = new ActionExecutionThread();
        actionExecutionThread.start();
        Thread.currentThread();
        Thread.yield();
    }

    private MatchEnv verifyConditions() throws SimulationException {
        Ip2ModelManager ip2ModelManager = ((ISim)IXAgent.getAgent()).getIp2ModelManager();
        List list = ip2ModelManager.satisfyRefinementPreconditions(this.action.event, this.method);
        if (list == null || list.size() != 1) {
            throw new SimulationException("Preconditions not uniquely satisfiable.");
        }
        MatchEnv matchEnv = (MatchEnv)list.get(0);
        this.method = ip2ModelManager.fillInRefinement(this.method, matchEnv);
        return matchEnv;
    }

    private void finishAction(MatchEnv matchEnv) throws SimulationException {
        ISim iSim = (ISim)IXAgent.getAgent();
        Ip2ModelManager ip2ModelManager = iSim.getIp2ModelManager();
        ip2ModelManager.executeRefinementEffects(this.method, matchEnv);
        iSim.simulator.updateStatus(this.action, 2);
    }

    public boolean equals(ExecutableAction executableAction) {
        return this.action.equals(executableAction.action) && this.method.equals(executableAction.method) && (this.env == null && executableAction.env == null || this.env.equals(executableAction.env));
    }

    class ActionExecutionThread
    extends Thread {
        ActionExecutionThread() {
        }

        public void run() {
            try {
                ExecutableAction.this.env = ExecutableAction.this.verifyConditions();
                this.yield();
                ExecutableAction.this.executeAction(ExecutableAction.this.env);
                this.yield();
                ExecutableAction.this.finishAction(ExecutableAction.this.env);
            }
            catch (SimulationException simulationException) {
                simulationException.printStackTrace();
                ((ISim)IXAgent.getAgent()).simulator.updateStatus(ExecutableAction.this.action, 3);
            }
        }
    }
}

