/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc;

import ix.iserve.ipc.MessageMemory;
import ix.iserve.ipc.MessageWrapper;
import ix.util.CatchingThread;
import ix.util.Debug;
import ix.util.Duration;
import ix.util.IPC;
import ix.util.MessageQueue;
import ix.util.Parameters;
import ix.util.Proc;
import ix.util.Strings;
import ix.util.Util;
import ix.util.ipc.ObjectStreamConnection;
import ix.util.ipc.ServiceAddress;
import ix.util.xml.XML;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class IServeCommunicationServer {
    ServiceAddress addr = new ServiceAddress(Parameters.getParameter("ipc-server"));
    Strategy strategy = new Strategy(this.addr);
    Date startupDate = new Date();
    private Map userNameToUserMap = new TreeMap();

    public static void main(String[] stringArray) {
        Util.printGreeting("Applet Message Server");
        Parameters.setIsInteractive(false);
        Parameters.processCommandLineArguments(stringArray);
        Debug.on = Parameters.getBoolean("debug", Debug.on);
        Debug.noteThreads = true;
        try {
            new IServeCommunicationServer().start();
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            System.exit(1);
        }
        Debug.noteln("Exiting main method for no good reason");
        System.exit(2);
    }

    void start() throws Exception {
        Debug.noteln("Started " + this.startupDate + " at " + this.addr);
        ServerSocket serverSocket = new ServerSocket(this.addr.getPort());
        while (true) {
            Socket socket = serverSocket.accept();
            Debug.noteln(new Date() + " Client connection", (Object)socket);
            this.serveClientOn(new ObjectStreamConnection(socket));
        }
    }

    void serveClientOn(final ObjectStreamConnection objectStreamConnection) {
        new CatchingThread(){

            public void innerRun() {
                IServeCommunicationServer.this.clientService(objectStreamConnection);
            }

            protected void handleException(Throwable throwable) {
                Debug.noteln("Exception not handled", (Object)throwable);
                Debug.noteException(throwable);
                try {
                    objectStreamConnection.close();
                }
                catch (Throwable throwable2) {
                    Debug.noteln("Exception when closeing connection.");
                    Debug.noteException(throwable2);
                }
            }
        }.start();
    }

    void clientService(ObjectStreamConnection objectStreamConnection) {
        try {
            Object object = this.strategy.postDecode(objectStreamConnection.receive());
            this.handleMessage(objectStreamConnection, object);
        }
        catch (IPC.BrokenConnectionException brokenConnectionException) {
            Debug.noteln("Message-server lost connection to", objectStreamConnection.getDestination());
            objectStreamConnection.close();
        }
    }

    void handleMessage(ObjectStreamConnection objectStreamConnection, Object object) {
        Debug.noteln("Message server received", object);
        Object object2 = null;
        try {
            MessageWrapper messageWrapper = this.unpackRequest(object);
            object2 = this.evalMessage(messageWrapper, objectStreamConnection);
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            object2 = "Server exception: " + Debug.describeException(throwable);
        }
        if (object2 != null) {
            this.sendReply(objectStreamConnection, object2);
            objectStreamConnection.close();
        }
    }

    MessageWrapper unpackRequest(Object object) {
        MessageWrapper messageWrapper = (MessageWrapper)object;
        if (messageWrapper.getCommand().equals("server-status")) {
            return messageWrapper;
        }
        MessageWrapper messageWrapper2 = (MessageWrapper)XML.objectFromXML(messageWrapper.getCommand());
        messageWrapper2.setRemoteHost(messageWrapper.getRemoteHost());
        messageWrapper2.setRemoteAddr(messageWrapper.getRemoteAddr());
        return messageWrapper2;
    }

    Object sendReply(ObjectStreamConnection objectStreamConnection, Object object) {
        Debug.noteln(new Date() + " Trying to send reply:", object);
        String string = XML.objectToXMLString(object);
        Debug.noteln("The reply as XML:", (Object)string);
        objectStreamConnection.send(this.strategy.preEncode(string));
        Debug.noteln("Sent:", object);
        Object object2 = this.strategy.postDecode(objectStreamConnection.receive());
        Debug.noteln("Status from sending reply " + object + ":", object2);
        return object2;
    }

    Object evalMessage(MessageWrapper messageWrapper, ObjectStreamConnection objectStreamConnection) {
        String string = XML.objectToXMLString(messageWrapper);
        Debug.noteln(new Date() + " Evaluating", (Object)string);
        String string2 = messageWrapper.getCommand();
        if (string2.equals("register-as")) {
            return this.evalRegisterAs(messageWrapper);
        }
        if (string2.equals("send-to")) {
            return this.evalSendTo(messageWrapper);
        }
        if (string2.equals("get-message")) {
            return this.evalGetMessage(messageWrapper, objectStreamConnection);
        }
        if (string2.equals("server-status")) {
            return this.evalServerStatus(messageWrapper);
        }
        throw new UnsupportedOperationException("Unknown message command " + string2);
    }

    String evalRegisterAs(MessageWrapper messageWrapper) {
        String string = (String)messageWrapper.getArg(0);
        User user = this.getUser(string);
        if (user == null) {
            Debug.expect(messageWrapper.getRemoteAddr() != null, "No host addr for user " + Strings.quote(string));
            User user2 = new User(string, messageWrapper);
            this.recordUser(user2);
            user2.registered(messageWrapper, true);
            return "ok";
        }
        if (messageWrapper.getRemoteAddr().equals(user.getHostAddr())) {
            user.getConnectionQueue().clear();
            user.registered(messageWrapper, false);
            return "ok";
        }
        throw new IllegalArgumentException("Another user is already registered as " + Strings.quote(string));
    }

    String evalSendTo(MessageWrapper messageWrapper) {
        this.checkSender(messageWrapper);
        String string = (String)messageWrapper.getArg(0);
        User user = this.getUser(string);
        if (user == null) {
            throw new IllegalArgumentException("There is no user named " + Strings.quote(string));
        }
        user.addMessage(messageWrapper);
        return "ok";
    }

    MessageWrapper evalGetMessage(MessageWrapper messageWrapper, ObjectStreamConnection objectStreamConnection) {
        MessageWrapper messageWrapper2;
        this.checkSender(messageWrapper);
        User user = this.getUser(messageWrapper.getFrom());
        if (messageWrapper.getSequenceNumber() != null) {
            user.acknowledgedReceipt(messageWrapper.getSequenceNumber());
        }
        if ((messageWrapper2 = user.getFirstUnacknowledgedMessage()) != null) {
            user.pushMessage(messageWrapper2);
        }
        user.takeConnection(objectStreamConnection);
        return null;
    }

    void checkSender(MessageWrapper messageWrapper) {
        String string = messageWrapper.getFrom();
        User user = this.getUser(string);
        if (user == null) {
            throw new IllegalArgumentException("Message from unknown user " + Strings.quote(string));
        }
        if (!messageWrapper.getRemoteAddr().equals(user.getHostAddr())) {
            throw new IllegalArgumentException("Message from wrong user " + Strings.quote(string));
        }
        user.sent(messageWrapper);
    }

    String evalServerStatus(MessageWrapper messageWrapper) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Date date = new Date();
        linkedList.add("Status as of " + date);
        linkedList.add("Started running " + this.agoTime(this.startupDate, date));
        linkedList.add("Log file: " + Parameters.getParameter("server-log-file", "none"));
        List list = this.getUsers();
        if (list.isEmpty()) {
            linkedList.add("No users");
        } else {
            linkedList.add("");
            linkedList.add("Users:");
            for (User user : this.getUsers()) {
                linkedList.add(user.status(date));
                linkedList.add("");
            }
        }
        return Strings.joinLines(linkedList);
    }

    protected String agoTime(Date date, Date date2) {
        Duration duration = new Duration(date, date2).roundToMinutes();
        return date + (duration.asMilliseconds() > 0L ? ", " + duration + " ago" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User getUser(String string) {
        Map map = this.userNameToUserMap;
        synchronized (map) {
            return (User)this.userNameToUserMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getUsers() {
        Map map = this.userNameToUserMap;
        synchronized (map) {
            LinkedList linkedList = new LinkedList();
            for (Map.Entry entry : this.userNameToUserMap.entrySet()) {
                linkedList.add(entry.getValue());
            }
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordUser(User user) {
        user.noteln("Recording user");
        Map map = this.userNameToUserMap;
        synchronized (map) {
            String string = user.getName();
            Debug.expect(this.getUser(string) == null, "User " + string + " already exists");
            this.userNameToUserMap.put(string, user);
            user.startMessageThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUser(User user) {
        user.noteln("Removing user");
        Map map = this.userNameToUserMap;
        synchronized (map) {
            user.killMessageThread();
            this.userNameToUserMap.remove(user);
        }
    }

    protected class UserMessageThread
    extends Thread {
        User user;
        volatile boolean exit;

        UserMessageThread(User user) {
            super(user + " messages");
            this.exit = false;
            this.user = user;
        }

        public void run() {
            try {
                this.transferMessages();
            }
            catch (Throwable throwable) {
                this.user.noteln("Uncaught exception in message thread: " + Debug.describeException(throwable));
                Debug.noteException(throwable);
            }
            this.user.noteln("Message thread exits");
        }

        void transferMessages() {
            MessageQueue messageQueue = this.user.getMessageQueue();
            MessageQueue messageQueue2 = this.user.getConnectionQueue();
            block2: while (!this.exit) {
                Object object = messageQueue.nextMessage();
                if (object instanceof InterruptedException) {
                    this.user.noteln("Message thread interrupted");
                    continue;
                }
                MessageWrapper messageWrapper = (MessageWrapper)object;
                this.user.noteln("Have " + messageWrapper + ", key " + messageWrapper.getSequenceNumber());
                while (!this.exit && object != null) {
                    ObjectStreamConnection objectStreamConnection = (ObjectStreamConnection)messageQueue2.nextMessage();
                    this.user.noteln("Taking connection", objectStreamConnection);
                    this.user.noteln("Trying to send", object);
                    if (!this.user.isUnacknowledged(messageWrapper)) {
                        Debug.noteln("Oops, user already has", object);
                        messageQueue2.push(objectStreamConnection);
                        continue block2;
                    }
                    try {
                        Object object2 = IServeCommunicationServer.this.sendReply(objectStreamConnection, object);
                        if (object2.equals("ok")) {
                            objectStreamConnection.close();
                            this.user.noteln("Successfully sent", object);
                            object = null;
                            continue;
                        }
                        this.user.noteln("Send had status", object2);
                    }
                    catch (Throwable throwable) {
                        Debug.noteln("Exception during send:", (Object)Debug.describeException(throwable));
                    }
                }
            }
        }
    }

    protected class User {
        String name;
        String hostName;
        String hostAddr;
        MessageQueue messageQueue = new MessageQueue(true);
        MessageQueue connectionQueue = new MessageQueue(true);
        MessageMemory unacknowledged = new MessageMemory();
        UserMessageThread messageThread;
        List registrationDates = new LinkedList();
        Date lastContactDate = null;
        Date lastSendDate = null;
        Date lastAckDate = null;
        int seqNo = 0;

        User(String string, MessageWrapper messageWrapper) {
            this.name = string;
            this.hostName = messageWrapper.getRemoteHost();
            this.hostAddr = messageWrapper.getRemoteAddr();
            this.messageThread = new UserMessageThread(this);
        }

        synchronized String getName() {
            return this.name;
        }

        synchronized String getHostAddr() {
            return this.hostAddr;
        }

        synchronized MessageQueue getMessageQueue() {
            return this.messageQueue;
        }

        synchronized MessageQueue getConnectionQueue() {
            return this.connectionQueue;
        }

        synchronized void sent(MessageWrapper messageWrapper) {
            Date date;
            this.lastContactDate = date = new Date();
            if (messageWrapper.getCommand().equals("send-to")) {
                this.lastSendDate = date;
            }
        }

        synchronized List getRegistrationDates() {
            return new ArrayList(this.registrationDates);
        }

        synchronized void registered(MessageWrapper messageWrapper, boolean bl) {
            Date date;
            this.lastContactDate = date = new Date();
            this.noteln(date + " " + (bl ? "new registration" : "re-registration"));
            Debug.expect(this.registrationDates.isEmpty() == bl);
            this.registrationDates.add(date);
            int n = messageWrapper.getSeqNo();
            this.noteln("Seq numbers: reg says " + n + ", we have " + this.seqNo);
            if (bl && n > -1) {
                this.noteln("Renumbering messages");
                final int n2 = n + 1;
                this.messageQueue.callOnContents(new Proc(){

                    public void call(Object object) {
                        List list = (List)object;
                        for (MessageWrapper messageWrapper : list) {
                            int n = messageWrapper.getSeqNo();
                            int n22 = n + n2;
                            User.this.noteln("renumbering " + n + " to " + n22);
                            messageWrapper.setSeqNo(n22);
                        }
                    }
                });
                this.seqNo += n2;
                this.noteln("Revised next-message number " + this.seqNo);
            }
        }

        synchronized void addMessage(MessageWrapper messageWrapper) {
            this.noteln("Adding message " + this.seqNo);
            messageWrapper.setSeqNo(this.seqNo++);
            this.remember(messageWrapper);
            this.messageQueue.send(messageWrapper);
        }

        synchronized void pushMessage(MessageWrapper messageWrapper) {
            Debug.expect(messageWrapper.getSequenceNumber() != null);
            this.noteln("Pushing message with key", messageWrapper.getSequenceNumber());
            this.messageQueue.push(messageWrapper);
        }

        private void remember(MessageWrapper messageWrapper) {
            Integer n = messageWrapper.getSequenceNumber();
            if (!this.unacknowledged.containsKey(n)) {
                this.noteln("Remembering message with key", n);
                this.unacknowledged.remember(messageWrapper);
            }
        }

        synchronized boolean isUnacknowledged(MessageWrapper messageWrapper) {
            return this.unacknowledged.containsKey(messageWrapper.getSequenceNumber());
        }

        synchronized MessageWrapper getFirstUnacknowledgedMessage() {
            MessageWrapper messageWrapper = this.unacknowledged.getFirstRemainingMessage();
            if (messageWrapper != null) {
                this.noteln("Getting 1st message; it has key", messageWrapper.getSequenceNumber());
            }
            return messageWrapper;
        }

        synchronized void acknowledgedReceipt(Integer n) {
            Date date;
            this.lastContactDate = date = new Date();
            if (this.unacknowledged.containsKey(n)) {
                this.noteln("Acknowledged receipt of message", n);
                this.lastAckDate = date;
                this.unacknowledged.forgetKey(n);
            }
        }

        synchronized void takeConnection(ObjectStreamConnection objectStreamConnection) {
            this.connectionQueue.send(objectStreamConnection);
        }

        synchronized void startMessageThread() {
            this.messageThread.start();
        }

        synchronized void killMessageThread() {
            this.messageThread.exit = true;
            this.messageThread.interrupt();
        }

        void noteln(String string) {
            Debug.noteln(this + ": " + string);
        }

        void noteln(String string, Object object) {
            Debug.noteln(this + ": " + string, object);
        }

        public synchronized String toString() {
            return "User[" + this.name + "]";
        }

        public synchronized String status(Date date) {
            List list;
            final LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(this.name + " at " + this.hostName + " " + this.hostAddr);
            linkedList.add("  Time of last active contact: " + IServeCommunicationServer.this.agoTime(this.lastContactDate, date));
            if (this.lastSendDate != null) {
                linkedList.add("  Last send to another agent:  " + IServeCommunicationServer.this.agoTime(this.lastSendDate, date));
            }
            if (this.lastAckDate != null) {
                linkedList.add("  Last receipt acknowledgment: " + IServeCommunicationServer.this.agoTime(this.lastAckDate, date));
            }
            if (!(list = this.registrationDates).isEmpty()) {
                linkedList.add("  Registration times:");
                for (Date date2 : list) {
                    linkedList.add("    " + IServeCommunicationServer.this.agoTime(date2, date));
                }
            }
            if (this.unacknowledged.size() > 0) {
                linkedList.add("  Waiting messages:");
                this.unacknowledged.walkContents(new Proc(){

                    public void call(Object object, Object object2) {
                        MessageWrapper messageWrapper = (MessageWrapper)object2;
                        linkedList.add("    " + User.this.describeMessage(messageWrapper));
                    }
                });
            }
            return Strings.joinLines(linkedList);
        }

        protected String describeMessage(MessageWrapper messageWrapper) {
            Object object = messageWrapper.getArg(1);
            Class<?> clazz = object.getClass();
            String string = XML.nameForClass(clazz);
            return messageWrapper.getSendDate() + " " + string + " from " + messageWrapper.getFrom();
        }
    }

    static class Strategy
    extends IPC.SimpleIXCommunicationStrategy {
        ServiceAddress serverAddr;

        Strategy(ServiceAddress serviceAddress) {
            this.serverAddr = serviceAddress;
            this.setDestinationAddress("message-server", serviceAddress);
        }
    }
}

