/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.Issue;
import ix.icore.Status;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.Refinement;
import ix.ip2.ActivityHandler;
import ix.ip2.Agenda;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.iplan.IPlanModelManager;
import ix.iplan.Thatcher;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ThatcherActivityHandler
extends ActivityHandler {
    protected Thatcher planner;
    protected Agenda actAgenda;
    protected IPlanModelManager modelManager;

    public ThatcherActivityHandler(Thatcher thatcher) {
        super("Planning operations on activities");
        this.planner = thatcher;
        this.actAgenda = thatcher.getController().getActivityAgenda();
        this.modelManager = (IPlanModelManager)thatcher.getModelManager();
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        return !agendaItem.isExpanded();
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        for (Refinement refinement : this.planner.getDomain().getRefinements()) {
            MatchEnv matchEnv = Matcher.match(refinement.getPattern(), agendaItem.getPattern());
            if (matchEnv == null) continue;
            if (Collect.isEmpty(refinement.getNodes()) && Collect.isEmpty(refinement.getConstraints())) {
                agendaItem.addAction(new HandlerAction.Manual(refinement.getName()));
                continue;
            }
            agendaItem.addAction(new ExpandAction(agendaItem, refinement, matchEnv));
        }
        if (agendaItem.getActions().isEmpty()) {
            agendaItem.addAction(new HandlerAction.Manual());
        }
    }

    private class ExpandAction
    extends HandlerAction {
        AgendaItem item;
        Refinement refinement;
        MatchEnv refinementMatchEnv;
        ListOfConstraint filters;
        List filterEnvs = Collections.EMPTY_LIST;

        ExpandAction(AgendaItem agendaItem, Refinement refinement, MatchEnv matchEnv) {
            this.item = agendaItem;
            this.refinement = refinement;
            this.refinementMatchEnv = matchEnv;
            this.filters = refinement.getFilterConstraints();
            this.shortDescription = "Expand using " + refinement.getName();
        }

        public boolean isStillValid() {
            if (this.item.isExpanded()) {
                return false;
            }
            this.refinementMatchEnv = Matcher.match(this.refinement.getPattern(), this.item.getPattern());
            return this.refinementMatchEnv != null;
        }

        public boolean isReady() {
            return this.filters.isEmpty() || !this.filterEnvs.isEmpty();
        }

        public void computeStatus() {
            if (!this.filters.isEmpty()) {
                this.filterEnvs = ThatcherActivityHandler.this.modelManager.evalFilters(this.filters, this.refinementMatchEnv);
            }
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(this.isReady(), this + " asked to handle " + agendaItem + " when not ready");
            Debug.expect(agendaItem == this.item);
            this.do_expansion(agendaItem);
        }

        protected void do_expansion(AgendaItem agendaItem) {
            Object object;
            Object object2;
            Debug.noteln("Expanding using", (Object)this.refinement);
            MatchEnv matchEnv = this.getInstantiationEnv();
            Debug.noteln("Using env", (Object)matchEnv);
            Debug.noteln("Filters", (Object)this.filters);
            agendaItem.expandOneLevel(this.refinement, matchEnv);
            ThatcherActivityHandler.this.modelManager.applyEnv(matchEnv);
            Object object3 = Collect.iterator(agendaItem.getChildren());
            while (object3.hasNext()) {
                object2 = (AgendaItem)object3.next();
                ThatcherActivityHandler.this.actAgenda.addItem((AgendaItem)object2);
            }
            object3 = agendaItem.getRefinement().getIssues();
            object2 = Collect.iterator((Collection)object3);
            while (object2.hasNext()) {
                object = (Issue)object2.next();
                ThatcherActivityHandler.this.planner.getController().addIssue((Issue)object);
            }
            object2 = agendaItem.getRefinement().getConstraints();
            if (object2 != null) {
                ThatcherActivityHandler.this.planner.getModelManager().addConstraints(agendaItem, (List)object2);
            }
            object = agendaItem.getRefinement().getFilterConstraints();
            Debug.noteln("Instantiated conds", object);
            if (object.isEmpty()) {
                this.adjustStatus(agendaItem);
                return;
            }
            List list = ThatcherActivityHandler.this.modelManager.evalFilters((ListOfConstraint)object, new MatchEnv());
            Debug.expect(!list.isEmpty(), "Cannot match filter conditions " + object);
            if (list.size() == 1) {
                ThatcherActivityHandler.this.modelManager.satisfyConds(agendaItem, (ListOfConstraint)object, (MatchEnv)list.get(0));
                this.adjustStatus(agendaItem);
                return;
            }
            ThatcherActivityHandler.this.modelManager.satisfyConds(agendaItem, (ListOfConstraint)object, (MatchEnv)list.get(0));
            this.adjustStatus(agendaItem);
        }

        protected void adjustStatus(AgendaItem agendaItem) {
            if (agendaItem.getStatus() == Status.POSSIBLE) {
                agendaItem.setStatus(Collect.isEmpty(agendaItem.getChildren()) ? Status.COMPLETE : Status.EXECUTING);
            }
        }

        protected MatchEnv getInstantiationEnv() {
            if (!this.filters.isEmpty() && this.filterEnvs.size() == 1) {
                return (MatchEnv)this.filterEnvs.get(0);
            }
            return this.refinementMatchEnv;
        }
    }
}

