/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.HasStatus;
import ix.icore.Status;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.plan.Plan;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.iface.util.KeyValueTable;
import ix.ip2.ComputeInterpreter;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.ip2.LispComputeInterpreter;
import ix.iplan.ExecutionStages;
import ix.iplan.IPlanOptionManager;
import ix.iplan.SanityChecker;
import ix.test.PlainIp2;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Predicate1;
import ix.util.TopologicalSorter;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanCheckingSimulator {
    protected static final Symbol TRUE = Symbol.intern("true");
    protected static final Symbol FALSE = Symbol.intern("false");
    protected Ip2ModelManager modelManager;
    protected ComputeInterpreter computeInterpreter;
    protected SanityChecker sanityChecker;
    protected Map worldState;
    protected List problems;
    protected List executionOrder;
    protected Random random;
    protected boolean shuffle = false;
    protected boolean trace = true;
    protected long randomSeed = -4775043618027098404L;
    protected boolean randomized = false;
    protected PrintStream traceOut = Debug.out;

    public PlanCheckingSimulator(Ip2 ip2) {
        this.modelManager = (Ip2ModelManager)ip2.getModelManager();
        this.computeInterpreter = new CheckingInterpreter(ip2);
        this.sanityChecker = new SanityChecker(this);
    }

    public PlanCheckingSimulator(Plan plan, Domain domain) {
        this(PlanCheckingSimulator.makeModelHolder(plan, domain));
    }

    private static Ip2 makeModelHolder(Plan plan, Domain domain) {
        Debug.expect(plan != null, "No plan was supplied");
        Debug.expect(domain != null, "No domain was supplied");
        IPlanOptionManager.ModelHolder modelHolder = IPlanOptionManager.ModelHolder.newInstance();
        modelHolder.loadDomain(domain);
        modelHolder.loadPlan(plan);
        return modelHolder;
    }

    public Ip2ModelManager getModelManagerBeingChecked() {
        return this.modelManager;
    }

    public void setShuffle(boolean bl) {
        this.shuffle = bl;
        this.random = bl ? new Random(this.randomSeed) : null;
    }

    public void randomize() {
        this.randomSeed = System.currentTimeMillis();
        this.setShuffle(true);
        this.randomized = true;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setTraceOutput(PrintStream printStream) {
        this.traceOut = printStream;
    }

    public void run() {
        this.worldState = new HashMap(this.getInitialWorldStateMap());
        this.problems = new LinkedList();
        this.sanityChecker.checkPlan();
        this.checkNodeStatusValues();
        this.checkNodeEndStatusValues();
        List<PNodeEnd> list = this.modelManager.getNodeEnds();
        new ExecutionStages(list).getStages();
        List<PNodeEnd> list2 = this.maybeShuffle(this.removeIf(Status.COMPLETE, list));
        List list3 = new ExecOrderSorter().sort(list2);
        HashSet<PNodeEnd> hashSet = new HashSet<PNodeEnd>(list2);
        HashSet hashSet2 = new HashSet();
        HashSet<PNodeEnd> hashSet3 = new HashSet<PNodeEnd>(this.keepIf(Status.COMPLETE, list));
        this.executionOrder = list3;
        for (PNodeEnd pNodeEnd : list3) {
            this.traceln("Executing", pNodeEnd);
            this.nextExecFringe(hashSet2, hashSet, hashSet3);
            Debug.expect(hashSet2.contains(pNodeEnd), "Not ready", pNodeEnd);
            this.checkConditions(pNodeEnd, hashSet2);
            this.doEffects(pNodeEnd);
            hashSet2.remove(pNodeEnd);
            hashSet3.add(pNodeEnd);
        }
    }

    public List getProblems() {
        return this.problems;
    }

    public Map getInitialWorldStateMap() {
        return this.modelManager.getWorldStateMap();
    }

    public Map getWorldStateMap() {
        return this.worldState;
    }

    public Map getChangedWorldStateMap() {
        TreeMap treeMap = new TreeMap(new KeyValueTable.PatternObjectComparator());
        treeMap.putAll(this.getWorldStateMap());
        Collect.removeAll(treeMap, this.getInitialWorldStateMap());
        return treeMap;
    }

    public List getExecutionOrder() {
        return this.executionOrder;
    }

    public void report() {
        this.report(this.traceOut);
    }

    public void report(PrintStream printStream) {
        if (this.shuffle && this.randomized) {
            printStream.println("Shuffle with seed " + this.randomSeed);
        }
        if (this.problems.isEmpty()) {
            printStream.println("No problems found.");
            return;
        }
        int n = this.problems.size();
        printStream.println(n == 1 ? "1 problem:" : n + " problems:");
        for (String string : this.problems) {
            printStream.println(string);
        }
    }

    public void describeFinalWorldState() {
        this.describeFinalWorldState(this.traceOut);
    }

    public void describeFinalWorldState(PrintStream printStream) {
        TreeMap treeMap = new TreeMap(new KeyValueTable.PatternObjectComparator());
        treeMap.putAll(this.getWorldStateMap());
        this.describeState(printStream, "Final world state", treeMap);
    }

    public void describeChangedWorldState() {
        this.describeChangedWorldState(this.traceOut);
    }

    public void describeChangedWorldState(PrintStream printStream) {
        this.describeState(printStream, "Changed world state", this.getChangedWorldStateMap());
    }

    protected void describeState(PrintStream printStream, String string, Map map) {
        if (map.isEmpty()) {
            printStream.println(string + " is empty");
        } else {
            printStream.println(string + ":");
            for (Map.Entry entry : map.entrySet()) {
                printStream.println("   " + entry.getKey() + " = " + entry.getValue());
            }
        }
    }

    protected List<PNodeEnd> maybeShuffle(List<PNodeEnd> list) {
        if (this.shuffle) {
            ArrayList<PNodeEnd> arrayList = new ArrayList<PNodeEnd>(list);
            Collections.shuffle(arrayList, this.random);
            return arrayList;
        }
        return list;
    }

    protected List removeIf(final Status status, List list) {
        return (List)Collect.filter(list, new Predicate1(){

            public boolean trueOf(Object object) {
                return ((PNodeEnd)object).getStatus() != status;
            }
        });
    }

    protected List keepIf(final Status status, List list) {
        return (List)Collect.filter(list, new Predicate1(){

            public boolean trueOf(Object object) {
                return ((PNodeEnd)object).getStatus() == status;
            }
        });
    }

    protected void checkNodeStatusValues() {
        for (PNode pNode : this.modelManager.getNodes()) {
            Status status;
            Status status2 = pNode.getStatus();
            if (status2 == (status = pNode.statusFromNodeEnds())) continue;
            this.wrongStatusProblem(pNode, status);
        }
    }

    protected void checkNodeEndStatusValues() {
        for (PNodeEnd pNodeEnd : this.modelManager.getNodeEnds()) {
            this.checkNodeEndStatusValue(pNodeEnd);
        }
    }

    protected void checkNodeEndStatusValue(PNodeEnd pNodeEnd) {
        boolean bl = PNode.allHaveStatus(pNodeEnd.getPredecessors(), Status.COMPLETE);
        Status status = pNodeEnd.getStatus();
        if (status == Status.COMPLETE) {
            if (!bl) {
                this.wrongStatusProblem(pNodeEnd, Status.BLANK);
            }
        } else if (status == Status.BLANK || status == Status.POSSIBLE) {
            Status status2;
            Status status3 = status2 = bl ? Status.POSSIBLE : Status.BLANK;
            if (status != status2) {
                this.wrongStatusProblem(pNodeEnd, status2);
            }
        } else if (status == Status.EXECUTING) {
            this.wrongStatusProblem(pNodeEnd, Status.COMPLETE);
        } else {
            this.problem(pNodeEnd + " has status " + status);
        }
    }

    protected void wrongStatusProblem(HasStatus hasStatus, Status status) {
        this.problem(hasStatus + " has status " + hasStatus.getStatus() + " when it should be " + status);
    }

    protected void nextExecFringe(Set set, Set set2, Set set3) {
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            PNodeEnd pNodeEnd = (PNodeEnd)iterator.next();
            if (!set3.containsAll(pNodeEnd.getPredecessors())) continue;
            iterator.remove();
            set.add(pNodeEnd);
        }
    }

    protected void traceln(String string) {
        if (this.trace) {
            this.traceOut.println(string);
        }
    }

    protected void traceln(String string, Object object) {
        if (this.trace) {
            this.traceOut.println(string + " " + object);
        }
    }

    protected void problem(String string) {
        if (this.trace) {
            this.traceln("Problem:", string);
        }
        this.problems.add(string);
    }

    protected void checkConditions(PNodeEnd pNodeEnd, Set set) {
        for (Constraint constraint : this.getConditions(pNodeEnd)) {
            if (constraint.getType() == Refinement.S_COMPUTE) {
                this.checkComputeCondition(constraint);
                continue;
            }
            if (constraint.getType() != Refinement.S_WORLD_STATE) {
                this.problem("Cannot evaluate " + constraint);
                continue;
            }
            PatternAssignment patternAssignment = constraint.getPatternAssignment();
            this.traceln("  Condition:", patternAssignment);
            LList lList = (LList)Variable.removeVars(patternAssignment.getPattern());
            Object object = Variable.removeVars(patternAssignment.getValue());
            Object v = this.worldState.get(lList);
            if (v == null) {
                this.problem("pattern " + lList + " has no value " + " at " + pNodeEnd + ", expected " + object);
            } else if (!v.equals(object)) {
                this.problem("pattern " + lList + " has value " + v + " at " + pNodeEnd + ", expected " + object);
            }
            this.checkForDeleters(pNodeEnd, lList, object, set);
        }
    }

    protected void checkForDeleters(PNodeEnd pNodeEnd, LList lList, Object object, Set set) {
        for (PNodeEnd pNodeEnd2 : set) {
            if (pNodeEnd2 == pNodeEnd) continue;
            for (PatternAssignment patternAssignment : this.getEffects(pNodeEnd2)) {
                LList lList2 = (LList)Variable.removeVars(patternAssignment.getPattern());
                Object object2 = Variable.removeVars(patternAssignment.getValue());
                if (!lList2.equals(lList) || object2.equals(object)) continue;
                this.problem("Condition " + lList + " = " + object + " at " + pNodeEnd + " is deleted by value " + object2 + " at " + pNodeEnd2);
            }
        }
    }

    protected void checkComputeCondition(Constraint constraint) {
        PatternAssignment patternAssignment = constraint.getPatternAssignment();
        this.traceln(constraint.getRelation() == Refinement.S_MULTIPLE_ANSWER ? "  Multiple-answer compute condition:" : "  Compute condition:", patternAssignment);
        LList lList = (LList)Variable.removeVars(patternAssignment.getPattern());
        Object object = Variable.removeVars(patternAssignment.getValue());
        Object object2 = this.computeInterpreter.compute(lList);
        if (constraint.getRelation() == Refinement.S_MULTIPLE_ANSWER) {
            if (!(object2 instanceof Collection)) {
                this.problem("The multiple-answer value of " + lList + " was " + object2 + ", not a collection.");
            } else if (!((Collection)object2).contains(object)) {
                this.problem("The multiple-answer value of " + lList + ", " + object2 + ", did not contain " + object);
            }
        } else {
            this.checkComputeResult(lList, object, object2);
        }
    }

    protected void checkComputeResult(LList lList, Object object, Object object2) {
        if (!this.matchComputeResult(object, object2)) {
            this.problem("The value of " + lList + " was " + object2 + " instead of " + object);
        }
    }

    protected boolean matchComputeResult(Object object, Object object2) {
        if (object == TRUE) {
            return this.computeInterpreter.isTrue(object2);
        }
        if (object == FALSE) {
            return !this.computeInterpreter.isTrue(object2);
        }
        return object.equals(object2);
    }

    protected void doEffects(PNodeEnd pNodeEnd) {
        for (PatternAssignment patternAssignment : this.getEffects(pNodeEnd)) {
            this.traceln("  Effect:", patternAssignment);
            LList lList = (LList)Variable.removeVars(patternAssignment.getPattern());
            Object object = Variable.removeVars(patternAssignment.getValue());
            this.worldState.put(lList, object);
        }
    }

    protected List getConditions(PNodeEnd pNodeEnd) {
        return pNodeEnd.getEnd() == End.BEGIN ? Collect.ensureList(this.modelManager.getNodeConditions(pNodeEnd.getNode())) : Lisp.NIL;
    }

    protected List getEffects(PNodeEnd pNodeEnd) {
        return pNodeEnd.getEnd() == End.END ? Collect.ensureList(this.modelManager.getNodeEffects(pNodeEnd.getNode())) : Lisp.NIL;
    }

    public static void main(String[] stringArray) {
        Debug.off();
        PlainIp2 plainIp2 = new PlainIp2();
        plainIp2.mainStartup(stringArray);
        Debug.on = true;
        PlanCheckingSimulator planCheckingSimulator = new PlanCheckingSimulator(plainIp2);
        planCheckingSimulator.processCommandLineArguments();
        planCheckingSimulator.traceln("");
        planCheckingSimulator.traceln("- - - - - Beginning simulation - - - - -");
        planCheckingSimulator.traceln("");
        planCheckingSimulator.run();
        planCheckingSimulator.traceln("");
        planCheckingSimulator.report();
        planCheckingSimulator.traceln("");
        if (planCheckingSimulator.trace) {
            planCheckingSimulator.describeFinalWorldState();
        }
        if (planCheckingSimulator.trace) {
            planCheckingSimulator.traceln("");
            planCheckingSimulator.describeChangedWorldState();
        }
    }

    protected void processCommandLineArguments() {
        this.setTrace(Parameters.getBoolean("trace", true));
        this.setShuffle(Parameters.getBoolean("shuffle", false));
        if (Parameters.getBoolean("randomize", false)) {
            this.randomize();
        }
    }

    protected class CheckingInterpreter
    extends LispComputeInterpreter {
        public CheckingInterpreter(Ip2 ip2) {
            super(null);
            this.loadSupportCode(ip2.getDomain().getAnnotation(Symbol.intern("compute-support-code")));
        }

        protected Object getWorldStateValue(LList lList) {
            return PlanCheckingSimulator.this.worldState.get(lList);
        }
    }

    protected class ExecOrderSorter
    extends TopologicalSorter {
        protected ExecOrderSorter() {
        }

        protected Collection getChildren(Object object) {
            return PlanCheckingSimulator.this.maybeShuffle(((PNodeEnd)object).getSuccessors());
        }
    }
}

