/*
 * Decompiled with CFR 0.152.
 */
package ix.iplan;

import ix.icore.process.PNodeEnd;
import ix.test.PlainIp2;
import ix.util.ConsistencyException;
import ix.util.Debug;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionStages {
    protected List<List<PNodeEnd>> stages;

    public ExecutionStages(List<PNodeEnd> list) {
        this.stages = this.makeExecutionStages(list);
    }

    public List<List<PNodeEnd>> getStages() {
        return this.stages;
    }

    protected List<List<PNodeEnd>> makeExecutionStages(List<PNodeEnd> list) {
        LinkedList<List<PNodeEnd>> linkedList = new LinkedList<List<PNodeEnd>>();
        LinkedList<PNodeEnd> linkedList2 = new LinkedList<PNodeEnd>(list);
        IdentityHashMap<PNodeEnd, Boolean> identityHashMap = new IdentityHashMap<PNodeEnd, Boolean>();
        long l = 0L;
        this.sortByEst(linkedList2);
        while (!linkedList2.isEmpty()) {
            PNodeEnd pNodeEnd2;
            long l2;
            long l3 = ((PNodeEnd)linkedList2.get(0)).getMinTime();
            LinkedList<PNodeEnd> linkedList3 = new LinkedList<PNodeEnd>();
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext() && (l2 = (pNodeEnd2 = (PNodeEnd)iterator.next()).getMinTime()) <= l3) {
                if (l2 == l3) {
                    if (!this.isReadyByLinks(pNodeEnd2, identityHashMap)) continue;
                    ++l;
                    linkedList3.add(pNodeEnd2);
                    iterator.remove();
                    continue;
                }
                throw new ConsistencyException("Unexpected t < now", pNodeEnd2);
            }
            if (linkedList3.isEmpty()) {
                throw new ConsistencyException("Couldn't find any ready node-end among ", linkedList2);
            }
            linkedList.add(linkedList3);
            for (PNodeEnd pNodeEnd2 : linkedList3) {
                identityHashMap.put(pNodeEnd2, Boolean.TRUE);
            }
        }
        Debug.expect(l == (long)list.size(), "lost some node-ends");
        return linkedList;
    }

    private boolean isReadyByLinks(PNodeEnd pNodeEnd, Map map) {
        for (Object e : pNodeEnd.getPredecessors()) {
            if (map.get(e) == Boolean.TRUE) continue;
            return false;
        }
        return true;
    }

    protected void sortByEst(List<PNodeEnd> list) {
        Collections.sort(list, new Comparator<PNodeEnd>(){

            @Override
            public int compare(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
                return Long.signum(pNodeEnd.getMinTime() - pNodeEnd2.getMinTime());
            }
        });
    }

    public static void main(String[] stringArray) {
        Debug.off();
        PlainIp2 plainIp2 = new PlainIp2();
        plainIp2.mainStartup(stringArray);
        Debug.on = true;
        List<PNodeEnd> list = plainIp2.getIp2ModelManager().getNodeEnds();
        List<List<PNodeEnd>> list2 = new ExecutionStages(list).getStages();
        for (List<PNodeEnd> list3 : list2) {
            for (PNodeEnd pNodeEnd : list3) {
                System.out.println(pNodeEnd.getMinTime() + " " + pNodeEnd);
            }
            System.out.println("-----");
        }
    }
}

