/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.ConstraintManager;
import ix.icore.ConstraintManagerRegistry;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.End;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.util.Debug;
import ix.util.FailureException;
import ix.util.Util;
import ix.util.context.ContextHashMap;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import java.util.HashMap;
import java.util.Map;

public class Scrum
implements ConstraintManager {
    private static final Symbol CONSUME = Symbol.intern("consume");
    private static final Symbol OVERALL = Symbol.intern("overall");
    Map<LList, ContextHashMap> resourceTable = new HashMap<LList, ContextHashMap>();

    public void registerWith(ConstraintManagerRegistry constraintManagerRegistry) {
        constraintManagerRegistry.addConstraintManager(this, Symbol.intern("resource"), new Symbol[]{CONSUME, OVERALL});
    }

    public void reset() {
        this.resourceTable.clear();
    }

    public void clear() {
        for (ContextHashMap contextHashMap : this.resourceTable.values()) {
            contextHashMap.clear();
        }
    }

    public boolean mightInteract(Constraint constraint, Constraint constraint2) {
        return false;
    }

    public void addConstraint(Constraint constraint) {
        throw new UnsupportedOperationException("Method addConstraint(Constraint) is not supported by this CM.");
    }

    public void addConstraint(PNode pNode, Constraint constraint) {
        Debug.noteln("SCRUM adding", (Object)constraint);
        Debug.noteln("At", (Object)pNode);
    }

    protected void evalConstraint(PNode pNode, Constraint constraint) {
        constraint = (Constraint)Variable.removeAllVars(constraint);
        Symbol symbol = constraint.getRelation();
        LList lList = constraint.getPattern();
        Long l = Util.mustBe(Long.class, constraint.getValue());
        long l2 = l;
        ContextHashMap contextHashMap = this.getAvailabilityMap(lList);
        if (symbol == CONSUME) {
            this.consume(contextHashMap, lList, pNode, l2);
        } else if (symbol == OVERALL) {
            this.consume(contextHashMap, lList, pNode, l2);
            contextHashMap.put(pNode, new Long(l2));
        } else {
            Debug.warn("Invalid constraint: " + constraint);
        }
    }

    public void evalAtBegin(PNodeEnd pNodeEnd, Constraint constraint) {
        Debug.noteln("SCRUM eval " + constraint + " at " + pNodeEnd);
        Debug.expectSame(End.BEGIN, pNodeEnd.getEnd());
        this.evalConstraint(pNodeEnd.getNode(), constraint);
    }

    public void evalAtEnd(PNodeEnd pNodeEnd, Constraint constraint) {
        Debug.noteln("SCRUM eval " + constraint + " at " + pNodeEnd);
        Debug.expectSame(End.END, pNodeEnd.getEnd());
    }

    protected ContextHashMap getAvailabilityMap(LList lList) {
        ContextHashMap contextHashMap = this.resourceTable.get(lList);
        if (contextHashMap == null) {
            contextHashMap = new ContextHashMap();
            this.resourceTable.put(lList, contextHashMap);
        }
        return contextHashMap;
    }

    protected void consume(ContextHashMap contextHashMap, LList lList, PNode pNode, long l) {
        for (PNode pNode2 = pNode; pNode2 != null; pNode2 = pNode2.getParentPNode()) {
            Long l2 = (Long)contextHashMap.get(pNode2);
            if (l2 == null) continue;
            long l3 = l2;
            Debug.noteln("SCRUM: Consuming " + l + " at " + pNode2 + " for " + pNode + ", leaving " + (l3 -= l));
            if (l3 >= 0L) {
                contextHashMap.put(pNode2, new Long(l3));
                return;
            }
            throw new FailureException("Less than " + l + " " + lList + " available to " + pNode);
        }
    }
}

