/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.Report;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.YesNo;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.event.AgendaItemAdapter;
import ix.ip2.event.AgendaItemEvent;
import ix.util.Debug;
import ix.util.DeepCopier;
import ix.util.IPC;
import ix.util.Name;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.Matcher;
import ix.util.reflect.ClassDescr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class QueryHandler
extends ActivityHandler {
    static final Symbol S_QUERY = Symbol.intern("query");
    static final Symbol S_ANSWER = Symbol.intern("answer");
    static final Object QUERY_BY_KEY = Symbol.intern("query by");
    static final Object QUERY_REF_KEY = Symbol.intern("query ref");
    static final Object ANSWER_KEY = Symbol.intern("query answer");

    public QueryHandler() {
        super("Query agent");
    }

    public List getSyntaxList() {
        return (LList)Lisp.readFromString("((query ?agent-name ?pattern-element ...))");
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        LList lList = agendaItem.getPattern();
        return lList.length() >= 3 && lList.get(0) == S_QUERY;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new QueryAction(agendaItem));
    }

    public static class AnswerHandler
    extends ActivityHandler {
        public AnswerHandler() {
            super("Answer query");
        }

        public List getSyntaxList() {
            return (LList)Lisp.readFromString("((answer ?agent-name ?query-pattern))");
        }

        public boolean appliesTo(AgendaItem agendaItem) {
            LList lList = agendaItem.getPattern();
            return lList.length() == 2 && lList.get(0) == S_ANSWER && agendaItem.getAbout().getReportBack() == YesNo.YES;
        }

        public void addHandlerActions(AgendaItem agendaItem) {
            TaskItem taskItem = agendaItem.getAbout();
            String string = (String)taskItem.getAnnotation(QUERY_BY_KEY);
            Name name = (Name)taskItem.getAnnotation(QUERY_REF_KEY);
            agendaItem.addAction(new AnswerAction(string, name, agendaItem));
        }

        static class AnswerAction
        extends HandlerAction {
            String toName;
            Name toRef;
            AgendaItem item;
            LList queryPattern;

            AnswerAction(String string, Name name, AgendaItem agendaItem) {
                this.toName = string;
                this.toRef = name;
                this.item = agendaItem;
                this.queryPattern = (LList)agendaItem.getPattern().get(1);
                this.shortDescription = "Send answer to " + string;
            }

            public void handle(AgendaItem agendaItem) {
                Debug.expect(agendaItem == this.item);
                Object object = IXAgent.getAgent().getAgentIPCName();
                TaskItem taskItem = agendaItem.getAbout();
                Report report = new Report("Answer to query");
                report.setSenderId(Name.valueOf(object));
                report.setAnnotation(ANSWER_KEY, Variable.removeVars(this.queryPattern));
                report.setRef(this.toRef);
                IPC.sendObject(this.toName, report);
                agendaItem.setStatus(Status.COMPLETE);
            }
        }
    }

    static class AnswerListener
    extends AgendaItemAdapter {
        AnswerListener() {
        }

        public void newReport(AgendaItemEvent agendaItemEvent, Report report) {
            AgendaItem agendaItem = (AgendaItem)agendaItemEvent.getSource();
            LList lList = agendaItem.getPattern().drop(2);
            List list = (List)report.getAnnotation(ANSWER_KEY);
            if (list == null) {
                return;
            }
            LList lList2 = (LList)new DeepCopier(){

                public Object mapList(List list, ClassDescr classDescr) {
                    return LList.newLList((List)super.mapList(list, classDescr));
                }
            }.copy(list);
            Debug.noteln("Have answer", (Object)lList2);
            MatchEnv matchEnv = Matcher.match(lList2, lList);
            if (matchEnv == null) {
                Debug.noteln("Answer " + lList2 + " does not match query " + lList);
                JOptionPane.showMessageDialog(null, new String[]{"Answer does not match query", "Query: " + lList, "Answer: " + lList2}, "Warning", 0);
                agendaItem.setStatus(Status.IMPOSSIBLE);
                return;
            }
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : matchEnv.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(k instanceof Variable) || v instanceof ItemVar) continue;
                hashMap.put(k, v);
            }
            if (!hashMap.isEmpty()) {
                Debug.noteln("New bindings", hashMap);
                Ip2 ip2 = (Ip2)IXAgent.getAgent();
                ip2.getModelManager().bindVariables(hashMap);
            }
        }
    }

    static class QueryAction
    extends HandlerAction {
        AgendaItem item;

        QueryAction(AgendaItem agendaItem) {
            this.item = agendaItem;
            this.shortDescription = "Send Query";
        }

        public boolean isReady() {
            return Variable.isFullyBound(this.getToName());
        }

        private Object getToName() {
            return this.item.getPattern().get(1);
        }

        private LList getQueryPattern() {
            return this.item.getPattern().drop(2);
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(agendaItem == this.item);
            Object object = IXAgent.getAgent().getAgentIPCName();
            String string = Variable.removeVars(this.getToName()).toString();
            LList lList = this.getQueryPattern();
            agendaItem.addItemListener(new AnswerListener());
            agendaItem.getAbout().ensureId();
            Activity activity = new Activity(Lisp.list(S_ANSWER, lList));
            activity.setPattern((LList)Variable.removeVars(activity.getPattern()));
            activity.setSenderId(Name.valueOf(object));
            activity.setReportBack(YesNo.YES);
            activity.setRef(agendaItem.getAbout().getId());
            activity.setAnnotation(QUERY_BY_KEY, object);
            activity.setAnnotation(QUERY_REF_KEY, agendaItem.getAbout().getId());
            IPC.sendObject(string, activity);
            agendaItem.setStatus(Status.EXECUTING);
        }
    }
}

