/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.ichat.ChatMessage;
import ix.icore.Activity;
import ix.icore.Issue;
import ix.icore.Report;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.plan.DomainAsPlan;
import ix.icore.plan.Plan;
import ix.icore.plan.PlanAsDomain;
import ix.icore.plan.PlanVariable;
import ix.iface.domain.ChecklistParser;
import ix.iface.domain.LTF_Parser;
import ix.iface.domain.LTF_Writer;
import ix.iface.domain.TF_Writer;
import ix.iface.plan.HtmlPlanWriter;
import ix.iface.plan.InitLoader;
import ix.iface.plan.InitSaver;
import ix.iface.plan.TextPlanWriter;
import ix.iface.util.CatchingActionListener;
import ix.ip2.Ip2;
import ix.ip2.test.TestItem;
import ix.iscript.And;
import ix.iscript.Assignment;
import ix.iscript.Binding;
import ix.iscript.Call;
import ix.iscript.Expression;
import ix.iscript.IScriptLispSource;
import ix.iscript.IScriptSource;
import ix.iscript.IScriptXmlSource;
import ix.iscript.If;
import ix.iscript.Lambda;
import ix.iscript.Let;
import ix.iscript.Literal;
import ix.iscript.Or;
import ix.iscript.Sequence;
import ix.iscript.VarRef;
import ix.iscript.While;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Util;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.reflect.ClassFinder;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.DashSyntaxClassFinder;
import ix.util.xml.AbstractFileSyntax;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.LiteralDocument;
import ix.util.xml.Loader;
import ix.util.xml.Saver;
import ix.util.xml.XMLConfig;
import ix.util.xml.XMLTranslator;
import ix.util.xml.XMLTreeEditFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class Ip2XMLConfig
extends XMLConfig {
    protected final Class[] ixDomainClasses = new Class[]{Domain.class};
    protected final Class[] ixPlanClasses = new Class[]{Plan.class, PlanVariable.class};
    protected final Class[] basicIXClasses = new Class[]{Issue.class, Activity.class, Constraint.class, Ordering.class, PatternAssignment.class, ItemVar.class, Report.class, ChatMessage.class, LiteralDocument.class};
    protected final Class[] atomicClasses = new Class[]{Symbol.class, String.class, Integer.class, Long.class, Float.class, Double.class};
    protected final Class[] ixIScriptClasses = new Class[]{And.class, Assignment.class, Binding.class, Call.class, Expression.class, IScriptSource.class, IScriptXmlSource.class, IScriptLispSource.class, If.class, Lambda.class, Let.class, Literal.class, Or.class, Sequence.class, VarRef.class, While.class};

    public Ip2XMLConfig() {
        this.setHomeNamespaceURI("http://www.aiai.ed.ac.uk/project/ix/");
    }

    public ClassFinder makeClassFinder() {
        return new DashSyntaxClassFinder();
    }

    public XMLTranslator makeXMLTranslator(ClassSyntax classSyntax) {
        XMLTranslator xMLTranslator = new XMLTranslator(classSyntax);
        xMLTranslator.setOmitImplAttributes(true);
        return xMLTranslator;
    }

    public FileSyntaxManager makeFileSyntaxManager() {
        FileSyntaxManager fileSyntaxManager = new FileSyntaxManager();
        fileSyntaxManager.addSyntax(new LTFFiles());
        fileSyntaxManager.addSyntax(new TFFiles());
        fileSyntaxManager.addSyntax(new ChecklistFiles());
        fileSyntaxManager.addSyntax(new InitFiles());
        fileSyntaxManager.addSyntax(new LPADFiles());
        fileSyntaxManager.addSyntax(new TextFiles());
        fileSyntaxManager.addSyntax(new OwlSFiles());
        return fileSyntaxManager;
    }

    protected void makeDefaultInstances() {
        super.makeDefaultInstances();
        this.addInitialImports();
    }

    protected void addInitialImports() {
        ClassFinder classFinder = this.defaultClassFinder;
        classFinder.addImport("ix.icore.*");
        classFinder.addImport("ix.icore.domain.*");
        classFinder.addImport("ix.icore.plan.*");
        classFinder.addImport("ix.icore.log.*");
        classFinder.addImport("ix.ichat.ChatMessage");
        classFinder.addImport("ix.ip2.test.*");
        classFinder.addImport("ix.ip2.log.*");
        classFinder.addImport("ix.ip2.ObjectView");
        classFinder.addImport("ix.ip2.ObjectViewProperty");
        classFinder.addImport("ix.ip2.ObjectViewProperty$Syntax");
        classFinder.addImport("ix.iplan.PlanTest");
        classFinder.addImport("ix.iplan.PlanTestDefaults");
        classFinder.addImport("ix.iplan.PlanTestGroup");
        classFinder.addImport("ix.iplan.ExpandPlanTestGroup");
        classFinder.addImport("ix.util.xml.LiteralDocument");
        classFinder.addImport("ix.util.Name");
        classFinder.addImport("ix.util.Duration");
        classFinder.addImport("ix.util.lisp.*");
        classFinder.addImport("ix.iscript.*");
        classFinder.addImport("ix.test.xml.*");
        classFinder.addImport("java.awt.Color");
        classFinder.addImport("ix.iview.igraph.NodePosition");
    }

    public Class[] treeEditorTemplateClassRoots() {
        return new Class[]{Activity.class, Issue.class, Report.class, ChatMessage.class, Domain.class, PatternAssignment.class, Plan.class, TestItem.class};
    }

    public JMenu makeTreeEditorLookAtMenu(XMLTreeEditFrame xMLTreeEditFrame) {
        JMenu jMenu = new JMenu("Look At");
        jMenu.add(new LookItem(xMLTreeEditFrame, "Domain"){

            Object getObject() {
                return this.ip2.getDomain();
            }
        });
        jMenu.add(new LookItem(xMLTreeEditFrame, "Plan"){

            Object getObject() {
                return this.ip2.getPlan();
            }
        });
        return jMenu;
    }

    public List xmlSyntaxClasses(ClassSyntax classSyntax, Class clazz) {
        if (clazz == Object.class) {
            return this.ixClasses(classSyntax);
        }
        if (Plan.class.isAssignableFrom(clazz)) {
            return this.planClasses(classSyntax, clazz);
        }
        if ("ix.iscript".equals(clazz.getPackage().getName())) {
            return classSyntax.relevantClasses(Arrays.asList(this.ixIScriptClasses));
        }
        return classSyntax.relevantClasses(clazz);
    }

    protected List planClasses(ClassSyntax classSyntax, Class clazz) {
        List list = classSyntax.relevantClasses(new Class[]{clazz, PlanVariable.class, Constraint.class, Ordering.class, LiteralDocument.class});
        return (List)Collect.union(list, Arrays.asList(this.atomicClasses));
    }

    protected List ixClasses(ClassSyntax classSyntax) {
        Class[] classArray = (Class[])Util.appendArrays(new Object[]{this.basicIXClasses, this.atomicClasses, this.ixDomainClasses, this.ixPlanClasses});
        return classSyntax.expandRelevantClasses(Arrays.asList(classArray));
    }

    abstract class LookItem
    extends JMenuItem
    implements ActionListener {
        XMLTreeEditFrame frame;
        Ip2 ip2;

        LookItem(XMLTreeEditFrame xMLTreeEditFrame, String string) {
            super(string);
            this.frame = xMLTreeEditFrame;
            this.ip2 = (Ip2)xMLTreeEditFrame.getAgent();
            this.addActionListener(CatchingActionListener.listener(this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Debug.noteln("LookItem command", (Object)actionEvent.getActionCommand());
            this.frame.editObject(this.getObject());
        }

        abstract Object getObject();
    }

    public static class OwlSFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("owls");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "OWL-S files";
        }

        public boolean isAvailable() {
            return this.existsClass("ix.util.owls.OwlSTranslator") && this.existsClass("org.mindswap.owls.service.Service");
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return false;
        }

        public List readableClasses() {
            return Collections.singletonList(Domain.class);
        }

        public List writableClasses() {
            return Collections.singletonList(Plan.class);
        }

        public Object readObject(URL uRL) throws IOException {
            Loader loader = (Loader)this.getTranslator();
            return loader.readObject(uRL);
        }

        public void writeObject(Object object, File file) throws IOException {
            Saver saver = (Saver)this.getTranslator();
            saver.writeObject(object, file);
        }

        protected Object getTranslator() {
            return this.makeInstance("ix.util.owls.OwlSTranslator");
        }
    }

    public static class TextFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("txt");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "Text descriptions of plans";
        }

        public boolean canWrite() {
            return true;
        }

        public List writableClasses() {
            return Collections.singletonList(Plan.class);
        }

        public void writeObject(Object object, File file) throws IOException {
            new TextPlanWriter(file).writePlan((Plan)object);
        }
    }

    public static class HtmlFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("html");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "HTML descriptions of plans";
        }

        public boolean canWrite() {
            return true;
        }

        public List writableClasses() {
            return Collections.singletonList(Plan.class);
        }

        public void writeObject(Object object, File file) throws IOException {
            new HtmlPlanWriter(file).writePlan((Plan)object);
        }
    }

    public static class LPADFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("lpad");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "Plans represented as LTF domains";
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }

        public List readableClasses() {
            return Collections.singletonList(Plan.class);
        }

        public List writableClasses() {
            return Collections.singletonList(Plan.class);
        }

        public Object readObject(URL uRL) throws IOException {
            Domain domain = new LTF_Parser(uRL).readDomain();
            return new DomainAsPlan(domain);
        }

        public void writeObject(Object object, File file) throws IOException {
            PlanAsDomain planAsDomain = new PlanAsDomain((Plan)object);
            new LTF_Writer(file).writeDomain(planAsDomain);
        }
    }

    public static class InitFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("init");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "Initial world-state files";
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }

        public List readableClasses() {
            return Collections.singletonList(Plan.class);
        }

        public List writableClasses() {
            return Collections.singletonList(Plan.class);
        }

        public Object readObject(URL uRL) throws IOException {
            return new InitLoader().readInit(uRL);
        }

        public void writeObject(Object object, File file) throws IOException {
            new InitSaver().savePlan((Plan)object, file);
        }
    }

    public static class ChecklistFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("checklist");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "Checklist files as domains";
        }

        public boolean canRead() {
            return true;
        }

        public List readableClasses() {
            return Collections.singletonList(Domain.class);
        }

        public Object readObject(URL uRL) throws IOException {
            return new ChecklistParser(uRL).readDomain();
        }
    }

    public static class TFFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("tf");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "O-Plan TF files";
        }

        public boolean canWrite() {
            return true;
        }

        public List writableClasses() {
            return Collections.singletonList(Domain.class);
        }

        public void writeObject(Object object, File file) throws IOException {
            new TF_Writer(file).writeDomain((Domain)object);
        }
    }

    public static class LTFFiles
    extends AbstractFileSyntax {
        private List types = Lisp.list("lsp", "ltf");

        public List getFileTypes() {
            return this.types;
        }

        public String getFileTypeDescription() {
            return "List-TF files";
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }

        public List readableClasses() {
            return Collections.singletonList(Domain.class);
        }

        public List writableClasses() {
            return Collections.singletonList(Domain.class);
        }

        public Object readObject(URL uRL) throws IOException {
            return new LTF_Parser(uRL).readDomain();
        }

        public void writeObject(Object object, File file) throws IOException {
            new LTF_Writer(file).writeDomain((Domain)object);
        }
    }
}

