/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.IXAgentExtension;
import ix.iface.util.IFUtil;
import ix.iface.util.ToolController;
import ix.ip2.Ip2;
import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.Strings;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class FrameSnapshotExtension
implements IXAgentExtension {
    private String imageDirectory = "/tmp";
    private String imageType = "png";
    private Ip2 ip2;

    public FrameSnapshotExtension(Ip2 ip2) {
        this.ip2 = ip2;
    }

    public void installExtension() {
        this.ip2.addTool(new ToolController("Snapshot Tool"){

            public Object createTool() {
                return new SnapshotTool();
            }
        });
    }

    private void snapAllFrames() {
        for (Frame frame : Frame.getFrames()) {
            if (!this.isSnappable(frame)) continue;
            this.savePicture((JFrame)frame);
        }
    }

    private boolean isSnappable(Frame frame) {
        return frame instanceof JFrame && frame.isVisible() && !(frame instanceof SnapshotTool.SnapFrame);
    }

    private void savePicture(JFrame jFrame) {
        BufferedImage bufferedImage = this.takePicture(jFrame);
        this.writeImageFile(bufferedImage, this.imagePathname(jFrame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage takePicture(JFrame jFrame) {
        Container container = jFrame.getContentPane();
        BufferedImage bufferedImage = new BufferedImage(container.getWidth(), container.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            container.paintAll(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    private void writeImageFile(BufferedImage bufferedImage, String string) {
        Debug.noteln("Writing", (Object)string);
        try {
            ImageIO.write((RenderedImage)bufferedImage, this.imageType, new File(string));
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
    }

    private String imagePathname(Frame frame) {
        String string = System.getProperty("file.separator");
        return this.imageDirectory + string + this.fileName(frame) + ".png";
    }

    private String fileName(Frame frame) {
        return Strings.replace(" ", "-", frame.getTitle());
    }

    protected class SnapshotTool {
        private JFrame frame = new SnapFrame();

        public SnapshotTool() {
            this.frame.getContentPane().add(IFUtil.makeButton("Snap", new SnapListener()));
            this.frame.pack();
        }

        public void setVisible(boolean bl) {
            this.frame.setVisible(bl);
        }

        private class SnapListener
        implements ActionListener {
            private SnapListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                FrameSnapshotExtension.this.snapAllFrames();
            }
        }

        private class SnapFrame
        extends JFrame {
            private SnapFrame() {
                super(FrameSnapshotExtension.this.ip2.getAgentDisplayName() + " Snap");
            }
        }
    }
}

