/*
 * Decompiled with CFR 0.152.
 */
package ix.ip2;

import ix.icore.Priority;
import ix.icore.Report;
import ix.icore.Status;
import ix.icore.domain.Refinement;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.GridColumn;
import ix.iface.util.PriorityComboBox;
import ix.ip2.AbstractAgendaItemPopupMenu;
import ix.ip2.AgendaItem;
import ix.ip2.AgendaManager;
import ix.ip2.AgendaViewer;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.ItemEditor;
import ix.ip2.event.AgendaEvent;
import ix.ip2.event.AgendaItemEvent;
import ix.ip2.event.AgendaItemListener;
import ix.ip2.event.AgendaListener;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.TwoKeyHashMap;
import ix.util.Util;
import ix.util.lisp.LList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public abstract class AgendaViewTable
extends JPanel
implements AgendaViewer,
AgendaListener {
    protected Ip2 ip2;
    AgendaManager agendaManager;
    ItemEditor itemEditor;
    GridColumn descriptionCol = new GridColumn("Description");
    GridColumn commentsCol = new GridColumn("Annotations");
    GridColumn priorityCol = new GridColumn("Priority");
    GridColumn actionCol = new GridColumn("Action           ");
    final int descriptionWidth = Parameters.getInt("description-column-width", 30);
    final int commentsWidth = Parameters.getInt("annotations-column-width", 20);
    HashMap itemToRowMap = new HashMap();
    List rows = new LinkedList();
    TwoKeyHashMap actionShadowingTable = new TwoKeyHashMap();

    public AgendaViewTable(Ip2 ip2) {
        this.ip2 = ip2;
        this.setLayout(new BoxLayout(this, 0));
        this.descriptionCol.setPreferredSize(new JTextField("", this.descriptionWidth).getPreferredSize());
        this.commentsCol.setPreferredSize(new JTextField("", this.commentsWidth).getPreferredSize());
        this.priorityCol.setPreferredSize(new PriorityComboBox().getPreferredSize());
        this.add(this.descriptionCol);
        this.add(this.commentsCol);
        this.add(this.priorityCol);
        this.add(this.actionCol);
    }

    public void setAgendaManager(AgendaManager agendaManager) {
        this.agendaManager = agendaManager;
    }

    public void ensureItemEditor() {
        if (this.itemEditor == null) {
            this.itemEditor = this.makeItemEditor();
        }
        this.itemEditor.setVisible(true);
    }

    protected abstract ItemEditor makeItemEditor();

    public synchronized void reset() {
        this.actionShadowingTable.clear();
        this.itemToRowMap.clear();
        this.rows.clear();
        this.clearTable();
        this.invalidate();
    }

    public synchronized void clearTable() {
        Debug.noteln("Clearing item viewing table");
        this.descriptionCol.reset();
        this.commentsCol.reset();
        this.priorityCol.reset();
        this.actionCol.reset();
    }

    public synchronized void redisplay() {
        this.clearTable();
        this.restoreTable();
        this.invalidate();
        SwingUtilities.getRoot(this).validate();
    }

    public void restoreTable() {
        Debug.noteln("Restoring item viewing table");
        for (Row row : this.rows) {
            if (row.item.getLevel() != 0) continue;
            row.simplyAddToTable();
            if (!row.open) continue;
            this.restoreSubtree(row.item);
        }
    }

    protected void restoreSubtree(AgendaItem agendaItem) {
        for (AgendaItem agendaItem2 : agendaItem.getChildren()) {
            Row row = (Row)this.itemToRowMap.get(agendaItem2);
            row.simplyAddToTable();
            if (!row.open) continue;
            this.restoreSubtree(agendaItem2);
        }
    }

    protected HandlerAction findHandlerAction(AgendaItem agendaItem, String string) {
        String string2 = string;
        HandlerAction handlerAction = (HandlerAction)this.actionShadowingTable.get(agendaItem, string2);
        return handlerAction != null ? handlerAction : agendaItem.findAction(string2);
    }

    protected void setShadowingAction(AgendaItem agendaItem, String string, HandlerAction handlerAction) {
        this.actionShadowingTable.put(agendaItem, string, handlerAction);
    }

    protected String actionChoiceDescr(HandlerAction handlerAction) {
        String string = handlerAction.getActionDescription();
        return string;
    }

    public void getNewItemFromUser() {
        this.ensureItemEditor();
        this.itemEditor.showNewItem();
    }

    public AgendaItem makeItem(LList lList) {
        return this.agendaManager.makeItem(lList);
    }

    public void addItem(AgendaItem agendaItem) {
        this.agendaManager.addItem(agendaItem);
    }

    public void saveExpansion(Refinement refinement) {
        this.ip2.frame.getDomainEditor().saveExpansion(refinement);
    }

    public void expandItem(AgendaItem agendaItem, Refinement refinement) {
        this.agendaManager.expandItem(agendaItem, refinement);
    }

    public void itemAdded(AgendaEvent agendaEvent, AgendaItem agendaItem) {
        this.itemAdded(agendaItem);
    }

    public synchronized void itemAdded(AgendaItem agendaItem) {
        Debug.noteln("Viewer adding item", (Object)agendaItem);
        Row row = new Row(agendaItem);
        row.addToTable();
        this.adjustSizes();
    }

    protected void adjustSizes() {
        Component component = SwingUtilities.getRoot(this);
        if (component == null) {
            Debug.noteln("Tried to adjust sizes without root frame");
            return;
        }
        JFrame jFrame = (JFrame)component;
        jFrame.validate();
    }

    public void itemRemoved(AgendaEvent agendaEvent, AgendaItem agendaItem) {
        Debug.noteln("Viewer removing item", (Object)agendaItem);
        if (agendaItem.getParent() != null) {
            throw new RuntimeException("Attempt to remove AgendaViewTable item with children " + agendaItem);
        }
        Row row = (Row)this.itemToRowMap.get(agendaItem);
        this.rows.remove(row);
        this.itemToRowMap.remove(agendaItem);
        this.redisplay();
    }

    public void itemHandled(AgendaEvent agendaEvent, AgendaItem agendaItem, HandlerAction handlerAction) {
        Row row = (Row)this.itemToRowMap.get(agendaItem);
        JComboBox jComboBox = row.actionChoice;
        String string = this.actionChoiceDescr(handlerAction);
        Debug.noteln("Item " + agendaItem + " handled by " + string);
        jComboBox.setEnabled(false);
        jComboBox.setSelectedItem(string);
    }

    public void newBindings(AgendaEvent agendaEvent, Map map) {
        Set set = map.keySet();
        for (Map.Entry entry : this.itemToRowMap.entrySet()) {
            AgendaItem agendaItem = (AgendaItem)entry.getKey();
            JTextField jTextField = ((Row)entry.getValue()).descriptionText;
            if (agendaItem.getPatternVars().isEmpty()) continue;
            jTextField.setText(Strings.repeat(agendaItem.getLevel(), "     ") + agendaItem.getShortDescription());
        }
    }

    ActionListener makeActionChoiceListener(final AgendaItem agendaItem) {
        return new ActionListener(){
            JComboBox cb;

            public void actionPerformed(ActionEvent actionEvent) {
                this.cb = (JComboBox)actionEvent.getSource();
                String string = (String)this.cb.getSelectedItem();
                Debug.noteln("Selected action", (Object)string);
                if (!this.cb.isEnabled()) {
                    Debug.noteln("Assuming handled elsewhere");
                    return;
                }
                HandlerAction handlerAction = AgendaViewTable.this.findHandlerAction(agendaItem, string);
                Debug.expect(handlerAction != null, "Can't find action", string);
                if (agendaItem.actionCanBeTakenNow(handlerAction)) {
                    this.handleItem(handlerAction);
                } else {
                    Debug.noteln("Ignoring action selection");
                    this.cb.setSelectedItem("   ");
                    JOptionPane.showMessageDialog(AgendaViewTable.this, new Object[]{"Action " + Strings.quote(handlerAction.getActionDescription()), "cannot be taken at this time."}, "Action not ready", 1);
                }
            }

            void handleItem(HandlerAction handlerAction) {
                try {
                    AgendaViewTable.this.agendaManager.handleItem(agendaItem, handlerAction);
                }
                catch (Throwable throwable) {
                    Debug.noteln("Exception while handling item", (Object)agendaItem);
                    Debug.noteException(throwable);
                    JOptionPane.showMessageDialog(AgendaViewTable.this, new Object[]{"Problem while handling item", Debug.describeException(throwable)}, "Problem while handling item", 0);
                    this.cb.setSelectedItem("   ");
                }
            }
        };
    }

    ActionListener makePriorityChoiceListener(final AgendaItem agendaItem) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PriorityComboBox priorityComboBox = (PriorityComboBox)actionEvent.getSource();
                Priority priority = priorityComboBox.getSelectedPriority();
                Debug.noteln("Selected priority", (Object)priority);
                agendaItem.setPriority(priority);
            }
        };
    }

    MouseListener makeMouseListener(final AgendaItem agendaItem) {
        return new MouseAdapter(){
            ItemPopupMenu popup;
            {
                this.popup = new ItemPopupMenu(agendaItem);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                JTextField jTextField = (JTextField)mouseEvent.getComponent();
                Debug.noteln("User clicked on item", (Object)agendaItem.getShortDescription());
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    AgendaViewTable.this.ensureItemEditor();
                    AgendaViewTable.this.itemEditor.showItem(agendaItem);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                JTextField jTextField = (JTextField)mouseEvent.getComponent();
                Debug.noteln("User pressed on item", (Object)agendaItem.getShortDescription());
                Debug.noteln("event.isPopupTrigger()=" + mouseEvent.isPopupTrigger());
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    Debug.noteln("Right press");
                    this.popup.noticeItemState();
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
    }

    class ItemPopupMenu
    extends AbstractAgendaItemPopupMenu {
        ItemPopupMenu(AgendaItem agendaItem) {
            super(AgendaViewTable.this.ip2, agendaItem);
        }

        void showDetails() {
            AgendaViewTable.this.ensureItemEditor();
            AgendaViewTable.this.itemEditor.showItem(this.item);
        }

        boolean isOpen() {
            Row row = (Row)AgendaViewTable.this.itemToRowMap.get(this.item);
            return row.open;
        }

        void fold() {
            Row row = (Row)AgendaViewTable.this.itemToRowMap.get(this.item);
            row.open = false;
            AgendaViewTable.this.redisplay();
        }

        void unfold() {
            Row row = (Row)AgendaViewTable.this.itemToRowMap.get(this.item);
            row.open = true;
            AgendaViewTable.this.redisplay();
        }
    }

    public class ActionCellRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        AgendaItem item;

        ActionCellRenderer(AgendaItem agendaItem) {
            this.item = agendaItem;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            HandlerAction handlerAction = AgendaViewTable.this.findHandlerAction(this.item, (String)object);
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (!handlerAction.isReady()) {
                component.setForeground(Color.gray);
            }
            return component;
        }
    }

    class Row
    implements AgendaItemListener {
        AgendaItem item;
        boolean open = true;
        JTextField descriptionText;
        JTextField commentsText;
        PriorityComboBox priorityChoice;
        JComboBox actionChoice;

        Row(AgendaItem agendaItem) {
            this.item = agendaItem;
            this.setupRow();
        }

        void setupRow() {
            this.setupDescriptionText();
            this.setupCommentsText();
            this.setupPriorityChoice();
            this.setupActionChoice();
            this.item.addItemListener(this);
        }

        void setupDescriptionText() {
            this.descriptionText = new JTextField(Strings.repeat(this.item.getLevel(), "     ") + this.item.getShortDescription(), AgendaViewTable.this.descriptionWidth);
            this.descriptionText.setCaretPosition(0);
            this.descriptionText.setEditable(false);
            this.descriptionText.setBackground(Color.white);
            this.descriptionText.setBorder(BorderFactory.createEtchedBorder());
            this.descriptionText.addMouseListener(AgendaViewTable.this.makeMouseListener(this.item));
        }

        void setupCommentsText() {
            this.commentsText = new JTextField("", AgendaViewTable.this.commentsWidth);
            if (!this.item.getComments().equals("")) {
                this.commentsText.setText(Strings.firstLine(this.item.getComments()).trim());
            }
            this.commentsText.setEditable(false);
            this.commentsText.setBackground(Color.white);
            this.commentsText.setBorder(BorderFactory.createEtchedBorder());
            this.commentsText.addMouseListener(AgendaViewTable.this.makeMouseListener(this.item));
        }

        void setupPriorityChoice() {
            this.priorityChoice = new PriorityComboBox();
            this.priorityChoice.addActionListener(CatchingActionListener.listener(AgendaViewTable.this.makePriorityChoiceListener(this.item)));
            this.priorityChoice.setPriority(this.item.getPriority());
        }

        void setupActionChoice() {
            this.actionChoice = new JComboBox();
            for (HandlerAction handlerAction : this.item.getActions()) {
                this.actionChoice.addItem(AgendaViewTable.this.actionChoiceDescr(handlerAction));
            }
            this.actionChoice.addActionListener(CatchingActionListener.listener(AgendaViewTable.this.makeActionChoiceListener(this.item)));
            this.actionChoice.setRenderer(new ActionCellRenderer(this.item));
            this.actionChoice.setBackground(this.item.getStatus().getColor());
        }

        int getRowIndex() {
            return AgendaViewTable.this.descriptionCol.getRowIndex(this.descriptionText);
        }

        void simplyAddToTable() {
            AgendaViewTable.this.descriptionCol.add(this.descriptionText);
            AgendaViewTable.this.commentsCol.add(this.commentsText);
            AgendaViewTable.this.priorityCol.add(this.priorityChoice);
            AgendaViewTable.this.actionCol.add(this.actionChoice);
        }

        void addToTable() {
            if (this.item.getParent() == null) {
                this.simplyAddToTable();
            } else {
                Row row = (Row)AgendaViewTable.this.itemToRowMap.get(this.item.getParent());
                JTextField jTextField = row.descriptionText;
                Font font = jTextField.getFont();
                if (!font.isBold()) {
                    jTextField.setFont(font.deriveFont(1));
                }
                int n = row.getRowIndex();
                for (AgendaItem agendaItem : this.item.getParent().getChildren()) {
                    int n2;
                    Row row2 = (Row)AgendaViewTable.this.itemToRowMap.get(agendaItem);
                    if (row2 == null || (n2 = row2.getRowIndex()) <= n) continue;
                    n = n2;
                }
                AgendaViewTable.this.descriptionCol.add((Component)this.descriptionText, ++n);
                AgendaViewTable.this.commentsCol.add((Component)this.commentsText, n);
                AgendaViewTable.this.priorityCol.add((Component)this.priorityChoice, n);
                AgendaViewTable.this.actionCol.add((Component)this.actionChoice, n);
            }
            AgendaViewTable.this.itemToRowMap.put(this.item, this);
            AgendaViewTable.this.rows.add(this);
        }

        public void statusChanged(AgendaItemEvent agendaItemEvent) {
            Status status = this.item.getStatus();
            this.actionChoice.setBackground(status.getColor());
            if (status == Status.COMPLETE || status == Status.EXECUTING || status == Status.IMPOSSIBLE) {
                this.priorityChoice.setEnabled(false);
                this.actionChoice.setEnabled(false);
            }
        }

        public void priorityChanged(AgendaItemEvent agendaItemEvent) {
            Priority priority = this.item.getPriority();
            this.priorityChoice.setBackground(priority.getColor());
        }

        public void newReport(AgendaItemEvent agendaItemEvent, Report report) {
            this.commentsText.setText(Strings.firstLine(report.getText()).trim());
        }

        public void agendaItemEdited(AgendaItemEvent agendaItemEvent) {
            if (!(!this.item.getReports().isEmpty() || this.item.getComments().equals("") && this.commentsText.getText().equals(""))) {
                this.commentsText.setText(Strings.firstLine(this.item.getComments()).trim());
            }
        }

        public void handlerActionsChanged(AgendaItemEvent agendaItemEvent) {
            boolean bl = this.actionChoice.isEnabled();
            this.actionChoice.setEnabled(false);
            this.actionChoice.removeAllItems();
            for (HandlerAction handlerAction : this.item.getActions()) {
                this.actionChoice.addItem(AgendaViewTable.this.actionChoiceDescr(handlerAction));
            }
            this.actionChoice.setEnabled(bl);
        }

        public void newHandlerAction(AgendaItemEvent agendaItemEvent, HandlerAction handlerAction) {
            Status status = this.item.getStatus();
            if (status == Status.COMPLETE || status == Status.EXECUTING || status == Status.IMPOSSIBLE) {
                return;
            }
            Color color = this.descriptionText.getBackground();
            this.descriptionText.setBackground(Color.blue);
            String string = handlerAction.getActionDescription();
            String string2 = null;
            int n = this.actionChoice.getItemCount();
            for (int i = 0; i < n; ++i) {
                Object e = this.actionChoice.getItemAt(i);
                if (!e.equals(string)) continue;
                string2 = (String)e;
                break;
            }
            if (string2 != null) {
                if (this.shouldReplaceAction(string2)) {
                    AgendaViewTable.this.setShadowingAction(this.item, handlerAction.getActionDescription(), handlerAction);
                    Debug.expect(AgendaViewTable.this.findHandlerAction(this.item, string2) == handlerAction);
                } else {
                    Debug.expect(AgendaViewTable.this.findHandlerAction(this.item, string2) != handlerAction);
                }
            } else {
                this.actionChoice.addItem(AgendaViewTable.this.actionChoiceDescr(handlerAction));
                AgendaViewTable.this.adjustSizes();
            }
            this.descriptionText.setBackground(color);
        }

        boolean shouldReplaceAction(String string) {
            Object[] objectArray = new Object[]{"Replace existing action", "Ignore new action"};
            Object object = JOptionPane.showInputDialog(AgendaViewTable.this, new Object[]{"Item " + Util.quote(this.item.getShortDescription()), "Already has an action " + Util.quote(string)}, "New Action", 1, null, objectArray, objectArray[0]);
            return object.equals("Replace existing action");
        }
    }
}

