/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui.table;

import ix.iface.ui.util.UIUtil;
import ix.util.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractIXTableModel
extends AbstractTableModel {
    protected ArrayList columnFields = new ArrayList();
    protected ArrayList columnNames = new ArrayList();
    protected ArrayList columnClasses = new ArrayList();
    protected Class objectClass;
    protected boolean rowsMarkable = false;
    protected HashSet markedRows;
    protected List rows = new LinkedList();
    private HashSet markListeners = new HashSet();

    public AbstractIXTableModel(boolean bl) {
        this.rowsMarkable = bl;
        if (bl) {
            this.markedRows = new HashSet();
        }
    }

    public AbstractIXTableModel(boolean bl, Object[] objectArray) {
        this.rowsMarkable = bl;
        if (bl) {
            this.markedRows = new HashSet();
        }
        this.setData(objectArray);
    }

    public AbstractIXTableModel(boolean bl, Object[] objectArray, String[] stringArray) {
        this(bl, objectArray);
        this.setColumnNames(stringArray);
    }

    public AbstractIXTableModel(boolean bl, Class clazz, Object[] objectArray) {
        this(bl, objectArray);
        this.objectClass = clazz;
        this.deriveColumnFields();
    }

    public void setData(Object[] objectArray) {
        this.rows.clear();
        this.clearMarks();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.rows.add(objectArray[i]);
            }
        }
        this.fireTableDataChanged();
    }

    public List getData() {
        return this.rows;
    }

    public void addData(Object object) {
        if (!this.rows.contains(object)) {
            this.rows.add(object);
            this.fireTableDataChanged();
        }
    }

    public void addData(int n, Object object) {
        if (!this.rows.contains(object)) {
            this.rows.add(n, object);
            this.fireTableDataChanged();
        }
    }

    public void removeData(Object object) {
        int n = this.getObjectRow(object);
        this.unmarkRow(n);
        if (this.rows.remove(object)) {
            this.fireTableDataChanged();
        }
    }

    public void replaceData(Object object, Object object2) {
        int n = this.getObjectRow(object);
        if (0 <= n && n < this.getRowCount()) {
            boolean bl = this.isMarked(n);
            this.unmarkRow(n);
            this.rows.remove(object);
            if (this.rows.contains(object2)) {
                n = this.getObjectRow(object2);
            } else {
                this.rows.add(n, object2);
            }
            if (bl) {
                this.markRow(n);
            }
            this.fireTableDataChanged();
        }
    }

    public void clearData() {
        this.rows.clear();
        this.clearMarks();
        this.fireTableDataChanged();
    }

    public Object getRowObject(int n) {
        if (n < 0) {
            return null;
        }
        return this.rows.get(n);
    }

    public int getObjectRow(Object object) {
        if (object == null || this.rows == null) {
            return -1;
        }
        return this.rows.indexOf(object);
    }

    public Object getValueAt(int n, int n2) {
        Object e = this.rows.get(n);
        if (this.rowsMarkable) {
            if (n2 == 0) {
                return new Boolean(this.isMarked(n));
            }
            return this.getCellValueAt(e, n2 - 1);
        }
        return this.getCellValueAt(e, n2);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        String[] stringArray = this.getColumnNames();
        return stringArray.length;
    }

    public String getColumnName(int n) {
        String[] stringArray = this.getColumnNames();
        return stringArray[n];
    }

    public Class getColumnClass(int n) {
        Class<?> clazz = null;
        try {
            clazz = (Class<?>)this.columnClasses.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            clazz = super.getColumnClass(n);
        }
        return clazz;
    }

    public abstract Object getCellValueAt(Object var1, int var2);

    public boolean isCellEditable(int n, int n2) {
        if (this.rowsMarkable && n2 == 0) {
            return true;
        }
        return super.isCellEditable(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.rowsMarkable && n2 == 0) {
            if (((Boolean)object).booleanValue()) {
                this.markRow(n);
            } else {
                this.unmarkRow(n);
            }
        }
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = new ArrayList<String>(Arrays.asList(stringArray));
        if (this.rowsMarkable) {
            this.columnNames.add(0, "");
        }
    }

    public void setColumnClasses(Class[] classArray) {
        this.columnClasses = new ArrayList<Class>(Arrays.asList(classArray));
        if (this.rowsMarkable) {
            this.columnClasses.add(0, Boolean.class);
        }
    }

    protected String[] getColumnNames() {
        String[] stringArray = new String[]{};
        return this.columnNames.toArray(stringArray);
    }

    public void setColumnFields(Class clazz, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                Field field = clazz.getField(string);
                String string2 = UIUtil.toCapitalised(string);
                Class<?> clazz2 = field.getType();
                this.columnFields.add(string);
                this.columnNames.add(string2);
                this.columnClasses.add(clazz2);
                continue;
            }
            catch (Exception exception) {
                Debug.noteln("AIXTM: Problem setting column field " + string);
                Debug.noteException(exception);
            }
        }
        if (this.rowsMarkable) {
            this.columnFields.add(0, "rowMarked");
            this.columnClasses.add(0, Boolean.class);
            this.columnNames.add(0, "");
        }
    }

    public boolean isMarkable() {
        return this.rowsMarkable;
    }

    public void markRow(int n) {
        if (this.markedRows == null) {
            return;
        }
        Object object = this.getRowObject(n);
        this.markedRows.add(object);
        this.fireTableMarkAdded(object);
    }

    public void unmarkRow(int n) {
        if (this.markedRows == null) {
            return;
        }
        Object object = this.getRowObject(n);
        this.markedRows.remove(object);
        this.fireTableMarkRemoved(object);
    }

    public void clearMarks() {
        if (this.markedRows == null) {
            return;
        }
        this.markedRows.clear();
        this.fireTableMarkCleared();
    }

    public void markAll() {
        if (this.markedRows == null) {
            return;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.markedRows.add(this.getRowObject(i));
        }
        this.fireTableMarkedAll();
    }

    public boolean isMarked(int n) {
        if (this.markedRows == null) {
            return false;
        }
        return this.markedRows.contains(this.getRowObject(n));
    }

    public boolean isMarkedEmpty() {
        if (this.markedRows == null) {
            return true;
        }
        return this.markedRows.isEmpty();
    }

    public Collection getMarkedRows() {
        return null;
    }

    public Collection getMarkedObjects() {
        return this.markedRows;
    }

    public void addMarkListener(TableMarkListener tableMarkListener) {
        this.markListeners.add(tableMarkListener);
    }

    public void removeMarkListener(TableMarkListener tableMarkListener) {
        while (this.markListeners.contains(tableMarkListener)) {
            this.markListeners.remove(tableMarkListener);
        }
    }

    public void fireTableMarkAdded(Object object) {
        for (TableMarkListener tableMarkListener : this.markListeners) {
            tableMarkListener.tableMarkAdded(object);
        }
    }

    public void fireTableMarkRemoved(Object object) {
        for (TableMarkListener tableMarkListener : this.markListeners) {
            tableMarkListener.tableMarkRemoved(object);
        }
    }

    public void fireTableMarkCleared() {
        for (TableMarkListener tableMarkListener : this.markListeners) {
            tableMarkListener.tableMarkCleared();
        }
    }

    public void fireTableMarkedAll() {
        for (TableMarkListener tableMarkListener : this.markListeners) {
            tableMarkListener.tableMarkedAll();
        }
    }

    protected void deriveColumnFields() {
        if (this.objectClass == null) {
            return;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>(Arrays.asList(this.objectClass.getFields()));
        for (Field field : arrayList) {
            if (!AbstractIXTableModel.useField(field)) continue;
            this.columnFields.add(field.getName());
            this.columnNames.add(UIUtil.toCapitalised(field.getName()));
        }
        if (this.rowsMarkable) {
            this.columnFields.add(0, "rowMarked");
            this.columnClasses.add(0, Boolean.class);
            this.columnNames.add(0, "");
        }
    }

    private static boolean useField(Field field) {
        int n = field.getModifiers();
        return !Modifier.isStatic(n) && !Modifier.isPrivate(n) && !Modifier.isProtected(n);
    }

    protected void defaultSetColumnFields(String[] stringArray) {
        if (this.objectClass == null) {
            return;
        }
        this.columnFields.clear();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                this.objectClass.getField(string);
                this.columnFields.add(string);
                this.columnNames.add(UIUtil.toCapitalised(string));
                continue;
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                try {
                    String string2 = UIUtil.toUncapitalised(string);
                    this.objectClass.getField(string2);
                    this.columnFields.add(string2);
                    this.columnNames.add(string);
                    continue;
                }
                catch (Exception exception2) {
                    Debug.noteException(exception2);
                }
            }
        }
        if (this.rowsMarkable) {
            this.columnFields.add(0, "rowMarked");
            this.columnClasses.add(0, Boolean.class);
            this.columnNames.add(0, "");
        }
    }

    protected Object defaultGetCellValueAt(Object object, int n) {
        if (this.objectClass == null) {
            return null;
        }
        if (this.columnFields == null || this.columnFields.isEmpty()) {
            return null;
        }
        try {
            String string = (String)this.columnFields.get(n);
            Field field = this.objectClass.getField(string);
            return field.get(object);
        }
        catch (Exception exception) {
            Debug.note("Exception during defaultGetCellValueAt(" + object.toString() + ", " + n + ")");
            Debug.noteException(exception);
            return null;
        }
    }

    public static interface TableMarkListener {
        public void tableMarkAdded(Object var1);

        public void tableMarkRemoved(Object var1);

        public void tableMarkedAll();

        public void tableMarkCleared();
    }
}

