/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.iface.ui.IXButPanel;
import ix.iface.ui.ListEditorPanel;
import ix.util.Debug;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ToggleEditorPanel
extends ListEditorPanel
implements ActionListener,
ListSelectionListener,
MouseListener {
    private HashSet listeners = new HashSet();
    protected JToggleButton[] buttons;
    boolean isAdjusting = false;

    public ToggleEditorPanel() {
    }

    public ToggleEditorPanel(EventListener eventListener, String string, JToggleButton[] jToggleButtonArray) {
        this.setLabel(string);
        IXButPanel iXButPanel = this.makeButtonPanel(this, jToggleButtonArray);
        this.makePanelComponent(eventListener, iXButPanel);
        this.listen(eventListener);
    }

    private void listen(EventListener eventListener) {
        if (eventListener instanceof ListSelectionListener) {
            this.addListSelectionListener((ListSelectionListener)eventListener);
        }
    }

    public boolean isListItem() {
        return true;
    }

    protected IXButPanel makeButtonPanel(EventListener eventListener, JToggleButton[] jToggleButtonArray) {
        IXButPanel iXButPanel = new IXButPanel(eventListener, 0, jToggleButtonArray);
        this.buttons = jToggleButtonArray;
        iXButPanel.setPreferredSize(new Dimension(82 * jToggleButtonArray.length, 40));
        return iXButPanel;
    }

    public Object getData() {
        boolean[] blArray = new boolean[this.buttons.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            JToggleButton jToggleButton = this.buttons[i];
            blArray[i] = jToggleButton.isSelected();
        }
        return blArray;
    }

    public void setListData(boolean[] blArray) {
        if (blArray.length != this.buttons.length) {
            Debug.noteln("WARNING: different length arrays setting list data!");
        } else {
            this.isAdjusting = true;
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].setSelected(blArray[i]);
            }
            this.isAdjusting = false;
        }
    }

    public void setListData(Object[] objectArray) {
        if (objectArray.length != this.buttons.length) {
            Debug.noteln("WARNING: different length arrays setting list data!");
        } else {
            this.isAdjusting = true;
            for (int i = 0; i < this.buttons.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof Boolean) {
                    this.buttons[i].setSelected((Boolean)object);
                    continue;
                }
                Debug.noteln("TogEdP: got data of type", object.getClass());
            }
            this.isAdjusting = false;
        }
    }

    public void setData(Object object) {
        if (object instanceof Collection) {
            this.setListData(((Collection)object).toArray());
        } else if (object.getClass().isArray()) {
            this.setListData((Object[])object);
        } else {
            Debug.noteln("TogEdP: cannot set data of class", object.getClass());
        }
    }

    public void removeData() {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setSelected(false);
        }
    }

    public void setSelectedIndex(int n) {
        if (n < this.buttons.length) {
            this.buttons[n].setSelected(true);
        }
    }

    public int getSelectedIndex() {
        int n = -1;
        for (int i = 0; i < this.buttons.length && n < 0; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            n = i;
        }
        return n;
    }

    public void setSelectedObject(Object object) {
        String string = object.toString();
        if (string == "") {
            return;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!string.equals(this.buttons[i].getActionCommand()) && !string.equals(this.buttons[i].getText())) continue;
            this.buttons[i].setSelected(true);
            return;
        }
    }

    public Object getSelectedObject() {
        String string = "";
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            string = this.buttons[i].getActionCommand();
            if (string == "") {
                string = this.buttons[i].getText();
            }
            return string;
        }
        return string;
    }

    public boolean setRenderer(ListCellRenderer listCellRenderer) {
        return false;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null) {
            this.listeners.add(listSelectionListener);
        }
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null) {
            this.listeners.remove(listSelectionListener);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == null || this.isAdjusting) {
            return;
        }
        if (this.buttons.length > 0) {
            for (int i = 0; i < this.buttons.length; ++i) {
                if (!mouseEvent.getSource().equals(this.buttons[i])) continue;
                this.valueChanged(new ListSelectionEvent(mouseEvent.getSource(), 0, 0, false));
                return;
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isAdjusting) {
            return;
        }
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ListSelectionListener listSelectionListener : this.listeners) {
                listSelectionListener.valueChanged(listSelectionEvent);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isAdjusting) {
            return;
        }
        Debug.noteln("TogEdP: got action", (Object)actionEvent);
        if (actionEvent.getSource() != null && this.buttons.length > 0) {
            for (int i = 0; i < this.buttons.length; ++i) {
                if (!actionEvent.getSource().equals(this.buttons[i])) continue;
                this.valueChanged(new ListSelectionEvent(actionEvent.getSource(), 0, 0, false));
                return;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

