/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.ui;

import ix.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class JSelectorDialog
extends JDialog
implements MouseListener {
    protected JPanel mainPanel = new JPanel();
    protected Component bitsBox;
    protected Component butBox;
    protected JComponent focusComponent;
    protected JButton okBut = new JButton("Ok");
    protected JButton cancelBut = new JButton("Cancel");
    protected JLabel label;
    protected ArrayList selectionListeners = new ArrayList();
    public Object currentObject;

    public JSelectorDialog(Frame frame, String string, String string2) {
        super(frame, string, true);
        this.setSize(405, 175);
        this.mainPanel.setLayout(new BorderLayout());
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.setBounds(0, 0, 500, 300);
        this.bitsBox = this.makeBits();
        this.butBox = this.makeButs();
        if (!string2.equals("")) {
            this.label = new JLabel(string2);
            this.mainPanel.add((Component)this.label, "North");
        }
        this.mainPanel.add(this.bitsBox, "Center");
        this.mainPanel.add(new JSeparator());
        this.mainPanel.add(this.butBox, "South");
        this.focusComponent = this.getFocusComponent();
        this.invalidate();
        this.pack();
        this.setVisible(false);
    }

    public JSelectorDialog(Frame frame, String string) {
        this(frame, "Selector", string);
    }

    public JSelectorDialog(Frame frame, String string, String string2, Object object) {
        this(frame, string, string2);
        try {
            this.setObject(object);
        }
        catch (NullPointerException nullPointerException) {
            Debug.noteException(nullPointerException);
            JOptionPane.showMessageDialog(this, "Selector: Cannot set object");
            return;
        }
        this.pack();
        this.setVisible(false);
    }

    private Component makeButs() {
        this.okBut.addMouseListener(this);
        this.cancelBut.addMouseListener(this);
        Box box = new Box(0);
        box.add(Box.createGlue());
        box.add(this.okBut);
        box.add(this.cancelBut);
        box.add(Box.createGlue());
        return box;
    }

    public void setMessage(String string) {
        if (this.label != null) {
            this.label.setText(string);
        }
    }

    public void setObject(Object object) throws NullPointerException {
        if (object == null) {
            return;
        }
        this.currentObject = object;
        this.initFromObject();
    }

    protected JComponent getFocusComponent() {
        return null;
    }

    public void start(Point point) {
        this.setLocation(point);
        this.start();
    }

    public void start() {
        this.setVisible(true);
    }

    public void start(Object object, Point point) {
        this.setLocation(point);
        this.start(object);
    }

    public boolean start(Object object) {
        try {
            this.setObject(object);
            this.start();
            return true;
        }
        catch (NullPointerException nullPointerException) {
            Debug.noteException(nullPointerException);
            JOptionPane.showMessageDialog(this, "Selection Dialogue: Cannot start (problem in set object)");
            return false;
        }
    }

    public void addSelectionListener(JSelectorListener jSelectorListener) {
        this.selectionListeners.add(jSelectorListener);
    }

    public void removeSelectionListener(JSelectorListener jSelectorListener) {
        while (this.selectionListeners.contains(jSelectorListener)) {
            this.selectionListeners.remove(jSelectorListener);
        }
    }

    protected Object processSelection() {
        Object object = this.collectSelection();
        if (object == null) {
            return null;
        }
        Object object2 = this.checkSelection(object, this.currentObject);
        return object2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.cancelBut) {
            this.fireGotSelection(null);
            this.closeEditor();
            return;
        }
        if (mouseEvent.getSource() == this.okBut) {
            Object object = this.processSelection();
            if (object != null) {
                this.fireGotSelection(object);
                this.closeEditor();
            }
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void fireGotSelection(Object object) {
        if (this.selectionListeners == null) {
            return;
        }
        for (int i = 0; i < this.selectionListeners.size(); ++i) {
            JSelectorListener jSelectorListener = (JSelectorListener)this.selectionListeners.get(i);
            jSelectorListener.gotSelection(this, object, this.currentObject);
        }
    }

    public void closeEditor() {
        this.setVisible(false);
        this.currentObject = null;
    }

    protected abstract Component makeBits();

    protected abstract void initFromObject();

    protected abstract Object collectSelection();

    protected abstract Object checkSelection(Object var1, Object var2);

    public static interface JSelectorListener {
        public void gotSelection(JSelectorDialog var1, Object var2, Object var3);
    }
}

