/*
 * Decompiled with CFR 0.152.
 */
package ix.iface.domain;

import ix.icore.domain.Domain;
import ix.iface.domain.DomainParser;
import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.xml.FileSyntax;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.XML;
import ix.util.xml.XMLSaver;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class DomainWriter {
    public abstract void writeDomain(Domain var1) throws IOException;

    protected static DomainWriter makeWriter(File file) throws IOException {
        Object object;
        if (file.getParentFile() == null) {
            object = DomainParser.getLibraryDirectory();
            Debug.noteln("Resolving " + file + " against " + object);
            file = new File((File)object, file.getPath());
        }
        object = file.getName();
        FileSyntaxManager fileSyntaxManager = XML.fileSyntaxManager();
        FileSyntax fileSyntax = fileSyntaxManager.getSyntax(file);
        Debug.noteln("Using file syntax", (Object)fileSyntax);
        if (fileSyntaxManager.canWrite(fileSyntax, Domain.class)) {
            return new DomainWriterWrapper(file, fileSyntax);
        }
        throw new IOException("File " + file.getName() + " does not have a known type for domains");
    }

    public static File saveDomain(Component component, Domain domain) {
        File file;
        File file2;
        File file3 = DomainParser.getLibraryDirectory();
        do {
            if ((file = DomainWriter.chooseFileToWrite(component, file3)) != null) continue;
            return null;
        } while ((file2 = DomainWriter.saveDomain(component, domain, file)) == null);
        return file2;
    }

    public static File saveDomain(Component component, Domain domain, File file) {
        if (domain.getRefinements() == null || domain.getRefinements().isEmpty()) {
            switch (JOptionPane.showConfirmDialog(component, new String[]{"The domain does not contain any refinements.", "Are you sure you want to save it?"}, "Confirm", 0)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
            }
        }
        if (file.exists()) {
            switch (JOptionPane.showConfirmDialog(component, "Overwrite " + Strings.quote(file.getPath()), "Confirm", 0)) {
                case 0: {
                    Util.renameToBackup(file);
                    break;
                }
                case 1: {
                    return null;
                }
            }
        }
        Debug.noteln("Writing domain to", (Object)file);
        try {
            DomainWriter.makeWriter(file).writeDomain(domain);
            return file;
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            JOptionPane.showMessageDialog(component, new Object[]{"Problem saving " + Strings.quote(file.getPath()), Debug.foldException(throwable)}, "Trouble saving domain", 0);
            return null;
        }
    }

    private static File chooseFileToWrite(Component component, File file) {
        JFileChooser jFileChooser = new XMLSaver(null, Domain.class).makeFileChooser();
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    protected static class DomainWriterWrapper
    extends DomainWriter {
        protected File domainFile;
        protected FileSyntax syntax;

        protected DomainWriterWrapper(File file, FileSyntax fileSyntax) {
            this.domainFile = file;
            this.syntax = fileSyntax;
        }

        public void writeDomain(Domain domain) {
            try {
                this.syntax.writeObject(domain, this.domainFile);
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                throw new RethrownException(iOException, "Cannot write to " + this.domainFile + ": " + Debug.describeException(iOException));
            }
        }
    }
}

