/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.plan;

import ix.icore.Activity;
import ix.icore.domain.Domain;
import ix.icore.domain.LinkedListOfConstrainer;
import ix.icore.domain.ListOfConstrainer;
import ix.icore.domain.ListOfVariableDeclaration;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.domain.VariableDeclaration;
import ix.icore.plan.LinkedListOfPlanNode;
import ix.icore.plan.LinkedListOfPlanRefinement;
import ix.icore.plan.LinkedListOfPlanVariableDeclaration;
import ix.icore.plan.ListOfPlanNode;
import ix.icore.plan.ListOfPlanRefinement;
import ix.icore.plan.ListOfPlanVariableDeclaration;
import ix.icore.plan.Plan;
import ix.icore.plan.PlanNode;
import ix.icore.plan.PlanRefinement;
import ix.icore.plan.PlanVariable;
import ix.icore.plan.PlanVariableDeclaration;
import ix.icore.plan.VariableScope;
import ix.ip2.ActivityItem;
import ix.util.Debug;
import ix.util.Gensym;
import ix.util.Name;
import ix.util.ObjectWalker;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DomainAsPlan
extends Plan {
    static final Symbol EXPANDS = Symbol.intern("expands");
    static final Symbol WORLD_STATE = Symbol.intern("world-state");
    protected Map<Symbol, PlanVariable> nameToPlanVarMap = new HashMap<Symbol, PlanVariable>();
    protected Map<Name, NodeSpec> nodeIdToNodeSpecMap = new HashMap<Name, NodeSpec>();
    protected Map<Name, Refinement> nodeIdToRefinementMap = new HashMap<Name, Refinement>();
    protected Gensym.Generator nameGen = new Gensym.Generator();

    public DomainAsPlan() {
    }

    public DomainAsPlan(Domain domain) {
        Object object;
        new Pass1().walk(domain);
        this.fillNodeIdToRefinementMap(domain);
        Refinement refinement = domain.getNamedRefinement("plan-top-level");
        this.setPlanVariableDeclarations(this.makePlanVarDcls(refinement, VariableScope.GLOBAL));
        this.setPlanNodes(this.makePlanNodes(refinement));
        if (domain.getRefinements() != null) {
            object = new LinkedListOfPlanRefinement();
            for (Refinement refinement2 : domain.getRefinements()) {
                if (refinement2 == refinement) continue;
                object.add(this.makePlanRefinement(refinement2));
            }
            this.setPlanRefinements((ListOfPlanRefinement)object);
        }
        this.setConstraints(this.getConstrainers(refinement));
        object = (Map)refinement.getAnnotation(WORLD_STATE);
        if (object != null) {
            this.setWorldState(PatternAssignment.mapToAssignments((Map)object));
        }
    }

    void fillNodeIdToRefinementMap(Domain domain) {
        if (domain.getRefinements() == null) {
            return;
        }
        Refinement refinement = domain.getNamedRefinement("plan-top-level");
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (Refinement refinement2 : domain.getRefinements()) {
            if (refinement2 == refinement) continue;
            Object object = refinement2.getAnnotation(EXPANDS);
            if (object == null) {
                linkedList.add(refinement2.getName());
                continue;
            }
            Name name = Name.valueOf(object);
            if (this.nodeIdToNodeSpecMap.get(name) == null) {
                linkedList2.add(refinement2.getName());
                continue;
            }
            this.nodeIdToRefinementMap.put(name, refinement2);
        }
        if (linkedList.isEmpty() && linkedList2.isEmpty()) {
            return;
        }
        Object object = "Some refinements aren't connected properly: ";
        if (!linkedList.isEmpty()) {
            object = (String)object + "Refinements that lack an expands annotation: " + Strings.conjunction(linkedList) + ".  ";
        }
        if (!linkedList2.isEmpty()) {
            object = (String)object + "Refinements that expand a nonexistent node: " + Strings.conjunction(linkedList2) + ".";
        }
        throw new InvalidPlanDomain((String)object);
    }

    PlanRefinement makePlanRefinement(Refinement refinement) {
        PlanRefinement planRefinement = new PlanRefinement();
        planRefinement.setId(Name.valueOf(refinement.getName()));
        Name name = Name.valueOf(refinement.getAnnotation(EXPANDS));
        planRefinement.setExpands(name);
        planRefinement.setPlanVariableDeclarations(this.makePlanVarDcls(refinement, VariableScope.LOCAL));
        planRefinement.setPlanNodes(this.makePlanNodes(refinement));
        planRefinement.setConstraints(this.getConstrainers(refinement));
        return planRefinement;
    }

    ListOfPlanNode makePlanNodes(Refinement refinement) {
        if (refinement.getNodes() == null) {
            return null;
        }
        LinkedListOfPlanNode linkedListOfPlanNode = new LinkedListOfPlanNode();
        for (NodeSpec nodeSpec : refinement.getNodes()) {
            linkedListOfPlanNode.add(this.makePlanNode(nodeSpec));
        }
        return linkedListOfPlanNode;
    }

    PlanNode makePlanNode(NodeSpec nodeSpec) {
        LList lList = this.patternForPlan(nodeSpec.getPattern());
        Activity activity = new Activity(lList);
        PlanNode planNode = new PlanNode(nodeSpec.getId(), activity);
        Refinement refinement = this.nodeIdToRefinementMap.get(nodeSpec.getId());
        if (refinement != null) {
            planNode.setExpansion(Name.valueOf(refinement.getName()));
            Object object = refinement.getAnnotation(ActivityItem.EXPANSION_REFINEMENT_NAME);
            if (object != null) {
                activity.setAnnotation(ActivityItem.EXPANSION_REFINEMENT_NAME, object);
            }
        }
        return planNode;
    }

    ListOfPlanVariableDeclaration makePlanVarDcls(Refinement refinement, VariableScope variableScope) {
        ListOfVariableDeclaration listOfVariableDeclaration = refinement.getVariableDeclarations();
        if (listOfVariableDeclaration == null) {
            return null;
        }
        LinkedListOfPlanVariableDeclaration linkedListOfPlanVariableDeclaration = new LinkedListOfPlanVariableDeclaration();
        for (VariableDeclaration variableDeclaration : listOfVariableDeclaration) {
            linkedListOfPlanVariableDeclaration.add(this.makePlanVarDcl(variableDeclaration.getName(), variableScope));
        }
        return linkedListOfPlanVariableDeclaration;
    }

    ListOfConstrainer getConstrainers(Refinement refinement) {
        LinkedListOfConstrainer linkedListOfConstrainer = new LinkedListOfConstrainer();
        if (refinement.getOrderings() != null) {
            linkedListOfConstrainer.addAll(refinement.getOrderings());
        }
        if (refinement.getConstraints() != null) {
            linkedListOfConstrainer.addAll(refinement.getConstraints());
        }
        return linkedListOfConstrainer.isEmpty() ? null : linkedListOfConstrainer;
    }

    LList patternForPlan(List list) {
        LListCollector lListCollector = new LListCollector();
        for (Object e : list) {
            if (e instanceof ItemVar) {
                lListCollector.add(this.getPlanVar((ItemVar)e));
                continue;
            }
            if (e instanceof List) {
                lListCollector.add(this.patternForPlan((List)e));
                continue;
            }
            lListCollector.add(e);
        }
        return lListCollector.contents();
    }

    ItemVar namePart(ItemVar itemVar) {
        return Util.mustBe(ItemVar.class, Symbol.intern(Strings.beforeLast(".", itemVar.toString())));
    }

    PlanVariable getPlanVar(ItemVar itemVar) {
        Debug.noteln("MAP -----", this.nameToPlanVarMap);
        PlanVariable planVariable = this.nameToPlanVarMap.get(itemVar);
        Debug.expect(planVariable != null, "Can't find plan variable for", itemVar);
        return planVariable;
    }

    PlanVariableDeclaration makePlanVarDcl(ItemVar itemVar, VariableScope variableScope) {
        PlanVariable planVariable = this.getPlanVar(itemVar);
        PlanVariableDeclaration planVariableDeclaration = new PlanVariableDeclaration();
        planVariableDeclaration.setId(planVariable.getId());
        planVariableDeclaration.setName(planVariable.getName());
        planVariableDeclaration.setScope(variableScope);
        return planVariableDeclaration;
    }

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        String string = Parameters.getParameter("domain");
        String string2 = Parameters.getParameter("output");
        if (string == null || string2 == null) {
            System.out.println("Usage: Must specify domain= and output=");
            System.exit(1);
        }
        Domain domain = XML.readObject(Domain.class, string);
        DomainAsPlan domainAsPlan = new DomainAsPlan(domain);
        XML.writeObject(domainAsPlan, string2);
    }

    class Pass1
    extends ObjectWalker {
        Pass1() {
        }

        public void walk(Object object) {
            if (object instanceof ItemVar) {
                this.walkItemVar((ItemVar)object);
            } else if (object instanceof NodeSpec) {
                this.walkNodeSpec((NodeSpec)object);
            } else {
                super.walk(object);
            }
        }

        private void walkItemVar(ItemVar itemVar) {
            PlanVariable planVariable = DomainAsPlan.this.nameToPlanVarMap.get(itemVar);
            if (planVariable == null) {
                planVariable = new PlanVariable(DomainAsPlan.this.nameGen.nextName("var"), DomainAsPlan.this.namePart(itemVar));
                DomainAsPlan.this.nameToPlanVarMap.put(itemVar, planVariable);
            }
        }

        private void walkNodeSpec(NodeSpec nodeSpec) {
            DomainAsPlan.this.nodeIdToNodeSpecMap.put(nodeSpec.getId(), nodeSpec);
        }

        public void visitElement(Object object) {
            if (!(object instanceof Domain)) {
                this.walk(object);
            }
        }
    }

    public static class InvalidPlanDomain
    extends RuntimeException {
        public InvalidPlanDomain(String string) {
            super(string);
        }
    }
}

