/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.log;

import ix.icore.IXAgent;
import ix.icore.Sendable;
import ix.icore.log.HistoryComment;
import ix.icore.log.HistoryEvent;
import ix.icore.log.MessageReceived;
import ix.icore.log.MessageSent;
import ix.test.PlainIp2;
import ix.util.IPC;
import ix.util.ISODateFormat;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.ipc.IPCListener;
import ix.util.xml.XML;
import ix.util.xml.XMLTranslator;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class EventLogger {
    IXAgent agent;
    XMLTranslator xmlt = XML.config().makeXMLTranslator();
    XMLOutputter outputter = XML.makePrettyXMLOutputter();
    String logDir;
    String logFileName;
    OutputStream logStream = null;

    public EventLogger(IXAgent iXAgent) {
        this.agent = iXAgent;
        Format format = this.outputter.getFormat();
        format.setOmitDeclaration(true);
        this.outputter.setFormat(format);
    }

    public void processCommandLineArguments() {
        this.logDir = Parameters.getParameter("log-directory");
    }

    String makeLogName() {
        String string = new ISODateFormat().formatDateTime(new Date());
        string = Strings.replaceChars(":", "-", string);
        return this.agent.getAgentSymbolName() + "-" + string + ".log";
    }

    public synchronized void install() {
        IPC.addIPCListener(new LoggingIPCListener());
    }

    public synchronized boolean isLogging() {
        return this.logStream != null;
    }

    public synchronized void startLogging() {
        try {
            this.logFileName = this.logDir + "/" + this.makeLogName();
            this.logStream = new BufferedOutputStream(new FileOutputStream(this.logFileName));
            this.log(new HistoryComment("Logging started."));
        }
        catch (Throwable throwable) {
            throw new RethrownException("Can't start logging because", throwable);
        }
    }

    public synchronized void log(HistoryEvent historyEvent) {
        if (this.logStream == null) {
            return;
        }
        try {
            if (historyEvent.getDate() == null) {
                historyEvent.setDate(new Date());
            }
            if (historyEvent.getAgent() == null) {
                historyEvent.setAgent(this.agent.getAgentSymbolName());
            }
            Document document = this.xmlt.objectToDocument(historyEvent);
            this.outputter.output(document, this.logStream);
            this.logStream.flush();
        }
        catch (Throwable throwable) {
            throw new RethrownException("Problem while logging:", throwable);
        }
    }

    public static void main(String[] stringArray) {
        PlainIp2 plainIp2 = new PlainIp2();
        plainIp2.mainStartup(stringArray);
        EventLogger eventLogger = new EventLogger(plainIp2);
        eventLogger.processCommandLineArguments();
        eventLogger.startLogging();
    }

    class LoggingIPCListener
    extends IPCListener {
        LoggingIPCListener() {
        }

        public void sendingMessage(Object object, Object object2) {
        }

        public void messageSent(Object object, Object object2) {
            EventLogger.this.log(new MessageSent(object, object2));
        }

        public void messageReceived(IPC.InputMessage inputMessage) {
            Object object = inputMessage.getContents();
            Name name = object instanceof Sendable ? ((Sendable)object).getSenderId() : null;
            EventLogger.this.log(new MessageReceived(name, object));
        }
    }
}

