/*
 * Decompiled with CFR 0.152.
 */
package ix.icore.domain;

import ix.util.Collect;
import ix.util.Fn;
import ix.util.Strings;
import ix.util.lisp.ItemVar;
import java.util.Collections;
import java.util.Set;

public class MissingValuesException
extends RuntimeException {
    Set unboundVars;

    public MissingValuesException(ItemVar itemVar) {
        super("No value was found for variable " + itemVar);
        this.unboundVars = Collections.singleton(itemVar);
    }

    public MissingValuesException(Set set) {
        super("No value was found for " + Strings.disjunction(set));
        if (!Collect.every(set, Fn.isInstanceOf(ItemVar.class))) {
            throw new ClassCastException("The set " + set + " does not contain only ItemVars.");
        }
        this.unboundVars = set;
    }

    public Set getUnboundVariables() {
        return this.unboundVars;
    }
}

