/*
 * Decompiled with CFR 0.152.
 */
package ix.http;

import ix.http.HttpNameServer;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.RethrownIOException;
import ix.util.Util;
import ix.util.http.HttpObjectClient;
import ix.util.http.HttpObjectServlet;
import ix.util.http.HttpServer;
import ix.util.http.HttpUtilities;
import ix.util.ipc.ServiceAddress;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HttpCommunicationStrategy
implements IPC.CommunicationStrategy {
    private Map<String, URL> nameToAddrMap = new Hashtable<String, URL>();
    private URL nameServerURL;
    private HttpNameServer.Syntax syntax = new HttpNameServer.Syntax();
    private String thisAgentsName;
    private IPC.MessageListener messageListener;
    private HttpObjectClient http = new HttpObjectClient();
    private HttpUtilities util = new HttpUtilities();
    private HttpServer server;
    private int listenPort;

    public HttpCommunicationStrategy() {
        this(Parameters.getInt("port", 0));
    }

    public HttpCommunicationStrategy(int n) {
        this.listenPort = n;
    }

    public void setupServer(Object object, IPC.MessageListener messageListener) {
        this.thisAgentsName = (String)object;
        this.messageListener = messageListener;
        ServiceAddress serviceAddress = new ServiceAddress(Parameters.getParameter("name-server", HttpNameServer.DEFAULT_ADDRESS));
        this.nameServerURL = this.makeMessageURL(serviceAddress);
        this.server = new HttpServer(this.listenPort);
        this.server.addServlet(new CommServlet(), "/http-cs-message");
        this.server.start();
        this.listenPort = this.server.getServerPort();
        this.registerWithNameServer();
    }

    private URL makeMessageURL(ServiceAddress serviceAddress) {
        return this.util.makeMessageURL(serviceAddress, "/http-cs-message");
    }

    protected void registerWithNameServer() {
        ServiceAddress serviceAddress = new ServiceAddress(this.util.getHostName(), this.listenPort);
        Object object = HttpNameServer.Syntax.makeRegisterMessage(this.thisAgentsName, serviceAddress);
        Object object2 = this.requestObject(this.nameServerURL, object);
        Debug.expectEquals("OK", object2, "Problem registering with name-server.");
    }

    public void sendObject(Object object, Object object2) {
        try {
            Object object3 = this.requestObject((String)object, object2);
            Debug.expectEquals("OK", object3, "Invalid response from " + object + ". ");
        }
        catch (RethrownIOException rethrownIOException) {
            Debug.displayException(rethrownIOException);
            this.nameToAddrMap.remove(object);
        }
    }

    private Object requestObject(String string, Object object) {
        return this.requestObject(this.getAddress(string), object);
    }

    private Object requestObject(URL uRL, Object object) {
        return this.http.sendRequest(uRL, object);
    }

    private URL getAddress(String string) {
        URL uRL = this.nameToAddrMap.get(string);
        if (uRL == null) {
            uRL = this.askNameServer(string);
            this.nameToAddrMap.put(string, uRL);
        }
        return uRL;
    }

    private URL askNameServer(String string) {
        String string2 = string;
        Object object = HttpNameServer.Syntax.makeLookupMessage(string2);
        ServiceAddress serviceAddress = Util.mustBe(ServiceAddress.class, this.requestObject(this.nameServerURL, object));
        return this.makeMessageURL(serviceAddress);
    }

    protected Object handleInput(Object object) {
        this.messageListener.messageReceived(new IPC.BasicInputMessage(object));
        return "OK";
    }

    private class CommServlet
    extends HttpObjectServlet {
        private CommServlet() {
        }

        protected Object handleRequest(HttpServletRequest httpServletRequest, Object object) {
            return HttpCommunicationStrategy.this.handleInput(object);
        }
    }
}

