/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.mindswap.utils.Consts;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLOperation
implements Consts {
    private boolean DEBUG = true;
    private WSDLService service = null;
    private Call call = null;
    private Vector inputs = new Vector();
    private Vector outputs = new Vector();
    private String inputMessageName;
    private String outputMessageName;
    private String portName;
    private String documentation;

    public WSDLOperation(Call c) {
        this.call = c;
    }

    public WSDLParameter getInput(int i) {
        return (WSDLParameter)this.getInputs().elementAt(i);
    }

    public WSDLParameter getInput(String name) {
        int i = this.inputs.indexOf(new WSDLParameter(name, null));
        return i != -1 ? (WSDLParameter)this.inputs.get(i) : null;
    }

    public WSDLParameter getOutput(int i) {
        return (WSDLParameter)this.getOutputs().elementAt(i);
    }

    public WSDLParameter getOutput(String name) {
        int i = this.outputs.indexOf(new WSDLParameter(name, null));
        return i != -1 ? (WSDLParameter)this.outputs.get(i) : null;
    }

    public Vector getInputs() {
        return this.inputs;
    }

    public Vector getOutputs() {
        return this.outputs;
    }

    void addInput(String name, QName type) {
        this.inputs.add(new WSDLParameter(name, type));
    }

    void addOutput(String name, QName type) {
        this.outputs.add(new WSDLParameter(name, type));
    }

    public String getName() {
        return this.call.getOperationName().getLocalPart();
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String s) {
        this.portName = s;
    }

    public String getInputMessageName() {
        return this.inputMessageName;
    }

    public void setInputMessageName(String s) {
        this.inputMessageName = s;
    }

    public String getOutputMessageName() {
        return this.outputMessageName;
    }

    public void setOutputMessageName(String s) {
        this.outputMessageName = s;
    }

    public WSDLService getService() {
        return this.service;
    }

    public void setService(WSDLService s) {
        this.service = s;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String s) {
        this.documentation = s;
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        WSDLParameter param;
        String s = String.valueOf(this.getName()) + "(";
        Iterator i = this.inputs.iterator();
        while (i.hasNext()) {
            param = (WSDLParameter)i.next();
            s = String.valueOf(s) + param.getName() + ":" + param.getType().getLocalPart();
            if (!i.hasNext()) continue;
            s = String.valueOf(s) + ", ";
        }
        s = String.valueOf(s) + ") -> (";
        i = this.outputs.iterator();
        while (i.hasNext()) {
            param = (WSDLParameter)i.next();
            s = String.valueOf(s) + param.getName() + ":" + param.getType().getLocalPart();
            if (!i.hasNext()) continue;
            s = String.valueOf(s) + ", ";
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    public boolean invoke() {
        try {
            SOAPEnvelope request = this.createRequest();
            if (this.DEBUG) {
                System.out.println("Invoke operation " + this.getDescription());
                System.out.println(request);
            }
            SOAPEnvelope reply = this.call.invoke(request);
            if (this.DEBUG) {
                System.out.println(reply);
            }
            this.processResult(reply);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean processResult(SOAPEnvelope reply) {
        try {
            SOAPElement soapBody = (SOAPElement)reply.getBody();
            SOAPElement response = (SOAPElement)soapBody.getChildElements().next();
            Iterator messageParts = response.getChildElements();
            int i = 0;
            while (i < this.outputs.size()) {
                SOAPElement e = (SOAPElement)messageParts.next();
                if (this.DEBUG) {
                    System.out.println("processResult " + e);
                    System.out.println("getValue " + e.getValue());
                }
                WSDLParameter output = (WSDLParameter)this.outputs.elementAt(0);
                output.setTextValue(e.toString());
                output.setValue(e.getValue());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private SOAPEnvelope createRequest() throws SOAPException {
        boolean isDotNetService;
        String targetNamespace = this.call.getOperationName().getNamespaceURI();
        String opName = this.call.getOperationName().getLocalPart();
        SOAPEnvelope envelope = new SOAPEnvelope();
        if (this.DEBUG) {
            System.out.println("SOAP Action = " + this.call.getSOAPActionURI());
            System.out.println("SOAP Action used = " + this.call.useSOAPAction());
        }
        envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        String inputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        if (inputEncodingStyle != null) {
            envelope.setEncodingStyle(inputEncodingStyle);
            envelope.addAttribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", inputEncodingStyle);
        }
        String nsOp = (isDotNetService = this.getService().getFileURI().toLowerCase().endsWith("?wsdl")) ? "" : "u";
        SOAPBodyElement soapBody = new SOAPBodyElement(envelope.createName(opName, nsOp, targetNamespace));
        envelope.addBodyElement(soapBody);
        Iterator i = this.inputs.iterator();
        while (i.hasNext()) {
            WSDLParameter param = (WSDLParameter)i.next();
            Object paramValue = param.getValue();
            SOAPElement soapElement = soapBody.addChildElement(param.getName(), "");
            if (paramValue instanceof Node) {
                if (this.DEBUG) {
                    System.out.println("Case 1");
                }
                this.createSOAPElement(soapElement, (Node)paramValue);
                if (soapElement.getAttributeValue((Name)Consts.xsiType) != null) continue;
                System.out.println("Case 1a");
                soapElement.addAttribute((Name)Consts.xsiType, "u:" + param.getType().getLocalPart());
                continue;
            }
            if (this.DEBUG) {
                System.out.println("Case 2 " + param.getType());
            }
            System.out.println("xsiURI http://www.w3.org/2001/XMLSchema-instance");
            Name x = envelope.createName("type", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
            soapElement.addAttribute(x, "xsd:string");
            soapElement.addTextNode(paramValue.toString());
        }
        return envelope;
    }

    public void createSOAPElement(SOAPElement parent, Node node) throws SOAPException {
        short type = node.getNodeType();
        if (type == 3) {
            if (this.DEBUG) {
                System.out.println("Case 3");
            }
            parent.addAttribute((Name)Consts.xsiType, "xsd:string");
            parent.addTextNode(node.getNodeValue());
        } else if (type == 1) {
            SOAPElement soapElement;
            if (!(node.getParentNode() instanceof Document)) {
                if (this.DEBUG) {
                    System.out.println("Case 4");
                }
                soapElement = parent.addChildElement(node.getNodeName());
            } else {
                if (this.DEBUG) {
                    System.out.println("Case 5");
                }
                soapElement = parent;
            }
            NodeList children = node.getChildNodes();
            if (children != null) {
                int len = children.getLength();
                int i = 0;
                while (i < len) {
                    this.createSOAPElement(soapElement, children.item(i));
                    ++i;
                }
            }
        }
    }
}

