/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.process.impl;

import java.util.Hashtable;
import java.util.Map;
import org.mindswap.owls.process.DataFlow;
import org.mindswap.owls.process.DataFlowElement;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ValueMap;
import org.mindswap.owls.process.ValueRewriter;

public class ValueMapImpl
extends Hashtable
implements ValueMap {
    public void setValue(Parameter p, Object value) {
        if (p == null) {
            throw new NullPointerException("ValueMap cannot set a value for null parameter");
        }
        if (value == null) {
            throw new NullPointerException("Value of parameter " + p + " cannot be set to null");
        }
        this.put(p, value);
    }

    public Object getValue(Parameter p) {
        return this.get(p);
    }

    public boolean hasValue(Parameter p) {
        return this.containsKey(p);
    }

    public void clearValue(Parameter p) {
        this.remove(p);
    }

    public void addMap(ValueMap valueMap) {
        this.putAll(valueMap);
    }

    public void applyDataFlow(DataFlow dataFlow) {
        this.applyDataFlow(dataFlow, null);
    }

    public void applyDataFlow(DataFlow dataFlow, ValueRewriter rewriter) {
        Map.Entry[] entries = new Map.Entry[this.size()];
        this.entrySet().toArray(entries);
        int i = 0;
        while (i < entries.length) {
            Map.Entry entry = entries[i];
            Parameter p = (Parameter)entry.getKey();
            Object value = entry.getValue();
            DataFlowElement dfe = dataFlow.getDFE(p);
            if (dfe != null) {
                int j = 0;
                while (j < dfe.size()) {
                    Parameter x = dfe.parameterAt(j);
                    Object exists = this.getValue(x);
                    if (exists != null) {
                        if (!value.equals(exists)) {
                            System.err.println("Warning: Two different values are assigned to " + p);
                        }
                    } else {
                        if (rewriter != null) {
                            value = rewriter.rewrite(value.toString(), p.getType().getURI(), x.getType().getURI());
                        }
                        this.setValue(x, value);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

