/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.mindswap.owl.OWLResource;
import org.mindswap.owl.impl.OWLResourceImpl;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.impl.GroundingImpl;
import org.mindswap.owls.grounding.impl.MessageMapImpl;
import org.mindswap.owls.grounding.impl.MessageMapListImpl;
import org.mindswap.owls.grounding.impl.UPnPAtomicGroundingImpl;
import org.mindswap.owls.grounding.impl.WSDLAtomicGroundingImpl;
import org.mindswap.owls.io.OWLSReader;
import org.mindswap.owls.io.OWLSWriter;
import org.mindswap.owls.io.impl.DAMLSReader_0_7;
import org.mindswap.owls.io.impl.GenericOWLSReader;
import org.mindswap.owls.io.impl.GenericOWLSWriter;
import org.mindswap.owls.io.impl.OWLSReader_0_9;
import org.mindswap.owls.io.impl.OWLSReader_1_0;
import org.mindswap.owls.io.impl.OWLSWriter_0_9;
import org.mindswap.owls.io.impl.OWLSWriter_1_0;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ConditionList;
import org.mindswap.owls.process.DataFlow;
import org.mindswap.owls.process.DataFlowElement;
import org.mindswap.owls.process.Effect;
import org.mindswap.owls.process.EffectList;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputList;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.ProcessComponentList;
import org.mindswap.owls.process.ProcessModel;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.Unordered;
import org.mindswap.owls.process.ValueMap;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.execution.impl.ProcessExecutionEngineImpl;
import org.mindswap.owls.process.impl.AtomicProcessImpl;
import org.mindswap.owls.process.impl.ChoiceImpl;
import org.mindswap.owls.process.impl.CompositeProcessImpl;
import org.mindswap.owls.process.impl.ConditionImpl;
import org.mindswap.owls.process.impl.ConditionListImpl;
import org.mindswap.owls.process.impl.DataFlowElementImpl;
import org.mindswap.owls.process.impl.DataFlowImpl;
import org.mindswap.owls.process.impl.EffectImpl;
import org.mindswap.owls.process.impl.EffectListImpl;
import org.mindswap.owls.process.impl.InputImpl;
import org.mindswap.owls.process.impl.InputListImpl;
import org.mindswap.owls.process.impl.OutputImpl;
import org.mindswap.owls.process.impl.OutputListImpl;
import org.mindswap.owls.process.impl.ParameterListImpl;
import org.mindswap.owls.process.impl.ProcessComponentListImpl;
import org.mindswap.owls.process.impl.ProcessModelImpl;
import org.mindswap.owls.process.impl.SequenceImpl;
import org.mindswap.owls.process.impl.UnorderedImpl;
import org.mindswap.owls.process.impl.ValueMapImpl;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.impl.ProfileImpl;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.service.impl.ServiceImpl;
import org.mindswap.owls.vocabulary.DAMLS_0_7;
import org.mindswap.owls.vocabulary.OWLS;
import org.mindswap.owls.vocabulary.OWLS_0_9;
import org.mindswap.owls.vocabulary.OWLS_1_0;

public class OWLSFactory {
    private static OWLSFactory factory = new OWLSFactory();
    private static Model jena = ModelFactory.createDefaultModel();
    public static final String[] supportedVersions = new String[]{"0.7", "0.9", "1.0"};

    public static OWLSFactory getFactory() {
        return factory;
    }

    public static List getSupportedVersions() {
        return Arrays.asList(supportedVersions);
    }

    public static String getLatestVersion() {
        return supportedVersions[supportedVersions.length - 1];
    }

    public static OWLS getVocabulary() {
        return OWLSFactory.getVocabulary(OWLSFactory.getLatestVersion());
    }

    public static OWLS getVocabulary(String version) {
        if (version.equals("0.7")) {
            return DAMLS_0_7.instance;
        }
        if (version.equals("0.9")) {
            return OWLS_0_9.instance;
        }
        if (version.equals("1.0")) {
            return OWLS_1_0.instance;
        }
        throw new IllegalArgumentException("There is no vocabulary for OWL-S version " + version);
    }

    public static ProcessExecutionEngine createExecutionEngine() {
        return new ProcessExecutionEngineImpl();
    }

    public static OWLSReader createOWLSReader() {
        return new GenericOWLSReader();
    }

    public static OWLSReader createOWLSReader(String version) {
        if (version.equals("0.7")) {
            return new DAMLSReader_0_7();
        }
        if (version.equals("0.9")) {
            return new OWLSReader_0_9();
        }
        if (version.equals("1.0")) {
            return new OWLSReader_1_0();
        }
        throw new IllegalArgumentException("There is no reader for OWLS version " + version);
    }

    public static OWLSWriter createOWLSWriter() {
        return new GenericOWLSWriter();
    }

    public static OWLSWriter createOWLSWriter(String version) {
        if (version.equals("0.9")) {
            return new OWLSWriter_0_9();
        }
        if (version.equals("1.0")) {
            return new OWLSWriter_1_0();
        }
        throw new IllegalArgumentException("There is no writer for OWLS version " + version);
    }

    public static OWLResource createOWLResource(URI uri) {
        return new OWLResourceImpl(jena.createResource(uri.toString()));
    }

    public static OWLResource createOWLResource(Resource r) {
        return new OWLResourceImpl(r);
    }

    public static Service createService() {
        return OWLSFactory.createService(null);
    }

    public static Service createService(Resource resource) {
        return new ServiceImpl(resource);
    }

    public static Profile createProfile() {
        return OWLSFactory.createProfile(null);
    }

    public static Profile createProfile(Resource resource) {
        return new ProfileImpl(resource);
    }

    public static Grounding createGrounding() {
        return OWLSFactory.createGrounding(null);
    }

    public static Grounding createGrounding(Resource resource) {
        return new GroundingImpl(resource);
    }

    public static ProcessModel createProcessModel() {
        return OWLSFactory.createProcessModel(null);
    }

    public static ProcessModel createProcessModel(Resource resource) {
        return new ProcessModelImpl(resource);
    }

    public static AtomicProcess createAtomicProcess() {
        return OWLSFactory.createAtomicProcess(null);
    }

    public static AtomicProcess createAtomicProcess(Resource resource) {
        return new AtomicProcessImpl(resource);
    }

    public static CompositeProcess createCompositeProcess() {
        return OWLSFactory.createCompositeProcess(null);
    }

    public static CompositeProcess createCompositeProcess(Resource resource) {
        return new CompositeProcessImpl(resource);
    }

    public static Sequence createSequence() {
        return OWLSFactory.createSequence(null);
    }

    public static Sequence createSequence(Resource resource) {
        return new SequenceImpl(resource);
    }

    public static Choice createChoice() {
        return OWLSFactory.createChoice(null);
    }

    public static Choice createChoice(Resource resource) {
        return new ChoiceImpl(resource);
    }

    public static Unordered createUnordered() {
        return OWLSFactory.createUnordered(null);
    }

    public static Unordered createUnordered(Resource resource) {
        return new UnorderedImpl(resource);
    }

    public static Input createInput(Resource resource) {
        return new InputImpl(resource);
    }

    public static Output createOutput(Resource resource) {
        return new OutputImpl(resource);
    }

    public static Condition createCondition(Resource r) {
        return new ConditionImpl(r);
    }

    public static Effect createEffect(Resource r) {
        return new EffectImpl(r);
    }

    public static WSDLAtomicGrounding createWSDLAtomicGrounding() {
        return OWLSFactory.createWSDLAtomicGrounding(null);
    }

    public static WSDLAtomicGrounding createWSDLAtomicGrounding(Resource resource) {
        return new WSDLAtomicGroundingImpl(resource);
    }

    public static UPnPAtomicGrounding createUPnPAtomicGrounding() {
        return OWLSFactory.createUPnPAtomicGrounding(null);
    }

    public static UPnPAtomicGrounding createUPnPAtomicGrounding(Resource resource) {
        return new UPnPAtomicGroundingImpl(resource);
    }

    public static DataFlow createDataFlow() {
        return new DataFlowImpl();
    }

    public static DataFlowElement createDataFlowElement() {
        return new DataFlowElementImpl();
    }

    public static MessageMap createMessageMap() {
        return OWLSFactory.createMessageMap(null);
    }

    public static MessageMap createMessageMap(Resource resource) {
        return new MessageMapImpl(resource);
    }

    public static ParameterList createParameterList() {
        return new ParameterListImpl();
    }

    public static InputList createInputList() {
        return new InputListImpl();
    }

    public static OutputList createOutputList() {
        return new OutputListImpl();
    }

    public static EffectList createEffectList() {
        return new EffectListImpl();
    }

    public static ConditionList createConditionList() {
        return new ConditionListImpl();
    }

    public static MessageMapList createMessageMapList() {
        return new MessageMapListImpl();
    }

    public static ValueMap createValueMap() {
        return new ValueMapImpl();
    }

    public static ProcessComponentList createProcessComponentList() {
        return new ProcessComponentListImpl();
    }
}

