/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import com.hp.hpl.jena.rdf.model.Model;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.OWLReasoner;
import org.mindswap.owl.Util;
import org.mindswap.owl.vocabulary.OWL;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.OWLParser;

public class OWLReasonerImpl
implements OWLReasoner {
    OWLReader parser = OWLFactory.createOWLReader();
    org.mindswap.pellet.OWLReasoner reasoner = new org.mindswap.pellet.OWLReasoner();
    HashSet loadedFiles = new HashSet();

    public void load(URI uri) throws Exception {
        org.mindswap.pellet.OWLReasoner temp = null;
        Model[] models = this.parser.readSeparate(uri);
        int i = 1;
        while (i < models.length) {
            URI name = this.parser.getModelURI(models[i]);
            if (!this.loadedFiles.contains(name)) {
                this.loadedFiles.add(name);
                OWLParser.SHOW_INFO = false;
                temp = new org.mindswap.pellet.OWLReasoner();
                temp.loadOntology(models[i]);
                int nonDL = OWLParser.nonDL.size();
                if (nonDL < 5) {
                    System.out.println("Load OWL DL document (" + nonDL + ") " + name);
                    OWLParser.SHOW_INFO = true;
                    this.reasoner.loadOntology(models[i]);
                }
            }
            ++i;
        }
    }

    public boolean isClass(URI uri) {
        return this.reasoner.isClass(Util.toResource(uri));
    }

    public boolean isSubclassOf(URI uri1, URI uri2) {
        try {
            this.reasoner.classify();
            return this.reasoner.isSubclassOf(Util.toResource(uri1), Util.toResource(uri2));
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public List getSubClasses(URI uri) {
        try {
            this.reasoner.classify();
            Vector list = this.reasoner.getClassification().getSubClasses((ATerm)Util.toATerm(uri));
            return this.toURIList(list);
        }
        catch (RuntimeException e) {
            return new ArrayList();
        }
    }

    public List getSuperClasses(URI uri) {
        try {
            this.reasoner.classify();
            Vector list = this.reasoner.getClassification().getSuperClasses((ATerm)Util.toATerm(uri));
            return this.toURIList(list);
        }
        catch (RuntimeException e) {
            return new ArrayList();
        }
    }

    private List toURIList(List list) {
        ArrayList<URI> results = new ArrayList<URI>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            URI uri = null;
            if (c.equals((Object)ATermUtils.TOP)) {
                uri = OWL.Thing;
                continue;
            }
            if (c.equals((Object)ATermUtils.BOTTOM)) {
                uri = OWL.Nothing;
                continue;
            }
            results.add(Util.toURI(c));
        }
        return results;
    }

    public String rewrite(String individual, URI sourceC, URI targetC) {
        String result = individual;
        if (sourceC.equals(targetC)) {
            return result;
        }
        String sourceNS = Util.getNameSpace(sourceC);
        String sourceName = Util.getLocalName(sourceC);
        String targetNS = Util.getNameSpace(targetC);
        String targetName = Util.getLocalName(targetC);
        if (!sourceNS.equals(targetNS)) {
            result = result.replaceAll(sourceNS, targetNS);
        }
        if (!sourceName.equals(targetName)) {
            result = result.replaceAll(sourceName, targetName);
        }
        return result;
    }
}

