/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class Util {
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$Util;

    public static boolean isNumeric(Node node) {
        if (node.isLiteral()) {
            Object object = node.getLiteral().getValue();
            return object instanceof Number;
        }
        return false;
    }

    public static int getIntValue(Node node) {
        return ((Number)node.getLiteral().getValue()).intValue();
    }

    public static int compareNumbers(Node node, Node node2) {
        if (node.isLiteral() && node2.isLiteral()) {
            Object object = node.getLiteral().getValue();
            Object object2 = node2.getLiteral().getValue();
            if (object instanceof Number && object2 instanceof Number) {
                long l;
                if (object instanceof Float || object instanceof Double || object instanceof Float || object2 instanceof Double) {
                    double d;
                    double d2 = ((Number)object).doubleValue();
                    return d2 < (d = ((Number)object2).doubleValue()) ? -1 : (d2 == d ? 0 : 1);
                }
                long l2 = ((Number)object).longValue();
                return l2 < (l = ((Number)object2).longValue()) ? -1 : (l2 == l ? 0 : 1);
            }
        }
        throw new ClassCastException("Non-numeric literal in compareNumbers");
    }

    public static Node getPropValue(Node node, Node node2, Finder finder) {
        return Util.doGetPropValue(finder.find(new TriplePattern(node, node2, null)));
    }

    public static Node getPropValue(Node node, Node node2, Graph graph) {
        return Util.doGetPropValue(graph.find(node, node2, null));
    }

    public static Node getPropValue(Node node, Node node2, RuleContext ruleContext) {
        return Util.doGetPropValue(ruleContext.find(node, node2, null));
    }

    private static Node doGetPropValue(ClosableIterator closableIterator) {
        Node node = null;
        if (closableIterator.hasNext()) {
            node = ((Triple)closableIterator.next()).getObject();
        }
        closableIterator.close();
        return node;
    }

    public static List convertList(Node node, RuleContext ruleContext) {
        return Util.convertList(node, ruleContext, new LinkedList());
    }

    private static List convertList(Node node, RuleContext ruleContext, List list) {
        if (node == null || node.equals(RDF.nil.asNode())) {
            return list;
        }
        list.add(Util.getPropValue(node, RDF.first.asNode(), ruleContext));
        return Util.convertList(Util.getPropValue(node, RDF.rest.asNode(), ruleContext), ruleContext, list);
    }

    public static Node makeIntNode(int n) {
        return Node.createLiteral(new LiteralLabel(new Integer(n)));
    }

    public static Node makeLongNode(long l) {
        if (l > Integer.MAX_VALUE) {
            return Node.createLiteral(new LiteralLabel(new Long(l)));
        }
        return Node.createLiteral(new LiteralLabel(new Integer((int)l)));
    }

    public static Node makeDoubleNode(double d) {
        return Node.createLiteral(new LiteralLabel(new Double(d)));
    }

    public static BufferedReader openResourceFile(String string) throws IOException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null && (inputStream = (class$com$hp$hpl$jena$reasoner$rulesys$Util == null ? (class$com$hp$hpl$jena$reasoner$rulesys$Util = Util.class$("com.hp.hpl.jena.reasoner.rulesys.Util")) : class$com$hp$hpl$jena$reasoner$rulesys$Util).getResourceAsStream("/" + string)) == null) {
            inputStream = new FileInputStream(string);
        }
        return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
    }

    public static String loadResourceFile(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = Util.openResourceFile(string);
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.startsWith("#") || string2.startsWith("//")) continue;
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String loadURLFile(String string) throws IOException {
        int n;
        BufferedReader bufferedReader;
        Object object;
        try {
            object = new URL(string);
            bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
        }
        catch (MalformedURLException malformedURLException) {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        object = new StringWriter(1024);
        char[] cArray = new char[1024];
        while (bufferedReader.ready() && (n = bufferedReader.read(cArray)) > 0) {
            ((StringWriter)object).write(cArray, 0, n);
        }
        bufferedReader.close();
        ((StringWriter)object).close();
        return ((StringWriter)object).toString();
    }

    public static Boolean checkBinaryPredicate(Property property, Resource resource) {
        StmtIterator stmtIterator = resource.listProperties(property);
        if (stmtIterator.hasNext()) {
            return new Boolean(((Object)stmtIterator.nextStatement().getObject()).toString().equalsIgnoreCase("true"));
        }
        return null;
    }

    public static Integer getIntegerPredicate(Property property, Resource resource) {
        RDFNode rDFNode;
        StmtIterator stmtIterator = resource.listProperties(property);
        if (stmtIterator.hasNext() && (rDFNode = stmtIterator.nextStatement().getObject()) instanceof Literal) {
            return new Integer(((Literal)rDFNode).getInt());
        }
        return null;
    }

    public static boolean convertBooleanPredicateArg(Property property, Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return ((String)object).equalsIgnoreCase("true");
        }
        throw new IllegalParameterException("Illegal type for " + property + " setting - use a Boolean");
    }

    public static int convertIntegerPredicateArg(Property property, Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalParameterException("Illegal type for " + property + " setting - use an integer");
            }
        }
        throw new IllegalParameterException("Illegal type for " + property + " setting - use an integer");
    }

    public static void updateParameter(Resource resource, Property property, Object object) {
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            stmtIterator.next();
            stmtIterator.remove();
        }
        resource.addProperty(property, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

