/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import java.util.Iterator;
import java.util.List;

public class ModelListenerAdapter
implements GraphListener {
    protected ModelCom m;
    protected ModelChangedListener L;

    ModelListenerAdapter(ModelCom modelCom, ModelChangedListener modelChangedListener) {
        this.m = modelCom;
        this.L = modelChangedListener;
    }

    public void notifyAddArray(Triple[] tripleArray) {
        this.L.addedStatements(this.m.asStatements(tripleArray));
    }

    public void notifyDeleteArray(Triple[] tripleArray) {
        this.L.removedStatements(this.m.asStatements(tripleArray));
    }

    public void notifyAddTriple(Triple triple) {
        this.L.addedStatement(this.m.asStatement(triple));
    }

    public void notifyAddList(List list) {
        this.L.addedStatements(this.m.asStatements(list));
    }

    public void notifyAddIterator(Iterator iterator) {
        this.L.addedStatements(this.m.asStatements(iterator));
    }

    public void notifyAddGraph(Graph graph) {
        this.L.addedStatements(this.m.asModel(graph));
    }

    public void notifyDeleteIterator(Iterator iterator) {
        this.L.removedStatements(this.m.asStatements(iterator));
    }

    public void notifyDeleteTriple(Triple triple) {
        this.L.removedStatement(this.m.asStatement(triple));
    }

    public void notifyAddIterator(List list) {
        this.L.addedStatements(this.m.asStatements(list));
    }

    public void notifyDeleteList(List list) {
        this.L.removedStatements(this.m.asStatements(list));
    }

    public void notifyDeleteGraph(Graph graph) {
        this.L.removedStatements(this.m.asModel(graph));
    }

    public boolean equals(Object object) {
        return object instanceof ModelListenerAdapter && ((ModelListenerAdapter)object).sameAs(this);
    }

    public boolean sameAs(ModelListenerAdapter modelListenerAdapter) {
        return this.L.equals(modelListenerAdapter.L) && this.m.equals(modelListenerAdapter.m);
    }
}

